/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.SingleKeyNonTxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.impl.AsyncInterceptorChainImpl;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestException;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="interceptors.AsyncInterceptorChainInvocationTest")
public class AsyncInterceptorChainInvocationTest
extends AbstractInfinispanTest {
    private final VisitableCommand testCommand = new GetKeyValueCommand((Object)"k", 0, 0L);
    private final VisitableCommand testSubCommand = new LockControlCommand((Object)"k", null, 0L, null);
    private final AtomicReference<String> sideEffects = new AtomicReference<String>("");

    public void testCompletedStage() {
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return "v1";
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return "v2";
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        Object returnValue = chain.invoke((InvocationContext)context, this.testCommand);
        AssertJUnit.assertEquals((Object)"v1", (Object)returnValue);
    }

    public void testAsyncStage() throws Exception {
        final CompletableFuture<String> f = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return 3.asyncValue((CompletionStage)f);
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f.complete("v1");
        AssertJUnit.assertEquals((Object)"v1", invokeFuture.get(10L, TimeUnit.SECONDS));
    }

    public void testComposeSync() {
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, t) -> "v1");
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return "v2";
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        Object returnValue = chain.invoke((InvocationContext)context, this.testCommand);
        AssertJUnit.assertEquals((Object)"v1", (Object)returnValue);
    }

    public void testComposeAsync() throws Exception {
        final CompletableFuture<String> f = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, t) -> 6.asyncValue((CompletionStage)f));
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return "v1";
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f.complete("v2");
        AssertJUnit.assertEquals((Object)"v2", invokeFuture.get(10L, TimeUnit.SECONDS));
    }

    public void testInvokeNextAsync() throws Exception {
        final CompletableFuture<String> f = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.asyncInvokeNext(ctx, command, f);
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return "v1";
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f.complete("v");
        AssertJUnit.assertEquals((Object)"v1", invokeFuture.get(10L, TimeUnit.SECONDS));
    }

    public void testInvokeNextSubCommand() {
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNext(ctx, AsyncInterceptorChainInvocationTest.this.testSubCommand);
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return command instanceof LockControlCommand ? "subCommand" : "command";
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        Object returnValue = chain.invoke((InvocationContext)context, this.testCommand);
        AssertJUnit.assertEquals((Object)"subCommand", (Object)returnValue);
    }

    public void testInvokeNextAsyncSubCommand() throws Exception {
        final CompletableFuture<String> f = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.asyncInvokeNext(ctx, this.this$0.testSubCommand, f);
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return command instanceof LockControlCommand ? "subCommand" : "command";
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f.complete("v");
        AssertJUnit.assertEquals((Object)"subCommand", invokeFuture.get(10L, TimeUnit.SECONDS));
    }

    public void testAsyncStageCompose() throws Exception {
        final CompletableFuture<String> f = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, t) -> "v1");
            }
        }, new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return 15.asyncValue((CompletionStage)f);
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f.complete("v2");
        AssertJUnit.assertEquals((Object)"v1", invokeFuture.get(10L, TimeUnit.SECONDS));
    }

    public void testAsyncStageComposeAsyncStage() throws Exception {
        final CompletableFuture<String> f1 = new CompletableFuture<String>();
        final CompletableFuture<String> f2 = new CompletableFuture<String>();
        final CompletableFuture<String> f3 = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, t) -> {
                    InvocationSuccessFunction function = (rCtx1, rCommand1, rv1) -> 16.asyncValue((CompletionStage)f3);
                    return 16.asyncValue((CompletionStage)f2).addCallback(rCtx, rCommand, (InvocationCallback)function);
                });
            }
        }, new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return 17.asyncValue((CompletionStage)f1);
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f1.complete("v1");
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f2.complete("v2");
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f3.complete("v3");
        AssertJUnit.assertEquals((Object)"v3", invokeFuture.get(10L, TimeUnit.SECONDS));
    }

    public void testAsyncInvocationManyHandlers() throws Exception {
        this.sideEffects.set("");
        CompletableFuture<Object> f = new CompletableFuture<Object>();
        AsyncInterceptorChain chain = this.makeChainWithManyHandlers(f);
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)this.newInvocationContext(), this.testCommand);
        f.complete("");
        this.assertHandlers(invokeFuture);
    }

    public void testSyncInvocationManyHandlers() throws Exception {
        this.sideEffects.set("");
        CompletableFuture<Object> f = CompletableFuture.completedFuture("");
        AsyncInterceptorChain chain = this.makeChainWithManyHandlers(f);
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)this.newInvocationContext(), this.testCommand);
        this.assertHandlers(invokeFuture);
    }

    private void assertHandlers(CompletableFuture<Object> invokeFuture) throws InterruptedException, ExecutionException {
        AssertJUnit.assertEquals((Object)"|handle|thenApply", (Object)invokeFuture.get());
        AssertJUnit.assertEquals((String)"|whenComplete|handle|thenAccept|thenApply", (String)this.sideEffects.get());
    }

    public void testAsyncInvocationManyHandlersSyncException() throws Exception {
        this.sideEffects.set("");
        CompletableFuture<Object> f = CompletableFuture.failedFuture(new TestException(""));
        AsyncInterceptorChain chain = this.makeChainWithManyHandlers(f);
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)this.newInvocationContext(), this.testCommand);
        this.assertExceptionHandlers(invokeFuture);
    }

    public void testAsyncInvocationManyHandlersAsyncException() throws Exception {
        this.sideEffects.set("");
        CompletableFuture<Object> f = new CompletableFuture<Object>();
        AsyncInterceptorChain chain = this.makeChainWithManyHandlers(f);
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)this.newInvocationContext(), this.testCommand);
        f.completeExceptionally(new TestException(""));
        this.assertExceptionHandlers(invokeFuture);
    }

    private void assertExceptionHandlers(CompletableFuture<Object> invokeFuture) {
        String expectedMessage = "|whenComplete|handle|exceptionally";
        Exceptions.expectExecutionException(TestException.class, (String)Pattern.quote(expectedMessage), invokeFuture);
        AssertJUnit.assertEquals((String)"|whenComplete|handle|exceptionally", (String)this.sideEffects.get());
    }

    private AsyncInterceptorChain makeChainWithManyHandlers(final CompletableFuture<Object> f) {
        return this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> AsyncInterceptorChainInvocationTest.this.afterInvokeNext(ctx, rCtx, command, rCommand, rv, null, "|thenApply"));
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> AsyncInterceptorChainInvocationTest.this.afterInvokeNext(ctx, rCtx, command, rCommand, rv, null, "|thenAccept"));
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndExceptionally(ctx, command, (rCtx, rCommand, t) -> AsyncInterceptorChainInvocationTest.this.afterInvokeNext(ctx, rCtx, command, rCommand, null, t, "|exceptionally"));
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, t) -> AsyncInterceptorChainInvocationTest.this.afterInvokeNext(ctx, rCtx, command, rCommand, rv, t, "|handle"));
            }
        }, new BaseAsyncInterceptor(){

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> AsyncInterceptorChainInvocationTest.this.afterInvokeNext(ctx, rCtx, command, rCommand, rv, t, "|whenComplete"));
            }
        }, new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return 23.asyncValue((CompletionStage)f);
            }
        }});
    }

    private String afterInvokeNext(Object rv, Throwable t, String text) {
        this.sideEffects.set(this.sideEffects.get() + text);
        if (t == null) {
            return rv.toString() + text;
        }
        throw new TestException(t.getMessage() + text);
    }

    private String afterInvokeNext(VisitableCommand expectedCommand, VisitableCommand command, Object rv, Throwable t, String text) {
        AssertJUnit.assertEquals((Object)expectedCommand, (Object)command);
        return this.afterInvokeNext(rv, t, text);
    }

    private String afterInvokeNext(InvocationContext expectedCtx, InvocationContext ctx, VisitableCommand expectedCommand, VisitableCommand command, Object rv, Throwable t, String text) {
        AssertJUnit.assertEquals((Object)expectedCtx, (Object)ctx);
        return this.afterInvokeNext(expectedCommand, command, rv, t, text);
    }

    public void testDeadlockWithAsyncStage() throws Exception {
        final CompletableFuture f1 = new CompletableFuture();
        final CompletableFuture<String> f2 = new CompletableFuture<String>();
        AsyncInterceptorChain chain = this.newInterceptorChain(new AsyncInterceptor[]{new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> String.valueOf(rv) + " " + String.valueOf(this.this$0.awaitFuture(f2)));
            }
        }, new BaseAsyncInterceptor(this){
            final /* synthetic */ AsyncInterceptorChainInvocationTest this$0;
            {
                this.this$0 = this$0;
            }

            public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
                InvocationSuccessFunction function = (rCtx, rCommand, rv) -> rv;
                return 25.asyncValue((CompletionStage)f1).addCallback(ctx, command, (InvocationCallback)function);
            }
        }});
        SingleKeyNonTxInvocationContext context = this.newInvocationContext();
        CompletableFuture invokeFuture = chain.invokeAsync((InvocationContext)context, this.testCommand);
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        Future<Boolean> fork = this.fork(() -> f1.complete("v1"));
        Thread.sleep(100L);
        AssertJUnit.assertFalse((boolean)fork.isDone());
        AssertJUnit.assertFalse((boolean)invokeFuture.isDone());
        f2.complete("v2");
        fork.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"v1 v2", invokeFuture.getNow(null));
    }

    private Object awaitFuture(CompletableFuture<Object> f2) {
        try {
            return f2.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw CompletableFutures.asCompletionException((Throwable)e);
        }
    }

    private SingleKeyNonTxInvocationContext newInvocationContext() {
        return new SingleKeyNonTxInvocationContext(null);
    }

    private AsyncInterceptorChain newInterceptorChain(AsyncInterceptor ... interceptors) {
        AsyncInterceptorChainImpl chain = new AsyncInterceptorChainImpl();
        for (AsyncInterceptor i : interceptors) {
            chain.appendInterceptor(i, false);
        }
        return chain;
    }
}

