/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="interceptors.ConcurrentInterceptorVisibilityTest")
public class ConcurrentInterceptorVisibilityTest
extends AbstractInfinispanTest {
    public void testSizeVisibility() throws Exception {
        this.updateCache(Visibility.SIZE);
    }

    @Test(groups={"unstable"})
    public void testGetVisibility() throws Exception {
        this.updateCache(Visibility.GET);
    }

    private void updateCache(final Visibility visibility) {
        final String key = "k-" + String.valueOf((Object)visibility);
        final String value = "k-" + String.valueOf((Object)visibility);
        final CountDownLatch entryCreatedLatch = new CountDownLatch(1);
        final EntryCreatedInterceptor interceptor = new EntryCreatedInterceptor(entryCreatedLatch);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder().nonClusteredDefault();
        TestCacheManagerFactory.addInterceptor(global, "defaultcache"::equals, (AsyncInterceptor)interceptor, TestCacheManagerFactory.InterceptorPosition.BEFORE, EntryWrappingInterceptor.class);
        TestingUtil.withCacheManager(new CacheManagerCallable(this, TestCacheManagerFactory.createCacheManager(global, builder)){
            final /* synthetic */ ConcurrentInterceptorVisibilityTest this$0;
            {
                this.this$0 = this$0;
                super(cm);
            }

            @Override
            public void call() throws Exception {
                Cache cache = this.cm.getCache();
                switch (visibility.ordinal()) {
                    case 0: {
                        assert (cache.isEmpty());
                        break;
                    }
                    case 1: {
                        assert (cache.get((Object)key) == null);
                        break;
                    }
                }
                Future ignore = this.this$0.fork(() -> {
                    cache.put((Object)key, (Object)value);
                    return null;
                });
                try {
                    entryCreatedLatch.await(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                switch (visibility.ordinal()) {
                    case 0: {
                        int size = cache.size();
                        assert (size == 1) : "size is: " + size;
                        assert (interceptor.assertKeySet);
                        break;
                    }
                    case 1: {
                        Object retVal = cache.get((Object)key);
                        assert (retVal != null);
                        assert (retVal.equals(value)) : "retVal is: " + String.valueOf(retVal);
                        assert (interceptor.assertKeySet);
                        break;
                    }
                }
                ignore.get(5L, TimeUnit.SECONDS);
            }
        });
    }

    private static enum Visibility {
        SIZE,
        GET;

    }

    public static class EntryCreatedInterceptor
    extends BaseCustomAsyncInterceptor {
        private static final Log log = LogFactory.getLog(EntryCreatedInterceptor.class);
        final CountDownLatch latch;
        volatile boolean assertKeySet;

        private EntryCreatedInterceptor(CountDownLatch latch) {
            this.latch = latch;
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            return this.invokeNextThenAccept(ctx, (VisitableCommand)command, (rCtx, rCommand, rv) -> {
                this.assertKeySet = this.cache.keySet().size() == 1;
                log.info((Object)"Cache entry created, now check in different thread");
                this.latch.countDown();
                TestingUtil.sleepThread(3000L);
            });
        }
    }
}

