/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.decorators.FunctionalListeners;
import org.testng.AssertJUnit;

public class FunctionalListenerAssertions<K, V>
implements AutoCloseable {
    final FunctionalListeners<K, V> listeners;
    final Runnable runnable;
    final List<TestEvent<V>> recorded = new ArrayList<TestEvent<V>>();
    final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();

    public static <K, V> FunctionalListenerAssertions<K, V> create(ConcurrentMap<K, V> map, Runnable r) {
        return new FunctionalListenerAssertions<K, V>((FunctionalListeners)((Object)map), r);
    }

    public static <K, V> FunctionalListenerAssertions<K, V> create(FunctionalListeners<K, V> listeners, Runnable r) {
        return new FunctionalListenerAssertions<K, V>(listeners, r);
    }

    private FunctionalListenerAssertions(FunctionalListeners<K, V> listeners, Runnable runnable) {
        this.listeners = listeners;
        this.runnable = runnable;
        Listeners.ReadWriteListeners<K, V> rw = this.listeners.readWriteListeners();
        this.closeables.add(rw.onCreate(c -> this.recorded.add(TestEvent.create(InternalTestType.LAMBDA_CREATE, c.get()))));
        this.closeables.add(rw.onModify((b, a) -> this.recorded.add(TestEvent.create(InternalTestType.LAMBDA_MODIFY, a.get(), b.get()))));
        this.closeables.add(rw.onRemove(r -> this.recorded.add(TestEvent.create(InternalTestType.LAMBDA_REMOVE, null, r.get()))));
        this.closeables.add(rw.add(new Listeners.ReadWriteListeners.ReadWriteListener<K, V>(){

            public void onCreate(EntryView.ReadEntryView<K, V> created) {
                FunctionalListenerAssertions.this.recorded.add(TestEvent.create(InternalTestType.LISTENER_CREATE, created.get()));
            }

            public void onModify(EntryView.ReadEntryView<K, V> before, EntryView.ReadEntryView<K, V> after) {
                FunctionalListenerAssertions.this.recorded.add(TestEvent.create(InternalTestType.LISTENER_MODIFY, after.get(), before.get()));
            }

            public void onRemove(EntryView.ReadEntryView<K, V> removed) {
                FunctionalListenerAssertions.this.recorded.add(TestEvent.create(InternalTestType.LISTENER_REMOVE, null, removed.get()));
            }
        }));
        Listeners.WriteListeners<K, V> wo = this.listeners.writeOnlyListeners();
        this.closeables.add(wo.onWrite(w -> this.recorded.add(TestEvent.create(InternalTestType.LAMBDA_WRITE, w.find().orElse(null)))));
        this.closeables.add(wo.add(w -> this.recorded.add(TestEvent.create(InternalTestType.LISTENER_WRITE, w.find().orElse(null)))));
    }

    @Override
    public void close() {
        this.closeables.forEach(ac -> {
            try {
                ac.close();
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    public void assertOrderedEvents(Collection<TestEvent<V>> expected) {
        this.runnable.run();
        AssertJUnit.assertEquals(expected, this.recorded);
    }

    public void assertUnorderedEvents(Collection<TestEvent<V>> expected) {
        this.runnable.run();
        AssertJUnit.assertEquals((String)this.recorded.toString(), (int)expected.size(), (int)this.recorded.size());
        expected.forEach(e -> AssertJUnit.assertTrue((String)String.format("Value %s not in %s", e, this.recorded), (boolean)this.recorded.remove(e)));
        AssertJUnit.assertEquals((int)0, (int)this.recorded.size());
    }

    private static <K, V> void withAssertions(ConcurrentMap<K, V> map, Runnable r, Consumer<FunctionalListenerAssertions<K, V>> c) {
        try (FunctionalListenerAssertions<K, V> a = FunctionalListenerAssertions.create(map, r);){
            c.accept(a);
        }
    }

    private static <K, V> void withAssertions(FunctionalListeners<K, V> listeners, Runnable r, Consumer<FunctionalListenerAssertions<K, V>> c) {
        try (FunctionalListenerAssertions<K, V> a = FunctionalListenerAssertions.create(listeners, r);){
            c.accept(a);
        }
    }

    public static <K, V> void assertOrderedEvents(ConcurrentMap<K, V> map, Runnable r, Collection<TestEvent<V>> expected) {
        FunctionalListenerAssertions.withAssertions(map, r, (FunctionalListenerAssertions<K, V> a) -> a.assertOrderedEvents(expected));
    }

    public static <K, V> void assertOrderedEvents(FunctionalListeners<K, V> listeners, Runnable r, Collection<TestEvent<V>> expected) {
        FunctionalListenerAssertions.withAssertions(listeners, r, (FunctionalListenerAssertions<K, V> a) -> a.assertOrderedEvents(expected));
    }

    public static <K, V> void assertUnorderedEvents(ConcurrentMap<K, V> map, Runnable r, Collection<TestEvent<V>> expected) {
        FunctionalListenerAssertions.withAssertions(map, r, (FunctionalListenerAssertions<K, V> a) -> a.assertUnorderedEvents(expected));
    }

    public static <K, V> void assertUnorderedEvents(FunctionalListeners<K, V> listeners, Runnable r, Collection<TestEvent<V>> expected) {
        FunctionalListenerAssertions.withAssertions(listeners, r, (FunctionalListenerAssertions<K, V> a) -> a.assertUnorderedEvents(expected));
    }

    public static <K, V> void assertNoEvents(ConcurrentMap<K, V> map, Runnable r) {
        FunctionalListenerAssertions.withAssertions(map, r, (FunctionalListenerAssertions<K, V> a) -> a.assertOrderedEvents(new ArrayList()));
    }

    public static <K, V> void assertNoEvents(FunctionalListeners<K, V> listeners, Runnable r) {
        FunctionalListenerAssertions.withAssertions(listeners, r, (FunctionalListenerAssertions<K, V> a) -> a.assertOrderedEvents(new ArrayList()));
    }

    public static Collection<TestEvent<String>> create(String ... values) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String value : values) {
            all.addAll(TestEvent.create(TestType.CREATE, value));
        }
        for (String value : values) {
            all.addAll(TestEvent.create(TestType.WRITE, value));
        }
        return all;
    }

    public static Collection<TestEvent<String>> createModify(String createdValue, String modifiedValue) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        all.addAll(TestEvent.create(TestType.CREATE, createdValue));
        all.addAll(TestEvent.create(TestType.WRITE, createdValue));
        all.addAll(TestEvent.create(TestType.MODIFY, modifiedValue, createdValue));
        all.addAll(TestEvent.create(TestType.WRITE, modifiedValue));
        return all;
    }

    public static Collection<TestEvent<String>> createRemove(String value) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        all.addAll(TestEvent.create(TestType.CREATE, value));
        all.addAll(TestEvent.create(TestType.WRITE, value));
        all.addAll(TestEvent.create(TestType.REMOVE, null, value));
        all.addAll(TestEvent.create(TestType.WRITE, null));
        return all;
    }

    public static Collection<TestEvent<String>> createAllRemoveAll(String ... values) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.CREATE, s));
            all.addAll(TestEvent.create(TestType.WRITE, s));
        }
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.REMOVE, null, s));
            all.addAll(TestEvent.create(TestType.WRITE, null));
        }
        return all;
    }

    public static Collection<TestEvent<String>> createThenRemove(String ... values) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.CREATE, s));
            all.addAll(TestEvent.create(TestType.WRITE, s));
            all.addAll(TestEvent.create(TestType.REMOVE, null, s));
            all.addAll(TestEvent.create(TestType.WRITE, null));
        }
        return all;
    }

    public static Collection<TestEvent<String>> write(String ... values) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String value : values) {
            all.addAll(TestEvent.create(TestType.WRITE, value));
        }
        return all;
    }

    public static Collection<TestEvent<String>> writeModify(List<String> written, List<String> modified) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String value : written) {
            all.addAll(TestEvent.create(TestType.WRITE, value));
        }
        IntStream.range(0, modified.size()).forEach(i -> {
            all.addAll(TestEvent.create(TestType.MODIFY, (String)modified.get(i), (String)written.get(i)));
            all.addAll(TestEvent.create(TestType.WRITE, (String)modified.get(i)));
        });
        return all;
    }

    public static Collection<TestEvent<String>> createModifyRemove(String created, String modified) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        all.addAll(TestEvent.create(TestType.CREATE, created));
        all.addAll(TestEvent.create(TestType.WRITE, created));
        all.addAll(TestEvent.create(TestType.MODIFY, modified, created));
        all.addAll(TestEvent.create(TestType.WRITE, modified));
        all.addAll(TestEvent.create(TestType.REMOVE, null, modified));
        all.addAll(TestEvent.create(TestType.WRITE, null));
        return all;
    }

    public static Collection<TestEvent<String>> createModifyRemove(List<String> created, List<String> modified) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        created.forEach(s -> all.addAll(TestEvent.create(TestType.CREATE, s)));
        created.forEach(s -> all.addAll(TestEvent.create(TestType.WRITE, s)));
        modified.forEach(s -> all.addAll(TestEvent.create(TestType.WRITE, s)));
        modified.forEach(s -> all.addAll(TestEvent.create(TestType.REMOVE, null, s)));
        modified.forEach(s -> all.addAll(TestEvent.create(TestType.WRITE, null)));
        return all;
    }

    public static Collection<TestEvent<String>> writeValueNull(String ... values) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.WRITE, s));
        }
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.WRITE, null));
        }
        return all;
    }

    public static Collection<TestEvent<String>> writeRemove(String ... values) {
        ArrayList<TestEvent<String>> all = new ArrayList<TestEvent<String>>();
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.WRITE, s));
        }
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.REMOVE, null, s));
        }
        for (String s : values) {
            all.addAll(TestEvent.create(TestType.WRITE, null));
        }
        return all;
    }

    public static enum TestType {
        CREATE,
        MODIFY,
        REMOVE,
        WRITE;


        private InternalTestType lambdaType() {
            switch (this.ordinal()) {
                case 0: {
                    return InternalTestType.LAMBDA_CREATE;
                }
                case 1: {
                    return InternalTestType.LAMBDA_MODIFY;
                }
                case 2: {
                    return InternalTestType.LAMBDA_REMOVE;
                }
                case 3: {
                    return InternalTestType.LAMBDA_WRITE;
                }
            }
            return null;
        }

        private InternalTestType listenerType() {
            switch (this.ordinal()) {
                case 0: {
                    return InternalTestType.LISTENER_CREATE;
                }
                case 1: {
                    return InternalTestType.LISTENER_MODIFY;
                }
                case 2: {
                    return InternalTestType.LISTENER_REMOVE;
                }
                case 3: {
                    return InternalTestType.LISTENER_WRITE;
                }
            }
            return null;
        }
    }

    public static final class TestEvent<V> {
        final InternalTestType type;
        final Optional<V> prev;
        final V value;

        public static <V> Collection<TestEvent<V>> create(TestType type, V value) {
            return Arrays.asList(TestEvent.create(type.lambdaType(), value), TestEvent.create(type.listenerType(), value));
        }

        public static <V> Collection<TestEvent<V>> create(TestType type, V value, V prev) {
            return Arrays.asList(TestEvent.create(type.lambdaType(), value, prev), TestEvent.create(type.listenerType(), value, prev));
        }

        private static <V> TestEvent<V> create(InternalTestType type, V value) {
            return new TestEvent(type, Optional.empty(), value);
        }

        private static <V> TestEvent<V> create(InternalTestType type, V value, V prev) {
            return new TestEvent<V>(type, Optional.of(prev), value);
        }

        private TestEvent(InternalTestType type, Optional<V> prev, V value) {
            this.type = type;
            this.prev = prev;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestEvent testEvent = (TestEvent)o;
            if (this.type != testEvent.type) {
                return false;
            }
            if (!this.prev.equals(testEvent.prev)) {
                return false;
            }
            return !(this.value == null ? testEvent.value != null : !this.value.equals(testEvent.value));
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.prev.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "TestEvent{type=" + String.valueOf((Object)this.type) + ", prev=" + String.valueOf(this.prev) + ", value=" + String.valueOf(this.value) + "}";
        }
    }

    private static enum InternalTestType {
        LAMBDA_CREATE,
        LAMBDA_MODIFY,
        LAMBDA_REMOVE,
        LISTENER_CREATE,
        LISTENER_MODIFY,
        LISTENER_REMOVE,
        LAMBDA_WRITE,
        LISTENER_WRITE;

    }
}

