/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional;

import java.io.Serializable;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.functional.AbstractFunctionalOpTest;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.util.function.SerializableBiConsumer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="functional.FunctionalL1Test")
public class FunctionalL1Test
extends AbstractFunctionalOpTest {
    @Override
    protected void configureCache(ConfigurationBuilder builder) {
        super.configureCache(builder);
        if (builder.clustering().cacheMode().isDistributed()) {
            builder.clustering().l1().enable();
        }
    }

    @Test(dataProvider="owningModeAndWriteMethod")
    public void testEntryInvalidated(boolean isOwner, AbstractFunctionalOpTest.WriteMethod method) {
        Cache primary = this.cache(isOwner ? 0 : 2, "dist");
        Cache backup = this.cache(1, "dist");
        Cache reader = this.cache(3, "dist");
        Cache nonOwner = this.cache(isOwner ? 2 : 0, "dist");
        MagicKey KEY = this.getKeyForCache(primary, backup);
        primary.put((Object)KEY, (Object)"value");
        FunctionalL1Test.assertNoEntry(reader, KEY);
        AssertJUnit.assertEquals((String)"value", (String)((String)reader.get((Object)KEY)));
        FunctionalL1Test.assertEntry(primary, KEY, "value", false);
        FunctionalL1Test.assertEntry(backup, KEY, "value", false);
        FunctionalL1Test.assertEntry(reader, KEY, "value", true);
        FunctionalL1Test.assertNoEntry(nonOwner, KEY);
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create((AdvancedCache)this.cache(0, "dist").getAdvancedCache());
        FunctionalMap.WriteOnlyMap wo = WriteOnlyMapImpl.create((FunctionalMapImpl)functionalMap);
        FunctionalMap.ReadWriteMap rw = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        Function readFunc = MarshallableFunctions.returnReadOnlyFindOrNull();
        method.eval(KEY, wo, rw, readFunc, (SerializableBiConsumer & Serializable)(view, nil) -> view.set((Object)"value2", new MetaParam.Writable[0]), FunctionalL1Test.class);
        FunctionalL1Test.assertEntry(primary, KEY, "value2", false);
        FunctionalL1Test.assertEntry(backup, KEY, "value2", false);
        FunctionalL1Test.assertNoEntry(reader, KEY);
        FunctionalL1Test.assertNoEntry(nonOwner, KEY);
    }

    private static void assertNoEntry(Cache<Object, String> cache, Object KEY) {
        AssertJUnit.assertEquals(null, (Object)cache.getAdvancedCache().getDataContainer().get(KEY));
    }

    private static void assertEntry(Cache<Object, String> cache, Object KEY, String expectedValue, boolean isL1) {
        InternalCacheEntry ice = cache.getAdvancedCache().getDataContainer().get(KEY);
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((String)expectedValue, (String)((String)ice.getValue()));
        AssertJUnit.assertEquals((String)ice.toString(), (boolean)isL1, (boolean)ice.isL1Entry());
    }
}

