/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.GLOBAL)
@DefaultFactoryFor(classes={Component.class})
public class TestDelayFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    private boolean injectionDone;

    @Inject
    public void inject(Control control) {
        control.await();
        this.injectionDone = true;
    }

    public Object construct(String componentName) {
        if (!this.injectionDone) {
            throw new IllegalStateException("GlobalConfiguration reference is null");
        }
        if (Component.class.getName().equals(componentName)) {
            return new Component();
        }
        return null;
    }

    @Scope(value=Scopes.GLOBAL)
    public static class Control {
        private final CountDownLatch latch = new CountDownLatch(1);

        public void await() {
            try {
                this.latch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void unblock() {
            this.latch.countDown();
        }
    }

    @Scope(value=Scopes.GLOBAL)
    public static class Component {
    }
}

