/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.expiration.impl.ExpirationFunctionalTest;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledRpcManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="expiration.impl.ClusterExpirationLifespanTest")
public class ClusterExpirationLifespanTest
extends MultipleCacheManagersTest {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;
    protected ControlledTimeService ts2;
    protected Cache<Object, Object> cache0;
    protected Cache<Object, Object> cache1;
    protected Cache<Object, Object> cache2;
    protected ConfigurationBuilder configurationBuilder;

    @Override
    public Object[] factory() {
        return Arrays.stream(StorageType.values()).flatMap(type -> Stream.builder().add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.DIST_SYNC).transactional(false)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC)).add(new ClusterExpirationLifespanTest().storageType((StorageType)type).cacheMode(CacheMode.REPL_SYNC).transactional(false)).build()).toArray();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configurationBuilder = new ConfigurationBuilder();
        this.configurationBuilder.clustering().cacheMode(this.cacheMode);
        this.configurationBuilder.transaction().transactionMode(this.transactionMode()).lockingMode(this.lockingMode);
        this.configurationBuilder.expiration().disableReaper();
        if (this.storageType != null) {
            this.configurationBuilder.memory().storage(this.storageType);
        }
        this.createCluster(TestDataSCI.INSTANCE, this.configurationBuilder, 3);
        this.waitForClusterToForm();
        this.injectTimeServices();
        this.cache0 = this.cache(0);
        this.cache1 = this.cache(1);
        this.cache2 = this.cache(2);
    }

    @Override
    protected GlobalConfigurationBuilder defaultGlobalConfigurationBuilder() {
        GlobalConfigurationBuilder globalConfigurationBuilder = super.defaultGlobalConfigurationBuilder();
        globalConfigurationBuilder.serialization().marshaller((Marshaller)new JavaSerializationMarshaller()).allowList().addClasses(new Class[]{ExpirationFunctionalTest.NoEquals.class, MagicKey.class});
        return globalConfigurationBuilder;
    }

    protected void injectTimeServices() {
        this.ts0 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, this.ts0, true);
        this.ts1 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, this.ts1, true);
        this.ts2 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(2), TimeService.class, this.ts2, true);
    }

    public void testLifespanExpiredOnPrimaryOwner() throws Exception {
        this.testLifespanExpiredEntryRetrieval(this.cache0, this.cache1, this.ts0, true);
    }

    public void testLifespanExpiredOnBackupOwner() throws Exception {
        this.testLifespanExpiredEntryRetrieval(this.cache0, this.cache1, this.ts1, false);
    }

    private void testLifespanExpiredEntryRetrieval(Cache<Object, Object> primaryOwner, Cache<Object, Object> backupOwner, ControlledTimeService timeService, boolean expireOnPrimary) throws Exception {
        Cache<Object, Object> otherCache;
        Cache<Object, Object> expiredCache;
        Object key = this.createKey(primaryOwner, backupOwner);
        primaryOwner.put(key, (Object)key.toString(), 10L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertEquals((Object)key.toString(), (Object)primaryOwner.get(key));
        AssertJUnit.assertEquals((Object)key.toString(), (Object)backupOwner.get(key));
        timeService.advance(11L);
        if (expireOnPrimary) {
            expiredCache = primaryOwner;
            otherCache = backupOwner;
        } else {
            expiredCache = backupOwner;
            otherCache = primaryOwner;
        }
        AssertJUnit.assertEquals((Object)key.toString(), (Object)otherCache.get(key));
        Object expiredValue = expiredCache.get(key);
        AssertJUnit.assertNull((Object)expiredValue);
        ClusterExpirationLifespanTest.eventually(() -> !otherCache.containsKey(key), 10L, TimeUnit.SECONDS);
    }

    private Object createKey(Cache<Object, ?> primaryOwner, Cache<Object, ?> backupOwner) {
        if (this.storageType == StorageType.OBJECT) {
            return new MagicKey(primaryOwner, backupOwner);
        }
        LocalizedCacheTopology primaryLct = primaryOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        LocalizedCacheTopology backupLct = backupOwner.getAdvancedCache().getDistributionManager().getCacheTopology();
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int attempt = 0;
        do {
            int key = tlr.nextInt();
            Object wrappedKey = primaryOwner.getAdvancedCache().getKeyDataConversion().toStorage((Object)key);
            if (!primaryLct.getDistribution(wrappedKey).isPrimary() || !backupLct.getDistribution(wrappedKey).isWriteBackup()) continue;
            log.tracef("Found key %s for primary owner %s and backup owner %s", wrappedKey, primaryOwner, backupOwner);
            return key;
        } while (++attempt != 1000);
        throw new AssertionError((Object)("Unable to find key that maps to primary " + String.valueOf(primaryOwner) + " and backup " + String.valueOf(backupOwner)));
    }

    public void testLifespanExpiredOnBoth() {
        Object key = this.createKey(this.cache0, this.cache1);
        this.cache0.put(key, (Object)key.toString(), 10L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((Object)key.toString(), (Object)this.cache0.get(key));
        AssertJUnit.assertEquals((Object)key.toString(), (Object)this.cache1.get(key));
        this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
        this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
        AssertJUnit.assertNull((Object)this.cache0.get(key));
        AssertJUnit.assertNull((Object)this.cache1.get(key));
    }

    private void incrementAllTimeServices(long time, TimeUnit unit) {
        for (ControlledTimeService cts : Arrays.asList(this.ts0, this.ts1, this.ts2)) {
            cts.advance(unit.toMillis(time));
        }
    }

    @Test(groups={"unstable"}, description="https://issues.redhat.com/browse/ISPN-11422")
    public void testWriteExpiredEntry() {
        String key = "key";
        String value = "value";
        for (int i = 0; i < 100; ++i) {
            Cache<Object, Object> cache = this.cache0;
            Object prev = cache.get((Object)key);
            if (prev == null) {
                prev = cache.putIfAbsent((Object)key, (Object)value, 1L, TimeUnit.SECONDS);
                AssertJUnit.assertNull((Object)prev);
                AssertJUnit.assertNotNull((Object)cache.get((Object)key));
            }
            long secondOneMilliAdvanced = TimeUnit.SECONDS.toMillis(1L);
            this.ts0.advance(secondOneMilliAdvanced);
            this.ts1.advance(secondOneMilliAdvanced);
            this.ts2.advance(secondOneMilliAdvanced);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimaryNotExpiredButBackupWas() throws InterruptedException, ExecutionException, TimeoutException {
        Class<PutKeyValueCommand> commandToExpect;
        if (this.transactional.booleanValue()) {
            throw new SkipException("Test isn't supported in transactional mode");
        }
        Object key = this.createKey(this.cache0, this.cache1);
        String value = key.toString();
        this.cache0.put(key, (Object)value, 10L, TimeUnit.SECONDS);
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(this.cache0, new Class[0]);
        if (this.cacheMode == CacheMode.DIST_SYNC) {
            controlledRpcManager.excludeCommands(PutKeyValueCommand.class);
            commandToExpect = BackupWriteCommand.class;
        } else {
            commandToExpect = PutKeyValueCommand.class;
        }
        try {
            Future<Object> result = this.fork(() -> this.cache0.put(key, (Object)(value + "-expire-backup")));
            ControlledRpcManager.BlockedRequest<PutKeyValueCommand> blockedRequest = controlledRpcManager.expectCommand(commandToExpect);
            this.incrementAllTimeServices(11L, TimeUnit.SECONDS);
            ControlledRpcManager.SentRequest sentRequest = blockedRequest.send();
            if (sentRequest != null) {
                sentRequest.expectAllResponses().receive();
            }
            AssertJUnit.assertEquals((Object)value, (Object)result.get(10L, TimeUnit.SECONDS));
        }
        finally {
            controlledRpcManager.revertRpcManager();
        }
        AssertJUnit.assertEquals((Object)(value + "-expire-backup"), (Object)this.cache0.get(key));
        AssertJUnit.assertEquals((Object)(value + "-expire-backup"), (Object)this.cache1.get(key));
        AssertJUnit.assertEquals((Object)(value + "-expire-backup"), (Object)this.cache2.get(key));
    }

    public void testExpirationWithNoValueEquals() {
        Object key = this.createKey(this.cache0, this.cache1);
        this.cache0.put(key, (Object)new ExpirationFunctionalTest.NoEquals("value"), 10L, TimeUnit.MINUTES);
        AssertJUnit.assertEquals((int)1, (int)this.cache0.getAdvancedCache().getDataContainer().sizeIncludingExpired());
        AssertJUnit.assertEquals((int)1, (int)this.cache1.getAdvancedCache().getDataContainer().sizeIncludingExpired());
        this.ts0.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
        this.ts1.advance(TimeUnit.MINUTES.toMillis(10L) + 1L);
        AssertJUnit.assertEquals((int)1, (int)this.cache0.getAdvancedCache().getDataContainer().sizeIncludingExpired());
        AssertJUnit.assertEquals((int)1, (int)this.cache1.getAdvancedCache().getDataContainer().sizeIncludingExpired());
        this.cache0.getAdvancedCache().getExpirationManager().processExpiration();
        this.verifyNoValue(this.cache0.getAdvancedCache().getDataContainer().iteratorIncludingExpired());
        this.verifyNoValue(this.cache1.getAdvancedCache().getDataContainer().iteratorIncludingExpired());
    }

    private void verifyNoValue(Iterator<InternalCacheEntry<Object, Object>> iter) {
        if (iter.hasNext()) {
            AssertJUnit.assertNull((Object)iter.next().getValue());
        }
        AssertJUnit.assertFalse((boolean)iter.hasNext());
    }
}

