/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.ch.ZeroCapacityAdministrationTest")
public class ZeroCapacityAdministrationTest
extends MultipleCacheManagersTest {
    private static final String TEST_DIR = CommonsTestingUtil.tmpDirectory((String[])new String[]{ZeroCapacityAdministrationTest.class.getSimpleName()});
    private EmbeddedCacheManager node1;
    private EmbeddedCacheManager zeroCapacityNode;

    @Override
    protected void createCacheManagers() throws Throwable {
        String state1 = Paths.get(TEST_DIR, "1").toString();
        GlobalConfigurationBuilder global1 = this.statefulGlobalBuilder(state1);
        this.node1 = this.addClusterEnabledCacheManager(global1, new ConfigurationBuilder());
        String zeroState = Paths.get(TEST_DIR, "zero").toString();
        GlobalConfigurationBuilder globalZero = this.statefulGlobalBuilder(zeroState).zeroCapacityNode(true);
        this.zeroCapacityNode = this.addClusterEnabledCacheManager(globalZero, new ConfigurationBuilder());
        this.waitForClusterToForm();
    }

    public void testDefineClusterConfiguration() {
        Configuration config = new ConfigurationBuilder().build();
        this.zeroCapacityNode.administration().createCache("zero-cache", config);
        this.zeroCapacityNode.administration().createTemplate("zero-template", config);
        AssertJUnit.assertNotNull((Object)this.node1.getCache("zero-cache"));
        AssertJUnit.assertNotNull((Object)this.node1.getCacheConfiguration("zero-template"));
    }

    public void testCreateNewClusteredCacheFromZeroToRemote() {
        Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).build();
        Assertions.assertThat((boolean)this.node1.isCoordinator()).isTrue();
        int tries = 0;
        Object cacheName = "another-cache";
        ScopedState ss = new ScopedState("cache", (String)cacheName);
        while (!DistributionTestHelper.isFirstOwner(this.node1.getCache("org.infinispan.CONFIG"), ss)) {
            if (tries > 50) {
                Fail.fail((String)"Exceeded attempts to find configuration mapping to remote");
            }
            cacheName = "another-cache-" + tries++;
            ss = new ScopedState("cache", (String)cacheName);
        }
        try {
            Cache cache = this.zeroCapacityNode.administration().getOrCreateCache((String)cacheName, config);
            AssertJUnit.assertNotNull((Object)cache);
        }
        catch (Throwable t) {
            this.node1.administration().getOrCreateCache((String)cacheName, config);
            Fail.fail((String)"Failed creating clustered cache from node zero", (Throwable)t.getCause());
        }
        AssertJUnit.assertNotNull((Object)this.node1.getCache((String)cacheName));
        AssertJUnit.assertNotNull((Object)this.node1.getCacheConfiguration((String)cacheName));
    }

    private GlobalConfigurationBuilder statefulGlobalBuilder(String stateDirectory) {
        Util.recursiveFileRemove((String)stateDirectory);
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory).sharedPersistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        return global;
    }
}

