/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.SuperFastHash;
import org.infinispan.profiling.testinternals.Generator;
import org.infinispan.remoting.transport.Address;
import org.testng.annotations.Test;

@Test(groups={"manual"}, testName="distribution.HashFunctionComparisonTest")
public class HashFunctionComparisonTest {
    private static final int MAX_STRING_SIZE = 16;
    private static final int MAX_BYTE_ARRAY_SIZE = 16;
    private static final int NUM_KEYS_PER_TYPE = 100000;
    private static final int MODULUS_BASE = 1024;
    private static final NumberFormat nf = NumberFormat.getInstance();

    private static List<Hash> getHashFunctions() {
        LinkedList<Hash> functions = new LinkedList<Hash>();
        functions.add((Hash)MurmurHash3.getInstance());
        functions.add(new SuperFastHash());
        return functions;
    }

    public void doTest() {
        for (int i : Arrays.asList(10, 50, 100, 500, 1000)) {
            System.out.printf("-----------------  Testing with %s nodes -----------------%n", i);
            this.addressDistribution(i);
        }
    }

    private void addressDistribution(int numAddresses) {
        int hashSpace = 10240;
        List<Hash> functions = HashFunctionComparisonTest.getHashFunctions();
        System.out.printf("%s %s %s %s %s %n%n", Util.padString((String)"Function", (int)25), Util.padString((String)"Greatest dist", (int)15), Util.padString((String)"Smallest dist", (int)15), Util.padString((String)"Mean dist", (int)15), Util.padString((String)"Positions", (int)15));
        for (Hash f : functions) {
            LinkedList<Address> addresses = new LinkedList<Address>();
            for (int i = 0; i < numAddresses; ++i) {
                addresses.add(Generator.generateAddress());
            }
            TreeMap<Integer, Address> positions = new TreeMap<Integer, Address>();
            for (Address a : addresses) {
                positions.put(f.hash(a.hashCode()) % hashSpace, a);
            }
            System.out.printf("%s %s %s %s %s %n%n", Util.padString((String)f.getClass().getSimpleName(), (int)25), Util.padString((String)this.greatestDist(positions, hashSpace), (int)15), Util.padString((String)this.smallestDist(positions, hashSpace), (int)15), Util.padString((String)this.meanDist(positions, hashSpace), (int)15), "-");
        }
        System.out.printf("%s %s %s %s %s %n%n", Util.padString((String)"Perfectly Balanced", (int)25), Util.padString((String)"-", (int)15), Util.padString((String)"-", (int)15), Util.padString((String)Integer.toString(hashSpace / numAddresses), (int)15), "-");
    }

    private String greatestDist(SortedMap<Integer, Address> pos, int hashSpace) {
        int largest = 0;
        int lastPos = this.lastEntry(pos).getKey();
        int firstPos = -1;
        for (int currentPos : pos.keySet()) {
            if (firstPos == -1) {
                firstPos = currentPos;
            }
            largest = Math.max(largest, Math.abs(currentPos - lastPos));
            lastPos = currentPos;
        }
        return String.valueOf(largest);
    }

    private String smallestDist(SortedMap<Integer, Address> pos, int hashSpace) {
        int smallest = Integer.MAX_VALUE;
        int lastPos = this.lastEntry(pos).getKey();
        int firstPos = -1;
        for (int currentPos : pos.keySet()) {
            if (firstPos == -1) {
                firstPos = currentPos;
            }
            smallest = Math.min(smallest, Math.abs(currentPos - lastPos));
            lastPos = currentPos;
        }
        return String.valueOf(smallest);
    }

    private String meanDist(SortedMap<Integer, Address> pos, int hashSpace) {
        int totalDist = 0;
        int lastPos = this.lastEntry(pos).getKey();
        int firstPos = -1;
        for (int currentPos : pos.keySet()) {
            if (firstPos == -1) {
                firstPos = currentPos;
            }
            totalDist += Math.abs(currentPos - lastPos);
            lastPos = currentPos;
        }
        return String.valueOf(totalDist / pos.size());
    }

    private Map.Entry<Integer, Address> lastEntry(SortedMap<Integer, Address> m) {
        Map.Entry<Integer, Address> last = null;
        Iterator<Map.Entry<Integer, Address>> iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Address> e;
            last = e = iterator.next();
        }
        return last;
    }

    public void testHashs() {
        List<Hash> functions = HashFunctionComparisonTest.getHashFunctions();
        HashSet<Object> objectKeys = new HashSet<Object>(100000);
        HashSet<String> stringKeys = new HashSet<String>(100000);
        HashSet<byte[]> byteArrayKeys = new HashSet<byte[]>(100000);
        for (int i = 0; i < 100000; ++i) {
            String s = Generator.getRandomString(16);
            objectKeys.add(s);
            stringKeys.add(s);
            byteArrayKeys.add(Generator.getRandomByteArray(16));
        }
        this.perform(functions, objectKeys, stringKeys, byteArrayKeys, false);
        this.perform(functions, objectKeys, stringKeys, byteArrayKeys, true);
    }

    private void captureStats(int hash, DescriptiveStatistics stats) {
        stats.addValue((double)(hash % 1024));
    }

    private void perform(Collection<Hash> functions, Set<Object> objectKeys, Set<String> stringKeys, Set<byte[]> byteArrayKeys, boolean warmup) {
        if (!warmup) {
            System.out.printf("%s %s %s %s%n", Util.padString((String)"Function Impl", (int)25), Util.padString((String)"String keys", (int)18), Util.padString((String)"Byte array keys", (int)18), Util.padString((String)"Object keys", (int)18));
        }
        for (Hash f : functions) {
            long oRes = 0L;
            long sRes = 0L;
            long bRes = 0L;
            DescriptiveStatistics oStats = new DescriptiveStatistics();
            DescriptiveStatistics sStats = new DescriptiveStatistics();
            DescriptiveStatistics bStats = new DescriptiveStatistics();
            long st = System.currentTimeMillis();
            for (Object o : objectKeys) {
                this.captureStats(f.hash(o.hashCode()), oStats);
            }
            oRes = System.currentTimeMillis() - st;
            st = System.currentTimeMillis();
            for (String s : stringKeys) {
                this.captureStats(f.hash((Object)s), sStats);
            }
            sRes = System.currentTimeMillis() - st;
            st = System.currentTimeMillis();
            for (byte[] b : byteArrayKeys) {
                this.captureStats(f.hash(b), bStats);
            }
            bRes = System.currentTimeMillis() - st;
            if (warmup) continue;
            System.out.printf("%s %s %s %s%n", Util.padString((String)f.getClass().getSimpleName(), (int)25), Util.padString((String)Util.prettyPrintTime((long)sRes), (int)18), Util.padString((String)Util.prettyPrintTime((long)bRes), (int)18), Util.padString((String)Util.prettyPrintTime((long)oRes), (int)18));
            System.out.printf("%s %s %s %s%n", Util.padString((String)"  mean", (int)25), this.padDouble(sStats.getMean()), this.padDouble(bStats.getMean()), this.padDouble(oStats.getMean()));
            System.out.printf("%s %s %s %s%n", Util.padString((String)"  median", (int)25), this.padDouble(sStats.getPercentile(50.0)), this.padDouble(bStats.getPercentile(50.0)), this.padDouble(oStats.getPercentile(50.0)));
            System.out.printf("%s %s %s %s%n", Util.padString((String)"  deviation", (int)25), this.padDouble(sStats.getStandardDeviation()), this.padDouble(bStats.getStandardDeviation()), this.padDouble(oStats.getStandardDeviation()));
            System.out.printf("%s %s %s %s%n", Util.padString((String)"  variance", (int)25), this.padDouble(sStats.getVariance()), this.padDouble(bStats.getVariance()), this.padDouble(oStats.getVariance()));
        }
    }

    private String padDouble(double d) {
        return Util.padString((String)nf.format(d), (int)18);
    }
}

