/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.BaseDistSyncL1Test;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.distribution.L1TxInterceptor;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.interceptors.distribution.VersionedDistributionInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.ControlledRpcManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncTxL1FuncTest")
public class DistSyncTxL1FuncTest
extends BaseDistSyncL1Test {
    @Override
    public Object[] factory() {
        return new Object[]{new DistSyncTxL1FuncTest().isolationLevel(IsolationLevel.READ_COMMITTED), new DistSyncTxL1FuncTest().isolationLevel(IsolationLevel.REPEATABLE_READ)};
    }

    public DistSyncTxL1FuncTest() {
        this.transactional = true;
        this.testRetVals = true;
    }

    @Override
    protected Class<? extends AsyncInterceptor> getDistributionInterceptorClass() {
        return this.isVersioned() ? VersionedDistributionInterceptor.class : TxDistributionInterceptor.class;
    }

    @Override
    protected Class<? extends AsyncInterceptor> getL1InterceptorClass() {
        return L1TxInterceptor.class;
    }

    protected Class<? extends VisitableCommand> getCommitCommand() {
        return this.isVersioned() ? VersionedCommitCommand.class : CommitCommand.class;
    }

    private boolean isVersioned() {
        return !(this.lockingMode != null && this.lockingMode != LockingMode.OPTIMISTIC || this.isolationLevel != null && this.isolationLevel != IsolationLevel.REPEATABLE_READ);
    }

    @Override
    protected <K> void assertL1StateOnLocalWrite(Cache<? super K, ?> cache, Cache<?, ?> updatingCache, K key, Object valueWrite) {
        if (cache != updatingCache) {
            super.assertL1StateOnLocalWrite(cache, updatingCache, key, valueWrite);
        } else {
            InternalCacheEntry ice = cache.getAdvancedCache().getDataContainer().get(key);
            AssertJUnit.assertNotNull((Object)ice);
            AssertJUnit.assertEquals((Object)valueWrite, (Object)ice.getValue());
        }
    }

    @Test
    public void testL1UpdatedOnReplaceOperationFailure() {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
        AssertJUnit.assertFalse((boolean)nonOwnerCache.replace((Object)"key-to-the-cache", (Object)"not-same", (Object)"second-put"));
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
    }

    @Test
    public void testL1UpdatedOnRemoveOperationFailure() {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
        AssertJUnit.assertFalse((boolean)nonOwnerCache.remove((Object)"key-to-the-cache", (Object)"not-same"));
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
    }

    @Test
    public void testL1UpdatedBeforePutCommits() throws Exception {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
        nonOwnerCache.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.put((Object)"key-to-the-cache", (Object)"second-put")));
        InternalCacheEntry ice = nonOwnerCache.getAdvancedCache().getDataContainer().get((Object)"key-to-the-cache");
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((Object)"first-put", (Object)ice.getValue());
        nonOwnerCache.getAdvancedCache().getTransactionManager().commit();
        ice = nonOwnerCache.getAdvancedCache().getDataContainer().get((Object)"key-to-the-cache");
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((Object)"second-put", (Object)ice.getValue());
    }

    @Test
    public void testL1UpdatedBeforeRemoveCommits() throws Exception {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
        nonOwnerCache.getAdvancedCache().getTransactionManager().begin();
        AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.remove((Object)"key-to-the-cache")));
        InternalCacheEntry ice = nonOwnerCache.getAdvancedCache().getDataContainer().get((Object)"key-to-the-cache");
        AssertJUnit.assertNotNull((Object)ice);
        AssertJUnit.assertEquals((Object)"first-put", (Object)ice.getValue());
        nonOwnerCache.getAdvancedCache().getTransactionManager().commit();
        this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOccursAfterReplaceRunningBeforeRetrievedRemote() throws ExecutionException, InterruptedException, BrokenBarrierException, TimeoutException {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.addBlockingInterceptorBeforeTx(nonOwnerCache, barrier, ReplaceCommand.class, false);
        try {
            Future<Boolean> futureReplace = this.fork(() -> nonOwnerCache.replace((Object)"key-to-the-cache", (Object)"first-put", (Object)"second-put"));
            barrier.await(5L, TimeUnit.SECONDS);
            Future<String> futureGet = this.fork(() -> (String)nonOwnerCache.get((Object)"key-to-the-cache"));
            TestingUtil.assertNotDone(futureGet);
            barrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((boolean)futureReplace.get(5L, TimeUnit.SECONDS));
            AssertJUnit.assertEquals((String)"first-put", (String)futureGet.get(5L, TimeUnit.SECONDS));
        }
        finally {
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOccursAfterReplaceRunningBeforeWithRemoteException() throws Exception {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.addBlockingInterceptorBeforeTx(nonOwnerCache, barrier, ReplaceCommand.class, false);
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(nonOwnerCache, new Class[0]);
        try {
            Future<Boolean> futureReplace = this.fork(() -> nonOwnerCache.replace((Object)"key-to-the-cache", (Object)"first-put", (Object)"second-put"));
            barrier.await(5L, TimeUnit.SECONDS);
            Future<String> futureGet = this.fork(() -> (String)nonOwnerCache.get((Object)"key-to-the-cache"));
            TestingUtil.assertNotDone(futureGet);
            controlledRpcManager.expectNoCommand();
            barrier.await(5L, TimeUnit.SECONDS);
            controlledRpcManager.expectCommand(ClusteredGetCommand.class).skipSend().receive(this.address(ownerCache), (Response)new ExceptionResponse((Exception)new TestException()));
            Exceptions.expectExecutionException(RemoteException.class, TestException.class, futureReplace);
            Exceptions.expectExecutionException(RemoteException.class, TestException.class, futureGet);
        }
        finally {
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
            controlledRpcManager.revertRpcManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOccursBeforePutCompletesButRetrievesRemote() throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        Cache ownerCache = this.getFirstOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.addBlockingInterceptorBeforeTx(nonOwnerCache, barrier, PutKeyValueCommand.class, true);
        try {
            Future<String> futureReplace = this.fork(() -> (String)nonOwnerCache.put((Object)"key-to-the-cache", (Object)"second-put"));
            barrier.await(5L, TimeUnit.SECONDS);
            Future<String> futureGet = this.fork(() -> (String)nonOwnerCache.get((Object)"key-to-the-cache"));
            AssertJUnit.assertEquals((String)"first-put", (String)futureGet.get(3L, TimeUnit.SECONDS));
            this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
            barrier.await(5L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)"first-put", (String)futureReplace.get());
            AssertJUnit.assertEquals((String)"first-put", (String)futureGet.get(5L, TimeUnit.SECONDS));
        }
        finally {
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(nonOwnerCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBackupOwnerInvalidatesL1WhenPrimaryIsUnaware() throws InterruptedException, TimeoutException, BrokenBarrierException, ExecutionException {
        Cache<K, V>[] owners = this.getOwners("key-to-the-cache", 2);
        Cache ownerCache = owners[0];
        Cache backupOwnerCache = owners[1];
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        CyclicBarrier backupPutBarrier = new CyclicBarrier(2);
        this.addBlockingInterceptor(backupOwnerCache, backupPutBarrier, this.getCommitCommand(), this.getL1InterceptorClass(), false);
        try {
            Future<String> future = this.fork(() -> (String)ownerCache.put((Object)"key-to-the-cache", (Object)"second-put"));
            backupPutBarrier.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)"first-put", (String)((String)ownerCache.getAdvancedCache().getDataContainer().get((Object)"key-to-the-cache").getValue()));
            AssertJUnit.assertEquals((String)"first-put", (String)((String)backupOwnerCache.getAdvancedCache().getDataContainer().get((Object)"key-to-the-cache").getValue()));
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(ownerCache);
            CyclicBarrier ownerGetBarrier = new CyclicBarrier(2);
            this.addBlockingInterceptor(ownerCache, ownerGetBarrier, GetCacheEntryCommand.class, this.getL1InterceptorClass(), false);
            AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
            this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
            backupPutBarrier.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)"first-put", (String)future.get(10L, TimeUnit.SECONDS));
            ownerGetBarrier.await(10L, TimeUnit.SECONDS);
            ownerGetBarrier.await(10L, TimeUnit.SECONDS);
            DistSyncTxL1FuncTest.eventually(() -> !this.isInL1(nonOwnerCache, "key-to-the-cache"));
            AssertJUnit.assertEquals((String)"second-put", (String)((String)ownerCache.getAdvancedCache().getDataContainer().get((Object)"key-to-the-cache").getValue()));
        }
        finally {
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(ownerCache);
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(backupOwnerCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInvalidationSynchronous() throws Exception {
        Cache<K, V>[] owners = this.getOwners("key-to-the-cache", 2);
        Cache ownerCache = owners[0];
        Cache backupOwnerCache = owners[1];
        Cache nonOwnerCache = this.getFirstNonOwner("key-to-the-cache");
        ownerCache.put((Object)"key-to-the-cache", (Object)"first-put");
        AssertJUnit.assertEquals((String)"first-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
        this.assertIsInL1(nonOwnerCache, "key-to-the-cache");
        ControlledRpcManager crm = ControlledRpcManager.replaceRpcManager(ownerCache, new Class[0]);
        ControlledRpcManager crm2 = ControlledRpcManager.replaceRpcManager(backupOwnerCache, new Class[0]);
        try {
            Future<String> future = this.fork(() -> (String)ownerCache.put((Object)"key-to-the-cache", (Object)"second-put"));
            if (!this.onePhaseCommitOptimization) {
                crm.expectCommand(PrepareCommand.class).send().receiveAll();
            }
            ControlledRpcManager.BlockedRequest<InvalidateL1Command> blockedInvalidate1 = crm.expectCommand(InvalidateL1Command.class);
            crm2.expectNoCommand(100L, TimeUnit.MILLISECONDS);
            try {
                future.get(1L, TimeUnit.SECONDS);
                AssertJUnit.fail((String)"This should have timed out since, they cannot invalidate L1");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            blockedInvalidate1.send().receiveAll();
            if (this.onePhaseCommitOptimization) {
                crm.expectCommand(PrepareCommand.class).send().receiveAll();
            } else {
                crm.expectCommand(CommitCommand.class).send().receiveAll();
                crm.expectCommand(TxCompletionNotificationCommand.class).send();
            }
            AssertJUnit.assertEquals((String)"first-put", (String)future.get(10L, TimeUnit.SECONDS));
            this.assertIsNotInL1(nonOwnerCache, "key-to-the-cache");
            AssertJUnit.assertEquals((String)"second-put", (String)((String)nonOwnerCache.get((Object)"key-to-the-cache")));
        }
        finally {
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(ownerCache);
            DistSyncTxL1FuncTest.removeAllBlockingInterceptorsFromCache(backupOwnerCache);
            crm.revertRpcManager();
            crm2.revertRpcManager();
        }
    }
}

