/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.versioning.DistWriteSkewTest;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.MagicKey;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="container.versioning.DistL1WriteSkewTest", groups={"functional"})
public class DistL1WriteSkewTest
extends DistWriteSkewTest {
    @Override
    protected void decorate(ConfigurationBuilder builder) {
        builder.clustering().l1().enable();
        builder.clustering().remoteTimeout(4L, TimeUnit.MINUTES);
    }

    @Test
    public void testL1ValuePutCanExpire() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        MagicKey hello = new MagicKey("hello", cache0, cache1);
        DistributionTestHelper.assertIsNotInL1(cache2, hello);
        cache2.put((Object)hello, (Object)"world 1");
        DistributionTestHelper.assertIsInL1(cache2, hello);
    }

    @Test
    public void testL1ValueGetCanExpire() {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        Cache cache2 = this.cache(2);
        MagicKey hello = new MagicKey("hello", cache0, cache1);
        DistributionTestHelper.assertIsNotInL1(cache2, hello);
        cache0.put((Object)hello, (Object)"world 1");
        AssertJUnit.assertEquals((Object)"world 1", (Object)cache2.get((Object)hello));
        DistributionTestHelper.assertIsInL1(cache2, hello);
    }

    public void testL1Enabled() {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertTrue((String)("L1 not enabled for " + String.valueOf(this.address(cache))), (boolean)cache.getCacheConfiguration().clustering().l1().enabled());
        }
    }
}

