/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.offheap.OffHeapMultiNodeTest;
import org.infinispan.encoding.DataConversion;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.offheap.OffHeapSingleNodeTest")
public class OffHeapSingleNodeTest
extends OffHeapMultiNodeTest {
    protected ControlledTimeService timeService;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = OffHeapSingleNodeTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        dcc.memory().storageType(StorageType.OFF_HEAP);
        this.addClusterEnabledCacheManager(dcc);
        this.configureTimeService();
    }

    protected void configureTimeService() {
        this.timeService = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.cacheManagers.get(0), TimeService.class, this.timeService, true);
    }

    public void testLotsOfWrites() {
        Cache cache = this.cache(0);
        for (int i = 0; i < 5000; ++i) {
            cache.put((Object)("key" + i), (Object)("value" + i));
        }
    }

    public void testExpiredEntryCompute() throws IOException, InterruptedException {
        Cache cache = this.cache(0);
        String key = "key";
        cache.put((Object)key, (Object)"value", 10L, TimeUnit.MILLISECONDS);
        this.timeService.advance(20L);
        DataConversion keyDataConversion = cache.getAdvancedCache().getKeyDataConversion();
        WrappedBytes keyWB = (WrappedBytes)keyDataConversion.toStorage((Object)key);
        AtomicBoolean invoked = new AtomicBoolean(false);
        DataContainer container = cache.getAdvancedCache().getDataContainer();
        container.compute((Object)keyWB, (k, e, f) -> {
            invoked.set(true);
            return e;
        });
        AssertJUnit.assertTrue((boolean)invoked.get());
        AssertJUnit.assertNotNull((Object)container.peek((Object)keyWB));
        AssertJUnit.assertNull((Object)cache.get((Object)key));
        AssertJUnit.assertNull((Object)container.peek((Object)keyWB));
    }
}

