/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import java.util.HashSet;
import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.conflict.impl.BaseMergePolicyTest;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="partitionhandling.DenyReadWriteRemoveAllTest")
public class DenyReadWriteRemoveAllTest
extends BaseMergePolicyTest {
    @Override
    public Object[] factory() {
        return new Object[]{new DenyReadWriteRemoveAllTest(CacheMode.REPL_SYNC, "PD-5N", new int[]{0, 1, 2}, new int[]{3, 4}), new DenyReadWriteRemoveAllTest(CacheMode.REPL_SYNC, "AD-4N", AvailabilityMode.DEGRADED_MODE, new int[]{0, 1}, new int[]{2, 3}), new DenyReadWriteRemoveAllTest(CacheMode.REPL_SYNC, "PD-4N", new int[]{0, 1, 2}, new int[]{3}), new DenyReadWriteRemoveAllTest(CacheMode.REPL_SYNC, "PD-3N", new int[]{0, 1}, new int[]{2}), new DenyReadWriteRemoveAllTest(CacheMode.REPL_SYNC, "AD-2N", AvailabilityMode.DEGRADED_MODE, new int[]{0}, new int[]{1}), new DenyReadWriteRemoveAllTest(CacheMode.DIST_SYNC, "AD-5N", AvailabilityMode.DEGRADED_MODE, new int[]{0, 1, 2}, new int[]{3, 4}), new DenyReadWriteRemoveAllTest(CacheMode.DIST_SYNC, "AD-4N", AvailabilityMode.DEGRADED_MODE, new int[]{0, 1}, new int[]{2, 3}), new DenyReadWriteRemoveAllTest(CacheMode.DIST_SYNC, "PD-4N", new int[]{0, 1, 2}, new int[]{3}), new DenyReadWriteRemoveAllTest(CacheMode.DIST_SYNC, "PD-3N", new int[]{0, 1}, new int[]{2}), new DenyReadWriteRemoveAllTest(CacheMode.DIST_SYNC, "AD-2N", AvailabilityMode.DEGRADED_MODE, new int[]{0}, new int[]{1})};
    }

    public DenyReadWriteRemoveAllTest() {
    }

    public DenyReadWriteRemoveAllTest(CacheMode cacheMode, String description, int[] partition1, int[] partition2) {
        this(cacheMode, description, null, partition1, partition2);
    }

    public DenyReadWriteRemoveAllTest(CacheMode cacheMode, String description, AvailabilityMode availabilityMode, int[] partition1, int[] partition2) {
        super(cacheMode, description, availabilityMode, partition1, partition2);
        this.mergePolicy = MergePolicy.REMOVE_ALL;
        this.partitionHandling = PartitionHandling.DENY_READ_WRITES;
        this.valueAfterMerge = null;
    }

    @Override
    protected void beforeSplit() {
        this.conflictKey = new MagicKey(this.cache(this.p0.node(0)), this.cache(this.p1.node(0)));
        this.cache(this.p0.node(0)).put((Object)this.conflictKey, (Object)"V1");
        this.cache(this.p1.node(0)).getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL).put((Object)this.conflictKey, (Object)"V2");
    }

    @Override
    protected void splitCluster() {
        int i;
        List allMembers = this.advancedCache(0).getRpcManager().getMembers();
        for (i = 0; i < this.numMembersInCluster; ++i) {
            Assert.assertEquals(new HashSet(this.partitionHandlingManager(i).getLastStableTopology().getMembers()), new HashSet(allMembers));
        }
        if (this.p0.getExpectedMode() == AvailabilityMode.DEGRADED_MODE) {
            DenyReadWriteRemoveAllTest.eventually(() -> {
                for (int i = 0; i < this.numMembersInCluster; ++i) {
                    if (this.partitionHandlingManager(i).getAvailabilityMode() == AvailabilityMode.AVAILABLE) continue;
                    return false;
                }
                return true;
            });
        }
        this.splitCluster(this.p0.getNodes(), this.p1.getNodes());
        if (this.p0.getExpectedMode() != AvailabilityMode.DEGRADED_MODE) {
            TestingUtil.waitForNoRebalance(this.getPartitionCaches(this.p0));
        } else {
            for (i = 0; i < this.numMembersInCluster; ++i) {
                Assert.assertEquals(new HashSet(this.partitionHandlingManager(i).getLastStableTopology().getMembers()), new HashSet(allMembers));
            }
            this.partition(0).assertDegradedMode();
            this.partition(0).assertKeyNotAvailableForRead(this.conflictKey);
        }
        this.partition(1).assertDegradedMode();
        this.partition(1).assertKeyNotAvailableForRead(this.conflictKey);
    }

    @Override
    protected void duringSplit(AdvancedCache preferredPartitionCache, AdvancedCache otherCache) {
    }

    @Override
    protected void afterConflictResolutionAndMerge() {
        this.partition(0).assertAvailabilityMode(AvailabilityMode.AVAILABLE);
        super.afterConflictResolutionAndMerge();
        AssertJUnit.assertNull((Object)this.cache(this.p0.node(0)).get((Object)this.conflictKey));
    }
}

