/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.eviction.EvictionStrategy;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.parsing.ConfigurationBuilderHolderTest")
public class ConfigurationBuilderHolderTest {
    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp=".*needs either off-heap or a binary compatible.*")
    public void testConfigNotValid() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        ConfigurationBuilder concreteConfigBuilder = holder.newConfigurationBuilder("concrete");
        concreteConfigBuilder.memory().maxSize("1.5 GB").storage(StorageType.HEAP).whenFull(EvictionStrategy.REMOVE);
        holder.resolveConfigurations();
    }

    public void testTemplateHasRequiredConfigForValidation() {
        ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
        ConfigurationBuilder templateConfigBuilder = holder.newConfigurationBuilder("template");
        templateConfigBuilder.encoding().mediaType(MediaType.APPLICATION_PROTOSTREAM);
        templateConfigBuilder.template(true);
        ConfigurationBuilder concreteConfigBuilder = holder.newConfigurationBuilder("concrete");
        concreteConfigBuilder.configuration("template");
        concreteConfigBuilder.memory().maxSize("1.5 GB").storage(StorageType.HEAP).whenFull(EvictionStrategy.REMOVE);
        holder.resolveConfigurations();
    }
}

