/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.wildfly.common.Assert;

@Test(testName="configuration.cache.IndexingConfigurationBuilderTest", groups={"unit"})
public class IndexingConfigurationBuilderTest {
    public void testIndexingEntitiesMerge() {
        ConfigurationBuilder one = new ConfigurationBuilder();
        one.indexing().enable().addIndexedEntities(new String[]{"a", "b"});
        ConfigurationBuilder two = new ConfigurationBuilder();
        two.indexing().enable().addIndexedEntities(new String[]{"c", "d"});
        two.indexing().read(one.indexing().create(), new Combine(Combine.RepeatedAttributes.MERGE, Combine.Attributes.MERGE));
        IndexingConfiguration cfg = two.indexing().create();
        Assert.assertTrue((boolean)cfg.indexedEntityTypes().containsAll(Arrays.asList("a", "b", "c", "d")));
    }

    public void testIndexingEntitiesOverride() {
        ConfigurationBuilder one = new ConfigurationBuilder();
        one.indexing().enable().addIndexedEntities(new String[]{"a", "b"});
        ConfigurationBuilder two = new ConfigurationBuilder();
        two.indexing().enable().addIndexedEntities(new String[]{"c", "d"});
        two.indexing().read(one.indexing().create(), new Combine(Combine.RepeatedAttributes.OVERRIDE, Combine.Attributes.MERGE));
        IndexingConfiguration cfg = two.indexing().create();
        Assert.assertTrue((boolean)cfg.indexedEntityTypes().contains("a"));
        Assert.assertTrue((boolean)cfg.indexedEntityTypes().contains("b"));
        AssertJUnit.assertFalse((boolean)cfg.indexedEntityTypes().contains("c"));
        AssertJUnit.assertFalse((boolean)cfg.indexedEntityTypes().contains("d"));
    }
}

