/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteParsingTest")
public class XSiteParsingTest
extends AbstractInfinispanTest {
    public void testMultipleStackParents() throws IOException {
        String config = TestingUtil.wrapXMLWithSchema("<jgroups><stack name=\"parent\" extends=\"udp\">  <UDP mcast_port=\"54444\"/></stack><stack name=\"bridge\" extends=\"tcp\">  <MPING mcast_port=\"55555\" /></stack><stack name=\"xsite\" extends=\"parent\">  <relay.RELAY2 site=\"a\" />  <remote-sites default-stack=\"bridge\">    <remote-site name=\"a\" />    <remote-site name=\"b\" />  </remote-sites></stack></jgroups><cache-container>   <transport cluster=\"multiple-parent-stack\" stack=\"xsite\"/></cache-container>");
        try (DefaultCacheManager cm = new DefaultCacheManager((InputStream)new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8)));){
            AssertJUnit.assertTrue((boolean)TestingUtil.extractGlobalComponent((CacheContainer)cm, Transport.class).isSiteCoordinator());
        }
    }

    public void testInvalidMaxTombstoneCleanupDelay() {
        String config1 = TestingUtil.wrapXMLWithSchema("<cache-container>   <transport/>      <distributed-cache name=\"A\">         <backups max-cleanup-delay=\"-1\"/>      </distributed-cache></cache-container>");
        this.assertCacheConfigurationException(config1, "ISPN000951: Invalid value -1 for attribute max-cleanup-delay: must be a number greater than zero");
        String config2 = TestingUtil.wrapXMLWithSchema("<cache-container>   <transport/>      <distributed-cache name=\"B\">         <backups max-cleanup-delay=\"0\"/>      </distributed-cache></cache-container>");
        this.assertCacheConfigurationException(config2, "ISPN000951: Invalid value 0 for attribute max-cleanup-delay: must be a number greater than zero");
    }

    private void assertCacheConfigurationException(String config, String messageRegex) {
        ParserRegistry parserRegistry = new ParserRegistry();
        Exceptions.expectException(CacheConfigurationException.class, (String)messageRegex, () -> parserRegistry.parse(config));
    }
}

