/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.xsite.CountingCustomFailurePolicy;
import org.infinispan.xsite.CustomXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.AlwaysRemoveXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.DefaultXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNonNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.PreferNullXSiteEntryMergePolicy;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsingTest")
public class XSiteFileParsingTest
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-test.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml(FILE_NAME, false, true, TransportFlags.minimalXsiteFlags());
    }

    public void testLocalSiteName() {
        JGroupsTransport transport = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)this.cacheManager, Transport.class);
        transport.checkCrossSiteAvailable();
        AssertJUnit.assertEquals((String)"LON-1", (String)transport.localSiteName());
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        this.testDefault(dcc);
    }

    public void testBackupNyc() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("backupNyc");
        AssertJUnit.assertEquals((int)0, (int)dcc.sites().allBackups().size());
        BackupForConfiguration backupForConfiguration = dcc.sites().backupFor();
        AssertJUnit.assertEquals((String)"someCache", (String)backupForConfiguration.remoteCache());
        AssertJUnit.assertEquals((String)"NYC", (String)backupForConfiguration.remoteSite());
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoBackups() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackups");
        AssertJUnit.assertEquals((int)0, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
    }

    public void testCustomBackupPolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("customBackupPolicy");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        BackupConfigurationBuilder nyc2 = new BackupConfigurationBuilder(null).site("NYC2").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.CUSTOM).failurePolicyClass(CountingCustomFailurePolicy.class.getName()).replicationTimeout(160000L).useTwoPhaseCommit(false);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc2.create()));
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    public void testXSiteMergePolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("conflictResolver");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertEquals((Object)PreferNonNullXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
    }

    public void testXSiteMergePolicy2() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("conflictResolver2");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertEquals((Object)PreferNullXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
    }

    public void testXSiteMergePolicy3() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("conflictResolver3");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertEquals((Object)AlwaysRemoveXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
    }

    public void testCustomXSiteMergePolicy() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("customConflictResolver");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertEquals(CustomXSiteEntryMergePolicy.class, (Object)dcc.sites().mergePolicy().getClass());
        Cache cache = this.cacheManager.getCache("customConflictResolver");
        XSiteEntryMergePolicy resolver = (XSiteEntryMergePolicy)ComponentRegistry.componentOf((Cache)cache, XSiteEntryMergePolicy.class);
        AssertJUnit.assertEquals(CustomXSiteEntryMergePolicy.class, (Object)resolver.getClass());
    }

    public void testAutoStateTransfer() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("autoStateTransfer");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertEquals((Object)XSiteStateTransferMode.AUTO, (Object)((BackupConfiguration)dcc.sites().allBackups().get(0)).stateTransfer().mode());
    }

    public void testTombstoneConfiguration() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("tombstoneCleanup");
        AssertJUnit.assertEquals((long)3000L, (long)dcc.sites().maxTombstoneCleanupDelay());
        AssertJUnit.assertEquals((int)4000, (int)dcc.sites().tombstoneMapSize());
    }

    private void testDefault(Configuration dcc) {
        AssertJUnit.assertEquals((int)2, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertEquals((Object)DefaultXSiteEntryMergePolicy.getInstance(), (Object)dcc.sites().mergePolicy());
        BackupConfigurationBuilder nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.IGNORE).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc.create()));
        BackupConfigurationBuilder sfo = new BackupConfigurationBuilder(null).site("SFO").strategy(BackupConfiguration.BackupStrategy.ASYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(15000L).useTwoPhaseCommit(false);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(sfo.create()));
    }
}

