/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsing3Test")
public class XSiteFileParsing3Test
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-offline-test.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml(FILE_NAME, false, true, TransportFlags.minimalXsiteFlags());
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)1);
        this.testDefault(dcc);
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoTakeOffline() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noTakeOffline");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        BackupConfiguration nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.WARN).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false).create();
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc));
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
    }

    public void testTakeOfflineDifferentConfig() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("takeOfflineDifferentConfig");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        BackupConfigurationBuilder nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.IGNORE).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false);
        nyc.takeOffline().afterFailures(321).minTimeToWait(3765L);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc.create()));
    }

    private void testDefault(Configuration dcc) {
        BackupConfigurationBuilder nyc = new BackupConfigurationBuilder(null).site("NYC").strategy(BackupConfiguration.BackupStrategy.SYNC).backupFailurePolicy(BackupFailurePolicy.IGNORE).failurePolicyClass(null).replicationTimeout(12003L).useTwoPhaseCommit(false);
        nyc.takeOffline().afterFailures(123).minTimeToWait(5673L);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc.create()));
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
    }
}

