/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.UpdatableConfigurationTest")
public class UpdatableConfigurationTest {
    public void testUpdateConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.expiration().maxIdle(1000L).lifespan(2000L);
        Configuration configuration = builder.build();
        AssertJUnit.assertEquals((long)1000L, (long)configuration.expiration().maxIdle());
        AssertJUnit.assertEquals((long)2000L, (long)configuration.expiration().lifespan());
        builder = new ConfigurationBuilder();
        builder.expiration().maxIdle(3000L);
        configuration.update(null, (ConfigurationElement)builder.build());
        AssertJUnit.assertEquals((long)-1L, (long)configuration.expiration().lifespan());
        AssertJUnit.assertEquals((long)3000L, (long)configuration.expiration().maxIdle());
    }

    public void testConfigurationComparison() {
        ConfigurationBuilder b1 = new ConfigurationBuilder();
        b1.encoding().mediaType(MediaType.TEXT_PLAIN.toString());
        Configuration c1 = b1.build();
        ConfigurationBuilder b2 = new ConfigurationBuilder();
        b2.encoding().mediaType("application/x-protostream".toString());
        Configuration c2 = b2.build();
        try {
            c1.validateUpdate(null, (ConfigurationElement)c2);
            AssertJUnit.fail((String)"Expected exception");
        }
        catch (Throwable t) {
            AssertJUnit.assertEquals(IllegalArgumentException.class, t.getClass());
            AssertJUnit.assertEquals((String)Log.CONFIG.invalidConfiguration("local-cache").getMessage(), (String)t.getMessage());
            Throwable[] suppressed = t.getSuppressed();
            AssertJUnit.assertEquals((int)1, (int)suppressed.length);
            AssertJUnit.assertEquals((String)Log.CONFIG.incompatibleAttribute("local-cache.encoding", "media-type", "text/plain", "application/x-protostream").getMessage(), (String)suppressed[0].getMessage());
        }
    }
}

