/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.StaticCacheAliasTest")
public class StaticCacheAliasTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        EmbeddedCacheManager cm = TestCacheManagerFactory.fromString("<infinispan>\n<local-cache name=\"cacheA\" aliases=\"0\"/>\n<local-cache name=\"cacheB\" aliases=\"1\"/>\n</infinispan>\n");
        return cm;
    }

    public void testCacheAliases() {
        this.cacheManager.getCache("cacheA").put((Object)TestingUtil.k(), (Object)TestingUtil.v());
        this.cacheManager.getCache("cacheB").put((Object)TestingUtil.k(), (Object)TestingUtil.v(1));
        AssertJUnit.assertEquals((Object)TestingUtil.v(), (Object)this.cacheManager.getCache("0").get((Object)TestingUtil.k()));
        AssertJUnit.assertEquals((Object)TestingUtil.v(1), (Object)this.cacheManager.getCache("1").get((Object)TestingUtil.k()));
    }

    public void testAliasConflict() {
        Exceptions.expectException(CacheConfigurationException.class, (String)"^ISPN000975:.*", () -> this.cacheManager.defineConfiguration("cacheC", new ConfigurationBuilder().aliases(new String[]{"0"}).build()));
    }
}

