/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.StartCacheFromListenerTest")
public class StartCacheFromListenerTest
extends MultipleCacheManagersTest {
    final AtomicBoolean cacheStartingInvoked = new AtomicBoolean(false);

    @Override
    protected void createCacheManagers() throws Throwable {
        this.addClusterEnabledCacheManager();
        this.addClusterEnabledCacheManager();
        ConfigurationBuilder dcc = StartCacheFromListenerTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.manager(0).defineConfiguration("some", dcc.build());
        this.manager(0).defineConfiguration("single", dcc.build());
        this.manager(0).defineConfiguration("cacheStarting", dcc.build());
        this.manager(0).defineConfiguration("cacheStarted", dcc.build());
    }

    public void testSingleInvocation() {
        final EmbeddedCacheManager cacheManager = this.manager(0);
        GlobalComponentRegistry registry = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cacheManager);
        LinkedList<1> lifecycles = new LinkedList<1>();
        TestingUtil.replaceField(lifecycles, "moduleLifecycles", registry, GlobalComponentRegistry.class);
        lifecycles.add(new ModuleLifecycle(){
            final /* synthetic */ StartCacheFromListenerTest this$0;
            {
                this.this$0 = this$0;
            }

            public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
                log.debug((Object)"StartCacheFromListenerTest.cacheStarting");
                if (!this.this$0.cacheStartingInvoked.get()) {
                    this.this$0.cacheStartingInvoked.set(true);
                    Future fork = this.this$0.fork(() -> {
                        try {
                            return cacheManager.getCache("cacheStarting");
                        }
                        catch (Exception e) {
                            log.error((Object)"Got", (Throwable)e);
                            throw e;
                        }
                    });
                    try {
                        log.debug((Object)"About to wait in get");
                        Cache cache = (Cache)fork.get();
                        cache.put((Object)"k", (Object)"v");
                        log.debug((Object)"returned from get!");
                    }
                    catch (InterruptedException e) {
                        log.error((Object)"Interrupted while waiting for the cache to start");
                    }
                    catch (ExecutionException e) {
                        log.error((Object)"Failed to start cache", (Throwable)e);
                    }
                }
            }
        });
        log.debug((Object)"StartCacheFromListenerTest.testSingleInvocation1");
        Cache some = cacheManager.getCache("some");
        log.debug((Object)"StartCacheFromListenerTest.testSingleInvocation2");
        some.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)cacheManager.getCache("cacheStarting").get((Object)"k"));
    }

    public void testStartSameCache() {
        final EmbeddedCacheManager cacheManager = this.manager(0);
        GlobalComponentRegistry registry = TestingUtil.extractGlobalComponentRegistry((CacheContainer)cacheManager);
        LinkedList<2> lifecycles = new LinkedList<2>();
        TestingUtil.replaceField(lifecycles, "moduleLifecycles", registry, GlobalComponentRegistry.class);
        lifecycles.add(new ModuleLifecycle(){
            final /* synthetic */ StartCacheFromListenerTest this$0;
            {
                this.this$0 = this$0;
            }

            public void cacheStarted(ComponentRegistry cr, String cacheName) {
                Cache cache = cacheManager.getCache("single");
                cache.put((Object)"k1", (Object)"v1");
            }
        });
        Cache some = cacheManager.getCache("single");
        some.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertEquals((Object)"v1", (Object)cacheManager.getCache("single").get((Object)"k1"));
        AssertJUnit.assertEquals((Object)"v2", (Object)cacheManager.getCache("single").get((Object)"k2"));
    }
}

