/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.CacheSet;
import org.infinispan.api.APINonTxTest;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class CacheAPITest
extends APINonTxTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = this.getDefaultStandaloneCacheConfig(true);
        cb.locking().isolationLevel(this.getIsolationLevel());
        this.addEviction(cb);
        this.amend(cb);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(true);
        cm.defineConfiguration("test", cb.build());
        this.cache = cm.getCache("test");
        return cm;
    }

    protected void amend(ConfigurationBuilder cb) {
    }

    protected abstract IsolationLevel getIsolationLevel();

    protected ConfigurationBuilder addEviction(ConfigurationBuilder cb) {
        return cb;
    }

    public void testConfiguration() {
        Configuration c = this.cache.getCacheConfiguration();
        AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)c.clustering().cacheMode());
        AssertJUnit.assertNotNull((Object)c.transaction().transactionManagerLookup());
    }

    public void testGetMembersInLocalMode() {
        AssertJUnit.assertNull((String)"Cache members should be null if running in LOCAL mode", (Object)this.manager(this.cache).getAddress());
    }

    public void testRollbackAfterOverwrite() throws Exception {
        String key = "key";
        String value = "value";
        String value2 = "value2";
        int size = 1;
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        AssertJUnit.assertEquals((int)size, (int)this.cache.size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
        AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertEquals((Object)value, (Object)this.cache.put((Object)key, (Object)value2));
            AssertJUnit.assertEquals((Object)value2, (Object)this.cache.get((Object)key));
            AssertJUnit.assertEquals((int)size, (int)this.cache.size());
            AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
            AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
            AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
            AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
            AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value2));
            AssertJUnit.assertFalse((boolean)this.cache.values().contains((Object)value));
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        AssertJUnit.assertEquals((int)size, (int)this.cache.size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
        AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
    }

    public void testRollbackAfterRemove() throws Exception {
        String key = "key";
        String value = "value";
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        int size = 1;
        AssertJUnit.assertEquals((int)size, (int)this.cache.size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
        AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertEquals((Object)value, (Object)this.cache.remove((Object)key));
            AssertJUnit.assertNull((String)value, (Object)this.cache.get((Object)key));
            int tmSize = 0;
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.size());
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.keySet().size());
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.values().size());
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.entrySet().size());
            AssertJUnit.assertFalse((boolean)this.cache.keySet().contains((Object)key));
            AssertJUnit.assertFalse((boolean)this.cache.values().contains((Object)value));
            tm.setRollbackOnly();
            return false;
        });
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        size = 1;
        AssertJUnit.assertEquals((int)size, (int)this.cache.size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
        AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
    }

    public void testEntrySetEqualityInTx(Method m) throws Exception {
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        this.cache.putAll(dataIn);
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        TestingUtil.withTx(tm, () -> {
            HashMap<Integer, String> txDataIn = new HashMap<Integer, String>();
            txDataIn.put(3, TestingUtil.v(m, 3));
            this.cache.putAll(txDataIn);
            CacheSet entries = this.cache.entrySet();
            dataIn.putAll(txDataIn);
            AssertJUnit.assertEquals(dataIn.entrySet(), (Object)entries);
            return null;
        });
    }

    public void testEntrySetIterationBeforeInTx(Method m) throws Exception {
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        this.cache.putAll(dataIn);
        HashMap foundValues = new HashMap();
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        TestingUtil.withTx(tm, () -> {
            CacheSet entries = this.cache.entrySet();
            this.cache.put((Object)3, (Object)TestingUtil.v(m, 3));
            this.cache.put((Object)4, (Object)TestingUtil.v(m, 4));
            for (Map.Entry entry : entries) {
                foundValues.put(entry.getKey(), entry.getValue());
            }
            tm.setRollbackOnly();
            return null;
        });
        dataIn.put(3, TestingUtil.v(m, 3));
        dataIn.put(4, TestingUtil.v(m, 4));
        AssertJUnit.assertEquals(dataIn, foundValues);
    }

    public void testEntrySetIterationAfterInTx(Method m) throws Exception {
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        this.cache.putAll(dataIn);
        HashMap foundValues = new HashMap();
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        TestingUtil.withTx(tm, () -> {
            CacheSet entries = this.cache.entrySet();
            Iterator itr = entries.iterator();
            this.cache.put((Object)3, (Object)TestingUtil.v(m, 3));
            this.cache.put((Object)4, (Object)TestingUtil.v(m, 4));
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                foundValues.put(entry.getKey(), entry.getValue());
            }
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals(dataIn, foundValues);
    }

    public void testEntrySetIterationInTx(Method m) throws Exception {
        HashMap<Integer, String> dataIn = new HashMap<Integer, String>();
        dataIn.put(1, TestingUtil.v(m, 1));
        dataIn.put(2, TestingUtil.v(m, 2));
        HashMap foundValues = new HashMap();
        TransactionManager tm = this.cache.getAdvancedCache().getTransactionManager();
        TestingUtil.withTx(tm, () -> {
            this.cache.putAll(dataIn);
            CacheSet entries = this.cache.entrySet();
            Iterator itr = entries.iterator();
            this.cache.put((Object)3, (Object)TestingUtil.v(m, 3));
            this.cache.put((Object)4, (Object)TestingUtil.v(m, 4));
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                foundValues.put(entry.getKey(), entry.getValue());
            }
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals(dataIn, foundValues);
    }

    public void testRollbackAfterPut() throws Exception {
        String key = "key";
        String value = "value";
        String key2 = "keyTwo";
        String value2 = "value2";
        this.cache.put((Object)key, (Object)value);
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        int size = 1;
        AssertJUnit.assertEquals((int)size, (int)this.cache.size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
        AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            this.cache.put((Object)key2, (Object)value2);
            AssertJUnit.assertEquals((Object)value2, (Object)this.cache.get((Object)key2));
            AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key2));
            int tmSize = 2;
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.size());
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.keySet().size());
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.values().size());
            AssertJUnit.assertEquals((int)tmSize, (int)this.cache.entrySet().size());
            AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value2));
            AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals((Object)value, (Object)this.cache.get((Object)key));
        AssertJUnit.assertEquals((int)size, (int)this.cache.size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)size, (int)this.cache.entrySet().size());
        AssertJUnit.assertTrue((boolean)this.cache.keySet().contains((Object)key));
        AssertJUnit.assertTrue((boolean)this.cache.values().contains((Object)value));
    }

    public void testSizeAfterClear() {
        for (int i = 0; i < 10; ++i) {
            this.cache.put((Object)i, (Object)("value" + i));
        }
        this.cache.clear();
        AssertJUnit.assertTrue((boolean)this.cache.isEmpty());
    }

    public void testPutIfAbsentAfterRemoveInTx() throws Exception {
        String key = "key_1";
        String old_value = "old_value";
        this.cache.put((Object)key, (Object)old_value);
        AssertJUnit.assertEquals((Object)old_value, (Object)this.cache.get((Object)key));
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertEquals((Object)old_value, (Object)this.cache.remove((Object)key));
            AssertJUnit.assertNull((Object)this.cache.get((Object)key));
            AssertJUnit.assertEquals((Object)this.cache.putIfAbsent((Object)key, (Object)"new_value"), null);
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals((Object)old_value, (Object)this.cache.get((Object)key));
    }

    public void testSizeInExplicitTxWithNonExistent() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k", (Object)"v");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertNull((Object)this.cache.get((Object)"no-exist"));
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            AssertJUnit.assertNull((Object)this.cache.put((Object)"no-exist", (Object)"value"));
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testSizeInExplicitTxWithRemoveNonExistent() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k", (Object)"v");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertNull((Object)this.cache.remove((Object)"no-exist"));
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            AssertJUnit.assertNull((Object)this.cache.put((Object)"no-exist", (Object)"value"));
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testSizeInExplicitTxWithRemoveExistent() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k", (Object)"v");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertNull((Object)this.cache.put((Object)"exist", (Object)"value"));
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache.remove((Object)"exist"));
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testSizeInExplicitTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k", (Object)"v");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertEquals((int)1, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testSizeInExplicitTxWithModification() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertNull((Object)this.cache.put((Object)"k2", (Object)"v2"));
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testEntrySetIteratorRemoveInExplicitTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            try (CloseableIterator entryIterator = this.cache.entrySet().iterator();){
                entryIterator.next();
                entryIterator.remove();
                AssertJUnit.assertEquals((int)0, (int)this.cache.size());
            }
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testKeySetIteratorRemoveInExplicitTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            CloseableIterator entryIterator = this.cache.keySet().iterator();
            while (entryIterator.hasNext()) {
                entryIterator.next();
                entryIterator.remove();
                AssertJUnit.assertEquals((int)0, (int)this.cache.size());
            }
            tm.setRollbackOnly();
            return null;
        });
    }

    public void testEntrySetIteratorRemoveContextEntryInExplicitTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            this.cache.put((Object)"k2", (Object)"v2");
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            CloseableIterator entryIterator = this.cache.entrySet().iterator();
            while (entryIterator.hasNext()) {
                entryIterator.next();
                entryIterator.remove();
            }
            AssertJUnit.assertEquals((int)0, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals((int)1, (int)this.cache.size());
    }

    public void testKeySetIteratorRemoveContextEntryInExplicitTx() throws Exception {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        TestingUtil.withTx(tm, () -> {
            this.cache.put((Object)"k2", (Object)"v2");
            AssertJUnit.assertEquals((int)2, (int)this.cache.size());
            CloseableIterator keyIterator = this.cache.keySet().iterator();
            while (keyIterator.hasNext()) {
                keyIterator.next();
                keyIterator.remove();
            }
            AssertJUnit.assertEquals((int)0, (int)this.cache.size());
            tm.setRollbackOnly();
            return null;
        });
        AssertJUnit.assertEquals((int)1, (int)this.cache.size());
    }

    public void testEntrySetForEachNonSerializable() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        ArrayList values = new ArrayList();
        this.cache.entrySet().forEach(values::add);
        AssertJUnit.assertEquals((int)1, (int)values.size());
        Map.Entry entry = (Map.Entry)values.iterator().next();
        AssertJUnit.assertEquals((Object)"k1", entry.getKey());
        AssertJUnit.assertEquals((Object)"v1", entry.getValue());
    }

    public void testKeySetForEachNonSerializable() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        ArrayList values = new ArrayList();
        this.cache.keySet().forEach(values::add);
        AssertJUnit.assertEquals((int)1, (int)values.size());
        AssertJUnit.assertEquals((Object)"k1", values.iterator().next());
    }

    public void testValuesForEachNonSerializable() {
        AssertJUnit.assertEquals((int)0, (int)this.cache.size());
        this.cache.put((Object)"k1", (Object)"v1");
        ArrayList values = new ArrayList();
        this.cache.values().forEach(values::add);
        AssertJUnit.assertEquals((int)1, (int)values.size());
        AssertJUnit.assertEquals((Object)"v1", values.iterator().next());
    }

    public void testMultipleWritesSameKeyInTx() throws Exception {
        TransactionManager tm = TestingUtil.getTransactionManager(this.cache);
        String key = "key";
        TestingUtil.withTx(tm, () -> {
            AssertJUnit.assertNull((Object)this.cache.put(key, (Object)"value1"));
            AssertJUnit.assertEquals((Object)"value1", (Object)this.cache.put(key, (Object)"value2"));
            AssertJUnit.assertEquals((Object)"value2", (Object)this.cache.put(key, (Object)"value3"));
            return null;
        });
    }
}

