/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import net.jcip.annotations.GuardedBy;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.metrics.impl.MetricsRegistryImpl;
import org.infinispan.metrics.impl.NoMetricRegistry;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsManager;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsManagerImpl;
import org.infinispan.remoting.transport.jgroups.NoOpJGroupsMetricManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={MetricsCollector.class, MetricsRegistry.class, JGroupsMetricsManager.class})
@Scope(value=Scopes.GLOBAL)
public final class MetricsComponentFactory
implements ComponentFactory,
AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(MetricsComponentFactory.class);
    @Inject
    GlobalConfiguration globalConfig;
    @GuardedBy(value="this")
    private MetricsRegistry registry;

    @Override
    public Object construct(String componentName) {
        if (componentName.equals(MetricsRegistry.class.getName())) {
            return this.createMetricRegistry();
        }
        if (componentName.equals(MetricsCollector.class.getName())) {
            if (this.isMetricsDisabled()) {
                return null;
            }
            try {
                return new MetricsCollector();
            }
            catch (Throwable t) {
                MetricsComponentFactory.logMissingDependencies(t);
                return null;
            }
        }
        if (componentName.equals(JGroupsMetricsManager.class.getName())) {
            if (this.createMetricRegistry() == NoMetricRegistry.NO_OP_INSTANCE) {
                return NoOpJGroupsMetricManager.INSTANCE;
            }
            return new JGroupsMetricsManagerImpl(this.globalConfig.metrics().histograms());
        }
        throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
    }

    private boolean isMetricsDisabled() {
        return !this.globalConfig.metrics().enabled();
    }

    private static void logMissingDependencies(Throwable t) {
        log.debug("Micrometer metrics are not available because classpath dependencies are missing.", t);
    }

    private synchronized MetricsRegistry createMetricRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        if (this.isMetricsDisabled()) {
            this.registry = NoMetricRegistry.NO_OP_INSTANCE;
            return this.registry;
        }
        try {
            this.registry = new MetricsRegistryImpl();
        }
        catch (Throwable t) {
            MetricsComponentFactory.logMissingDependencies(t);
            this.registry = NoMetricRegistry.NO_OP_INSTANCE;
        }
        return this.registry;
    }
}

