/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

public class ExceptionAckCommand
extends BackupAckCommand {
    public static final byte COMMAND_ID = 42;
    private Throwable throwable;

    public ExceptionAckCommand() {
    }

    public ExceptionAckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public ExceptionAckCommand(ByteString cacheName, long id, Throwable throwable, int topologyId) {
        super(cacheName, id, topologyId);
        this.throwable = throwable;
    }

    @Override
    public void ack(CommandAckCollector ackCollector) {
        CacheException remoteException = ResponseCollectors.wrapRemoteException(this.getOrigin(), this.throwable);
        ackCollector.completeExceptionally(this.id, remoteException, this.topologyId);
    }

    @Override
    public byte getCommandId() {
        return 42;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeLong(this.id);
        output.writeObject(this.throwable);
        output.writeInt(this.topologyId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.id = input.readLong();
        this.throwable = (Throwable)input.readObject();
        this.topologyId = input.readInt();
    }

    @Override
    public String toString() {
        return "ExceptionAckCommand{id=" + this.id + ", throwable=" + String.valueOf(this.throwable) + ", topologyId=" + this.topologyId + "}";
    }
}

