/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.infinispan.commons.test.PolarionJUnitTest;
import org.infinispan.commons.test.PolarionJUnitXMLWriter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.internal.IResultListener2;

public class PolarionJUnitXMLReporter
implements IResultListener2,
ISuiteListener {
    public static final Pattern DUPLICATE_TESTS_MODULE_PATTERN = Pattern.compile(".*-(embedded|remote|v\\d+)");
    private static final AtomicInteger m_numFailed = new AtomicInteger(0);
    private static final AtomicInteger m_numSkipped = new AtomicInteger(0);
    private static final Map<String, PolarionJUnitTest> m_allTests = Collections.synchronizedMap(new TreeMap());
    private static final int rerunFailingTestsCount = Integer.parseInt(System.getProperty("rerunFailingTestsCount", "0"));

    public void beforeConfiguration(ITestResult tr) {
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
    }

    public void onTestFailure(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        m_numFailed.incrementAndGet();
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        m_numFailed.incrementAndGet();
    }

    public void onTestSkipped(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        m_numSkipped.incrementAndGet();
    }

    public void onStart(ITestContext context) {
    }

    public void onFinish(ITestContext context) {
    }

    public void onStart(ISuite suite) {
    }

    public void onFinish(ISuite suite) {
        this.generateReport();
    }

    public void onConfigurationFailure(ITestResult tr) {
        this.checkDuplicatesAndAdd(tr);
        m_numFailed.incrementAndGet();
    }

    public void onConfigurationSkip(ITestResult tr) {
    }

    public void onConfigurationSuccess(ITestResult itr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateReport() {
        Map<String, PolarionJUnitTest> map = m_allTests;
        synchronized (map) {
            long elapsedTime = m_allTests.values().stream().mapToLong(PolarionJUnitTest::elapsedTime).sum();
            long testCount = m_allTests.values().size();
            String outputDir = String.format("%s/surefire-reports", System.getProperty("build.directory"));
            Map<String, List<PolarionJUnitTest>> testsByClass = m_allTests.values().stream().collect(Collectors.groupingBy(p -> p.clazz));
            for (Map.Entry<String, List<PolarionJUnitTest>> entry : testsByClass.entrySet()) {
                File outputFile = new File(outputDir, String.format("TEST-%s.xml", entry.getKey()));
                try (PolarionJUnitXMLWriter writer = new PolarionJUnitXMLWriter(outputFile);){
                    writer.start(entry.getKey(), testCount, m_numSkipped.get(), m_numFailed.get(), elapsedTime, true);
                    for (PolarionJUnitTest testCase : entry.getValue()) {
                        writer.writeTestCase(testCase);
                    }
                }
                catch (Exception e) {
                    System.err.printf("Error writing test report '%s'\n", outputFile.getName());
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private String testName(ITestResult res) {
        String moduleSuffix;
        StringBuilder result = new StringBuilder(res.getMethod().getMethodName());
        if (res.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            String dataProviderName = res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).dataProvider();
            if (res.getParameters().length != 0 && dataProviderName != null && !dataProviderName.isEmpty()) {
                result.append("(").append(this.deepToStringParameters(res));
            }
            if (res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).invocationCount() > 1) {
                if (result.indexOf("(") == -1) {
                    result.append("(");
                } else {
                    result.append(", ");
                }
                result.append("invoked ").append(res.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class).invocationCount()).append(" times");
            }
        }
        if ((moduleSuffix = this.getModuleSuffix()).contains("hibernate")) {
            if (result.indexOf("(") == -1) {
                result.append("(");
            } else {
                result.append(", ");
            }
            Matcher moduleMatcher = DUPLICATE_TESTS_MODULE_PATTERN.matcher(moduleSuffix);
            if (moduleMatcher.matches()) {
                result.append(moduleMatcher.group(1));
            }
        }
        if (result.indexOf("(") != -1) {
            result.append(")");
        }
        return result.toString();
    }

    private String deepToStringParameters(ITestResult res) {
        Object[] parameters = res.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            if (parameter == null) continue;
            if (parameter instanceof Path) {
                parameters[i] = ((Path)parameter).getFileName().toString();
                continue;
            }
            if (!parameter.getClass().getSimpleName().contains("$$Lambda$")) continue;
            res.setStatus(2);
            res.setThrowable((Throwable)new IllegalStateException("Cannot identify which test is running. Use NamedLambdas.of static method"));
        }
        return Arrays.deepToString(parameters);
    }

    private String getModuleSuffix() {
        return System.getProperty("infinispan.module-suffix").substring(1);
    }

    private void checkDuplicatesAndAdd(ITestResult tr) {
        PolarionJUnitTest meta;
        String instanceName = tr.getInstanceName();
        String key = instanceName + "." + this.testName(tr);
        if (m_allTests.containsKey(key)) {
            meta = m_allTests.get(key);
            if (this.duplicateTest(tr, meta)) {
                System.err.println("[" + this.getClass().getSimpleName() + "] Test case '" + key + "' already exists in the results");
                tr.setStatus(2);
                tr.setThrowable((Throwable)new IllegalStateException("Duplicate test: " + key));
            }
        } else {
            String testName = this.testName(tr);
            String className = tr.getTestClass().getRealClass().getName();
            meta = new PolarionJUnitTest(testName, className);
        }
        meta.add(tr);
        m_allTests.put(key, meta);
    }

    private boolean duplicateTest(ITestResult tr, PolarionJUnitTest meta) {
        int invocationCount;
        if (tr.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Test.class)) {
            Test test = tr.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class);
            invocationCount = test.invocationCount();
        } else {
            invocationCount = 1;
        }
        int numberOfExecutions = meta.numberOfExecutions();
        return numberOfExecutions > rerunFailingTestsCount && numberOfExecutions > invocationCount;
    }
}

