/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.sql;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.AbstractIterator;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.persistence.jdbc.common.JdbcUtil;
import org.infinispan.persistence.jdbc.common.TableOperations;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.common.logging.Log;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.NonBlockingStore;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public abstract class BaseTableOperations<K, V>
implements TableOperations<K, V> {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    protected final AbstractJdbcStoreConfiguration<?> configuration;

    public BaseTableOperations(AbstractJdbcStoreConfiguration<?> configuration) {
        this.configuration = configuration;
    }

    public abstract String getSelectRowSql();

    public abstract String getSelectAllSql(IntSet var1);

    public abstract String getDeleteRowSql();

    public abstract String getDeleteAllSql();

    public abstract String getUpsertRowSql();

    public abstract String getSizeSql();

    protected abstract MarshallableEntry<K, V> entryFromResultSet(ResultSet var1, Object var2, boolean var3, Predicate<? super K> var4) throws SQLException;

    protected abstract void prepareKeyStatement(PreparedStatement var1, Object var2) throws SQLException;

    protected abstract void prepareValueStatement(PreparedStatement var1, int var2, MarshallableEntry<? extends K, ? extends V> var3) throws SQLException;

    protected void prepareSizeStatement(PreparedStatement ps) throws SQLException {
    }

    protected void preparePublishStatement(PreparedStatement ps, IntSet segments) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarshallableEntry<K, V> loadEntry(Connection connection, int segment, Object key) throws SQLException {
        ResultSet rs;
        PreparedStatement ps;
        block3: {
            MarshallableEntry<K, V> marshallableEntry;
            ps = null;
            rs = null;
            try {
                String selectSql = this.getSelectRowSql();
                if (log.isTraceEnabled()) {
                    log.tracef("Running select row sql '%s'", selectSql);
                }
                ps = connection.prepareStatement(selectSql);
                ps.setQueryTimeout(this.configuration.readQueryTimeout());
                this.prepareKeyStatement(ps, key);
                rs = ps.executeQuery();
                if (!rs.next()) break block3;
                marshallableEntry = this.entryFromResultSet(rs, key, true, null);
            }
            catch (Throwable throwable) {
                JdbcUtil.safeClose(rs);
                JdbcUtil.safeClose(ps);
                throw throwable;
            }
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            return marshallableEntry;
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteEntry(Connection connection, int segment, Object key) throws SQLException {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String deleteSql = this.getDeleteRowSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running delete row sql '%s'", deleteSql);
            }
            ps = connection.prepareStatement(deleteSql);
            ps.setQueryTimeout(this.configuration.writeQueryTimeout());
            this.prepareKeyStatement(ps, key);
            bl = ps.executeUpdate() == 1;
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(ps);
            throw throwable;
        }
        JdbcUtil.safeClose(ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteAllRows(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            String deleteAllSql = this.getDeleteAllSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running delete all sql '%s'", deleteAllSql);
            }
            statement = connection.createStatement();
            int result = statement.executeUpdate(deleteAllSql);
            if (log.isTraceEnabled()) {
                log.tracef("Successfully removed %d rows.", result);
            }
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(statement);
            throw throwable;
        }
        JdbcUtil.safeClose(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upsertEntry(Connection connection, int segment, MarshallableEntry<? extends K, ? extends V> entry) throws SQLException {
        PreparedStatement ps = null;
        try {
            String upsertSql = this.getUpsertRowSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running upsert row sql '%s'", upsertSql);
            }
            ps = connection.prepareStatement(upsertSql);
            ps.setQueryTimeout(this.configuration.writeQueryTimeout());
            this.prepareValueStatement(ps, segment, entry);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(ps);
            throw throwable;
        }
        JdbcUtil.safeClose(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(Connection connection) throws SQLException {
        long l;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sizeSql = this.getSizeSql();
            if (log.isTraceEnabled()) {
                log.tracef("Running count sql '%s'", sizeSql);
            }
            ps = connection.prepareStatement(sizeSql);
            this.prepareSizeStatement(ps);
            rs = ps.executeQuery();
            rs.next();
            l = rs.getInt(1);
        }
        catch (Throwable throwable) {
            JdbcUtil.safeClose(rs);
            JdbcUtil.safeClose(ps);
            throw throwable;
        }
        JdbcUtil.safeClose(rs);
        JdbcUtil.safeClose(ps);
        return l;
    }

    @Override
    public void batchUpdates(Connection connection, int writePublisherCount, Publisher<Object> removePublisher, Publisher<NonBlockingStore.SegmentedPublisher<MarshallableEntry<K, V>>> writePublisher) throws SQLException {
        String upsertSql = this.getUpsertRowSql();
        String deleteSql = this.getDeleteRowSql();
        if (log.isTraceEnabled()) {
            log.tracef("Running batch upsert sql '%s'", upsertSql);
            log.tracef("Running batch delete sql '%s'", deleteSql);
        }
        try (PreparedStatement upsertBatch = connection.prepareStatement(upsertSql);
             PreparedStatement deleteBatch = connection.prepareStatement(deleteSql);){
            Throwable t;
            CompletionStage removeStage = Flowable.fromPublisher(removePublisher).doOnNext(key -> {
                this.prepareKeyStatement(deleteBatch, key);
                deleteBatch.addBatch();
            }).lastElement().doAfterSuccess(ignore -> deleteBatch.executeBatch()).flatMapCompletable(ignore -> Completable.complete()).toCompletionStage(null);
            ByRef throwableRef = new ByRef(null);
            ByRef hadValue = new ByRef(null);
            Flowable.fromPublisher(writePublisher).concatMapEager(sp -> Flowable.fromPublisher((Publisher)sp).doOnNext(me -> {
                this.prepareValueStatement(upsertBatch, sp.getSegment(), (MarshallableEntry<? extends K, ? extends V>)me);
                upsertBatch.addBatch();
            }), writePublisherCount, writePublisherCount).lastElement().blockingSubscribe(arg_0 -> ((ByRef)hadValue).set(arg_0), arg_0 -> ((ByRef)throwableRef).set(arg_0));
            if (hadValue.get() != null) {
                upsertBatch.executeBatch();
            }
            if ((t = (Throwable)throwableRef.get()) != null) {
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                throw Util.rewrapAsCacheException((Throwable)t);
            }
            CompletionStages.join((CompletionStage)removeStage);
        }
    }

    @Override
    public Flowable<MarshallableEntry<K, V>> publishEntries(Supplier<Connection> connectionSupplier, Consumer<Connection> connectionCloser, IntSet segments, Predicate<? super K> filter, boolean fetchValue) {
        return Flowable.using(() -> {
            String selectSql = this.getSelectAllSql(segments);
            if (log.isTraceEnabled()) {
                log.tracef("Running select all sql '%s'", selectSql);
            }
            return new FlowableConnection((Connection)connectionSupplier.get(), connectionCloser, selectSql);
        }, fc -> {
            PreparedStatement ps = fc.statement;
            this.preparePublishStatement(ps, segments);
            ps.setFetchSize(this.configuration.maxBatchSize());
            ResultSet rs = ps.executeQuery();
            return Flowable.fromIterable(() -> new ResultSetEntryIterator(rs, filter, fetchValue)).doFinally(() -> JdbcUtil.safeClose(rs));
        }, FlowableConnection::close, (boolean)false);
    }

    protected static class FlowableConnection {
        protected final boolean autoCommit;
        protected final Connection connection;
        protected final Consumer<Connection> connectionCloser;
        protected final PreparedStatement statement;

        public FlowableConnection(Connection connection, Consumer<Connection> connectionCloser, String sql) throws SQLException {
            this.connection = connection;
            this.connectionCloser = connectionCloser;
            this.autoCommit = connection.getAutoCommit();
            this.statement = connection.prepareStatement(sql);
            if (this.autoCommit) {
                connection.setAutoCommit(false);
            }
        }

        public boolean isAutoCommit() {
            return this.autoCommit;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Consumer<Connection> getConnectionCloser() {
            return this.connectionCloser;
        }

        public PreparedStatement getStatement() {
            return this.statement;
        }

        public void close() {
            JdbcUtil.safeClose(this.statement);
            if (this.autoCommit) {
                try {
                    this.connection.rollback();
                }
                catch (SQLException e) {
                    Log.PERSISTENCE.sqlFailureTxRollback(e);
                }
            }
            this.connectionCloser.accept(this.connection);
        }
    }

    protected class ResultSetEntryIterator
    extends AbstractIterator<MarshallableEntry<K, V>> {
        private final ResultSet rs;
        private final Predicate<? super K> filter;
        private final boolean fetchValue;

        public ResultSetEntryIterator(ResultSet rs, Predicate<? super K> filter, boolean fetchValue) {
            this.rs = rs;
            this.filter = filter;
            this.fetchValue = fetchValue;
        }

        protected MarshallableEntry<K, V> getNext() {
            try {
                while (this.rs.next()) {
                    MarshallableEntry entry = BaseTableOperations.this.entryFromResultSet(this.rs, null, this.fetchValue, this.filter);
                    if (entry == null) continue;
                    return entry;
                }
            }
            catch (SQLException e) {
                throw new CacheException((Throwable)e);
            }
            return null;
        }
    }
}

