/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import java.util.Vector;
import javax.constraints.Constraint;
import javax.constraints.Objective;
import javax.constraints.Problem;
import javax.constraints.ProblemState;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarSet;
import javax.constraints.extra.ConstraintTraceVar;
import javax.constraints.extra.PropagationEvent;
import javax.constraints.impl.BasicVarSet;
import javax.constraints.impl.search.AbstractSolver;
import javax.constraints.impl.search.goal.Dichotomize;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalAddSolution;
import javax.constraints.impl.search.goal.GoalApplySolution;
import javax.constraints.impl.search.goal.GoalAssignValues;
import javax.constraints.impl.search.goal.GoalAssignValuesTimeLimit;
import javax.constraints.impl.search.goal.GoalBacktrack;
import javax.constraints.impl.search.goal.GoalCheckMaxNumberOfSolutions;
import javax.constraints.impl.search.goal.GoalConstraint;
import javax.constraints.impl.search.goal.StrategyAsGoal;

public abstract class SolverWithGoals
extends AbstractSolver {
    public SolverWithGoals(Problem problem) {
        super(problem);
    }

    @Override
    public SearchStrategy newSearchStrategy() {
        if (this.getTimeLimit() <= 0) {
            return new GoalAssignValues(this);
        }
        return new GoalAssignValuesTimeLimit(this);
    }

    public abstract Object goalThis(Goal var1);

    public abstract boolean execute(Goal var1, ProblemState var2);

    public Goal goalVarEqValue(Var var, int n) {
        Constraint constraint = this.getProblem().linear(var, "=", n);
        GoalConstraint goalConstraint = new GoalConstraint(constraint);
        goalConstraint.setName("Assign " + n + " to " + var);
        return goalConstraint;
    }

    public Goal goalVarNeqValue(Var var, int n) {
        Constraint constraint = this.getProblem().linear(var, "!=", n);
        GoalConstraint goalConstraint = new GoalConstraint(constraint);
        goalConstraint.setName("Remove " + n + " from " + var);
        return goalConstraint;
    }

    public Goal goalVarLeValue(Var var, int n) {
        Constraint constraint = this.getProblem().linear(var, "<=", n);
        constraint.setName("" + var + " <= " + n);
        GoalConstraint goalConstraint = new GoalConstraint(constraint);
        return goalConstraint;
    }

    public Goal goalVarGeValue(Var var, int n) {
        Constraint constraint = this.getProblem().linear(var, ">=", n);
        constraint.setName("" + var + " >= " + n);
        GoalConstraint goalConstraint = new GoalConstraint(constraint);
        return goalConstraint;
    }

    public abstract Goal and(Goal var1, Goal var2);

    public abstract Goal or(Goal var1, Goal var2);

    public boolean execute(Goal goal) {
        return this.execute(goal, ProblemState.DO_NOT_RESTORE);
    }

    @Override
    public Solution findSolution(ProblemState problemState) {
        this.clearSolutions();
        Solution solution = null;
        Goal goal = this.combineSearchStrategies();
        Goal goal2 = goal.and(new GoalAddSolution(this));
        if (this.execute(goal2, problemState)) {
            solution = this.getSolution();
        }
        if (solution != null && !solution.isBound() && goal instanceof GoalAssignValuesTimeLimit) {
            this.setTimeLimitExceeded(true);
            this.getProblem().log("Solver exceeded Time Limit " + this.getTimeLimit() + " milliseconds");
            solution = null;
        }
        return solution;
    }

    @Override
    public Solution[] findAllSolutions() {
        this.clearSolutions();
        Goal goal = this.combineSearchStrategies();
        GoalAddSolution goalAddSolution = new GoalAddSolution((Solver)this, -1);
        GoalCheckMaxNumberOfSolutions goalCheckMaxNumberOfSolutions = new GoalCheckMaxNumberOfSolutions(this);
        GoalBacktrack goalBacktrack = new GoalBacktrack(this);
        Goal goal2 = goal.and(goalAddSolution);
        Goal goal3 = goalCheckMaxNumberOfSolutions.or(goalBacktrack);
        Goal goal4 = goal2.and(goal3);
        this.execute(goal4, ProblemState.DO_NOT_RESTORE);
        return this.getSolutions();
    }

    public Goal makeGoal(SearchStrategy searchStrategy) {
        Goal goal = searchStrategy.getType().equals((Object)SearchStrategy.SearchStrategyType.CUSTOM) ? new StrategyAsGoal((Solver)this, searchStrategy) : (Goal)searchStrategy;
        return goal;
    }

    public Goal combineSearchStrategies() {
        Vector<SearchStrategy> vector = this.getSearchStrategies();
        Goal goal = this.makeGoal(vector.elementAt(0));
        for (int i = 1; i < vector.size(); ++i) {
            Goal goal2 = this.makeGoal(vector.elementAt(i));
            goal = goal.and(goal2);
        }
        return goal;
    }

    @Override
    public Solution findOptimalSolutionDichotomize(Objective objective, Var var) {
        long l = System.currentTimeMillis();
        if (var.getName().isEmpty()) {
            var.setName("Objective");
        }
        if (this.getProblem().getVar(var.getName()) == null) {
            this.getProblem().add(var);
        }
        Var var2 = var;
        if (objective.equals((Object)Objective.MAXIMIZE)) {
            var2 = var.multiply(-1);
            var2.setName("-" + var.getName());
            this.getProblem().add(var2);
        }
        this.addObjective(var2);
        Dichotomize dichotomize = new Dichotomize(this, var2);
        Solution solution = dichotomize.execute();
        if (solution != null) {
            this.log("Optimal solution is found. Objective: " + solution.getValue(var2.getName()));
        }
        return solution;
    }

    @Override
    public boolean applySolution(Solution solution) {
        return this.execute(new GoalApplySolution(solution));
    }

    public abstract void backtrack() throws Exception;

    @Override
    public void trace(Var var) {
        this.trace(var, PropagationEvent.ANY);
    }

    public void trace(Var var, PropagationEvent propagationEvent) {
        if (propagationEvent == PropagationEvent.ANY) {
            this.trace(var, PropagationEvent.MIN);
            this.trace(var, PropagationEvent.MAX);
            this.trace(var, PropagationEvent.REMOVE);
            this.trace(var, PropagationEvent.VALUE);
        } else if (propagationEvent == PropagationEvent.RANGE) {
            this.trace(var, PropagationEvent.MIN);
            this.trace(var, PropagationEvent.MAX);
        } else {
            new ConstraintTraceVar(var, propagationEvent).post();
        }
    }

    @Override
    public void trace(Var[] varArray) {
        this.trace(varArray, PropagationEvent.ANY);
    }

    public void trace(Var[] varArray, PropagationEvent propagationEvent) {
        for (int i = 0; i < varArray.length; ++i) {
            this.trace(varArray[i], propagationEvent);
        }
    }

    @Override
    public void trace(VarSet varSet) {
        this.trace(varSet, PropagationEvent.ANY);
    }

    public void trace(VarSet varSet, PropagationEvent propagationEvent) {
        Var var = varSet.getCardinality();
        this.trace(var, propagationEvent);
        BasicVarSet basicVarSet = (BasicVarSet)varSet;
        Var[] varArray = basicVarSet.getRequiredVars();
        this.trace(varArray, propagationEvent);
    }
}

