/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Problem;
import javax.constraints.Solver;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalCheckTotalTimeLimit
extends Goal {
    int totalTimeLimit;
    long startTime = System.currentTimeMillis();

    public GoalCheckTotalTimeLimit(Solver solver) {
        super(solver, "CheckTotalTimeLimit");
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        SolverWithGoals solverWithGoals = this.getSolver();
        Problem problem = solverWithGoals.getProblem();
        long l = System.currentTimeMillis();
        int n = solverWithGoals.getTimeLimit();
        if (n > 0 && (long)(n * 1000) < l - this.startTime) {
            problem.log("The search is interrupted by TimeLimit " + n + " seconds");
            solverWithGoals.backtrack();
        }
        return null;
    }
}

