/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Solver;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalCheckMaxNumberOfSolutions
extends Goal {
    public GoalCheckMaxNumberOfSolutions(Solver solver) {
        super(solver, "check max solutions");
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        SolverWithGoals solverWithGoals = this.getSolver();
        int n = solverWithGoals.getMaxNumberOfSolutions();
        if (n <= 0) {
            solverWithGoals.backtrack();
        }
        if (solverWithGoals.getSolutions() == null || solverWithGoals.getNumberOfSolutions() == n) {
            solverWithGoals.log("Search interrupted by the MaxNumberOfSolutions: " + n);
            return null;
        }
        solverWithGoals.backtrack();
        return null;
    }
}

