/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.Var;
import javax.constraints.VarList;
import javax.constraints.VarSelector;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalAssignValue;
import javax.constraints.impl.search.goal.GoalCheckTimeLimit;
import javax.constraints.impl.search.selectors.ValueSelectorMin;
import javax.constraints.impl.search.selectors.VarSelectorInputOrder;

public class GoalAssignValuesTimeLimit
extends Goal {
    Var[] vars;
    VarSelector varSelector;
    ValueSelector valueSelector;
    Goal[] goals;
    Goal checkGoal;

    public GoalAssignValuesTimeLimit(Var[] varArray, VarSelector varSelector, ValueSelector valueSelector) {
        super(varArray[0].getProblem().getSolver(), "AssignValuesWithTimeLimit");
        this.init(varArray, varSelector, valueSelector);
    }

    public GoalAssignValuesTimeLimit(Solver solver, Var[] varArray) {
        super(solver, "AssignValuesTimeLimit");
        this.init(varArray, new VarSelectorInputOrder(this), new ValueSelectorMin());
    }

    public GoalAssignValuesTimeLimit(Solver solver) {
        super(solver, "AssignValuesTimeLimit");
        this.init(solver.getProblem().getVars(), new VarSelectorInputOrder(this), new ValueSelectorMin());
    }

    public void init(Var[] varArray, VarSelector varSelector, ValueSelector valueSelector) {
        this.vars = varArray;
        this.varSelector = varSelector;
        this.valueSelector = valueSelector;
        this.checkGoal = new GoalCheckTimeLimit(this.getSolver());
        this.createGoals(varArray);
    }

    public void createGoals(Var[] varArray) {
        this.goals = new Goal[varArray.length];
        for (int i = 0; i < varArray.length; ++i) {
            this.goals[i] = new GoalAssignValue(varArray[i], this.valueSelector);
        }
        this.checkGoal = new GoalCheckTimeLimit(this.getSolver());
    }

    @Override
    public void setVars(Var[] varArray) {
        this.createGoals(varArray);
    }

    @Override
    public void setVars(VarList varList) {
        Var[] varArray = new Var[varList.size()];
        for (int i = 0; i < varArray.length; ++i) {
            varArray[i] = (Var)varList.get(i);
        }
        this.createGoals(varArray);
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        int n = this.varSelector.select();
        if (n == -1) {
            return null;
        }
        boolean bl = this.getSolver().checkTimeLimit();
        if (bl) {
            String string = "Time limit " + this.solver.getTimeLimit() + " has been exceeded";
            this.solver.getProblem().log(string);
            return null;
        }
        return this.goals[n].and(this);
    }
}

