/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.Var;
import javax.constraints.VarList;
import javax.constraints.VarSelector;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalAssignValue;
import javax.constraints.impl.search.selectors.ValueSelectorMin;
import javax.constraints.impl.search.selectors.VarSelectorInputOrder;

public class GoalAssignValues
extends Goal {
    protected Goal[] goals;

    public GoalAssignValues(Var[] varArray, VarSelector varSelector, ValueSelector valueSelector) {
        super(varArray[0].getProblem().getSolver(), "AssignValues");
        this.setVarSelector(varSelector);
        this.setValueSelector(valueSelector);
        this.setVars(varArray);
    }

    public GoalAssignValues(Solver solver) {
        this(solver, solver.getProblem().getVars());
    }

    public GoalAssignValues(Solver solver, Var[] varArray) {
        super(solver, "AssignValues");
        this.setVarSelector(new VarSelectorInputOrder(this));
        this.setValueSelector(new ValueSelectorMin());
        this.setVars(varArray);
    }

    public void setGoals(Var[] varArray) {
        if (varArray == null) {
            return;
        }
        this.goals = new Goal[varArray.length];
        ValueSelector valueSelector = this.getValueSelector();
        for (int i = 0; i < varArray.length; ++i) {
            this.goals[i] = new GoalAssignValue(varArray[i], valueSelector);
        }
    }

    @Override
    public void setVars(Var[] varArray) {
        this.vars = varArray;
        this.setGoals(varArray);
    }

    @Override
    public void setValueSelector(ValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        if (this.vars != null) {
            this.setGoals(this.vars);
        }
    }

    @Override
    public void setVars(VarList varList) {
        Var[] varArray = new Var[varList.size()];
        for (int i = 0; i < varArray.length; ++i) {
            varArray[i] = (Var)varList.get(i);
        }
        this.setGoals(varArray);
    }

    public GoalAssignValues(Var[] varArray, VarSelector varSelector) {
        this(varArray, varSelector, new ValueSelectorMin());
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        int n = this.getVarSelector().select();
        if (n == -1) {
            return null;
        }
        Goal goal = this.goals[n];
        return goal.and(this);
    }
}

