/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Constraint;
import javax.constraints.Problem;
import javax.constraints.ValueSelector;
import javax.constraints.Var;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalConstraint;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalAssignValueTimeLimit
extends Goal {
    Var var;
    ValueSelector valueSelector;

    public GoalAssignValueTimeLimit(Var var, ValueSelector valueSelector) {
        super(var.getProblem().getSolver(), "AssignValueWithTimeLimit to " + var);
        this.var = var;
        this.valueSelector = valueSelector;
    }

    @Override
    public Goal execute() throws Exception {
        Problem problem = this.getProblem();
        this.trace();
        if (this.var.isBound()) {
            return null;
        }
        SolverWithGoals solverWithGoals = this.getSolver();
        if (solverWithGoals.checkTimeLimit()) {
            if (!solverWithGoals.isTimeLimitExceeded()) {
                solverWithGoals.setTimeLimitExceeded(true);
                problem.log("Time limit exceeded while instantiating " + this.var);
            }
            return null;
        }
        int n = this.valueSelector.select(this.var);
        Constraint constraint = problem.linear(this.var, "=", n);
        GoalConstraint goalConstraint = new GoalConstraint(constraint);
        Constraint constraint2 = problem.linear(this.var, "!=", n);
        GoalConstraint goalConstraint2 = new GoalConstraint(constraint2);
        return goalConstraint.or(goalConstraint2.and(this));
    }
}

