/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import java.util.Calendar;
import javax.constraints.ProblemState;
import javax.constraints.Solution;
import javax.constraints.Var;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalSaveSolution;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class Dichotomize {
    SolverWithGoals solver;
    Var objective;
    Goal searchGoal;
    int objectiveMin;
    int objectiveMax;
    int tolerance;
    int numberOfSolutions;
    int numberOfChoicePoints;
    int numberOfFailures;
    int numberOfTries;
    boolean checkLowerHalf;
    Solution solution;
    AbstractProblem p;
    int prevMax;
    int midObjective;
    int totalTimeLimit;
    long startTime;

    public Dichotomize(SolverWithGoals solverWithGoals, Var var) {
        this.solver = solverWithGoals;
        this.p = (AbstractProblem)solverWithGoals.getProblem();
        this.searchGoal = solverWithGoals.combineSearchStrategies();
        this.searchGoal = this.searchGoal.and(new GoalSaveSolution(solverWithGoals));
        this.objective = var;
        if (var.getName().isEmpty()) {
            var.setName("Objective");
        }
        if (this.p.getVar(var.getName()) == null) {
            this.p.add(var);
        }
        this.objectiveMin = var.getMin();
        this.objectiveMax = var.getMax();
        this.tolerance = solverWithGoals.getOptimizationTolerance();
        this.totalTimeLimit = solverWithGoals.getTimeLimit();
        this.startTime = System.currentTimeMillis();
        this.checkLowerHalf = false;
        this.numberOfTries = 0;
        this.solution = null;
        this.prevMax = 0;
        this.midObjective = 0;
    }

    public Solution execute() {
        this.p.debug("Dichotomize with objective within [" + this.objectiveMin + ";" + this.objectiveMax + "]");
        ++this.numberOfTries;
        this.solver.setTimeLimitStart();
        Solution solution = null;
        Goal goal = this.solver.goalVarGeValue(this.objective, this.objectiveMin);
        Goal goal2 = this.solver.goalVarLeValue(this.objective, this.objectiveMax);
        Goal goal3 = goal.and(goal2).and(this.searchGoal);
        try {
            if (this.solver.execute(goal3, ProblemState.RESTORE)) {
                solution = this.solver.getSolution();
            }
        }
        catch (Exception exception) {
            if (this.solver.isTimeLimitExceeded()) {
                this.p.log("WARNING: Time limit " + this.solver.getTimeLimit() + " mills for one solution search has been exceeded");
            }
            this.solver.log("ERROR: Unexpected search interruption!");
        }
        if (solution != null) {
            ++this.numberOfSolutions;
            this.solution = solution;
            this.solution.setSolutionNumber(this.numberOfSolutions);
            int n = this.solution.getValue(this.objective.getName());
            if (this.solver.isTraceSolutions()) {
                this.p.log("Found solution #" + this.numberOfSolutions + " objective=" + n + ". " + Calendar.getInstance().getTime());
            }
            this.objectiveMax = n - this.tolerance;
            if (Math.abs(n - this.objectiveMin) <= 0) {
                this.p.debug("This solution is optimal!");
                return this.solution;
            }
            if (this.solver.getMaxNumberOfSolutions() > 0 && this.numberOfSolutions == this.solver.getMaxNumberOfSolutions()) {
                this.p.log("The search is interrupted: MaxNumberOfSolutions has been reached");
                return this.solution;
            }
            this.midObjective = (int)Math.floor((this.objectiveMin + this.objectiveMax) / 2);
            this.prevMax = this.objectiveMax;
            this.objectiveMax = this.midObjective;
            this.checkLowerHalf = true;
        } else {
            this.p.debug("No solutions within [" + this.objectiveMin + ";" + this.objectiveMax + "]");
            if (this.checkLowerHalf) {
                ++this.midObjective;
                this.objectiveMax = this.prevMax - 1;
                if (this.midObjective > this.objectiveMax) {
                    return this.solution;
                }
                this.objectiveMin = this.midObjective;
                this.checkLowerHalf = false;
            } else {
                String string = "No solutions";
                if (this.solution != null) {
                    string = "Last solution was optimal!";
                }
                this.p.debug(string);
                return this.solution;
            }
        }
        return this.execute();
    }
}

