/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import javax.constraints.ProblemState;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.impl.AbstractProblem;

public class Dichotomize {
    Solver solver;
    Var objective;
    SearchStrategy searchStrategy;
    int objectiveMin;
    int objectiveMax;
    int tolerance;
    int numberOfSolutions;
    int numberOfChoicePoints;
    int numberOfFailures;
    int numberOfTries;
    boolean checkLowerHalf;
    Solution solution;
    AbstractProblem p;
    int prevMax;
    int midObjective;
    int totalTimeLimit;
    long startTime;

    public Dichotomize(Solver solver, Var var) {
        this.solver = solver;
        this.p = (AbstractProblem)solver.getProblem();
        this.searchStrategy = solver.getSearchStrategy();
        this.objective = var;
        if (var.getName().isEmpty()) {
            var.setName("Objective");
        }
        if (this.p.getVar(var.getName()) == null) {
            this.p.add(var);
        }
        this.objectiveMin = var.getMin();
        this.objectiveMax = var.getMax();
        this.tolerance = solver.getOptimizationTolerance();
        this.totalTimeLimit = solver.getTimeLimit();
        this.startTime = System.currentTimeMillis();
        this.checkLowerHalf = false;
        this.numberOfTries = 0;
        this.solution = null;
        this.prevMax = 0;
        this.midObjective = 0;
    }

    public Solution execute() {
        this.p.debug("Dichotomize with objective[" + this.objectiveMin + ";" + this.objectiveMax + "]");
        ++this.numberOfTries;
        this.solver.setTimeLimitStart();
        Solution solution = null;
        try {
            this.p.post(this.objective, ">=", this.objectiveMin);
            this.p.post(this.objective, "<=", this.objectiveMax);
            solution = this.solver.findSolution(ProblemState.RESTORE);
        }
        catch (Exception exception) {
            this.p.debug("No solutions within [" + this.objectiveMin + ";" + this.objectiveMax + "]");
        }
        if (solution != null) {
            ++this.numberOfSolutions;
            this.solution = solution;
            this.solution.setSolutionNumber(this.numberOfSolutions);
            int n = this.solution.getValue(this.objective.getName());
            this.p.debug("Found solution #" + this.numberOfSolutions + " objective=" + n);
            this.objectiveMax = n - this.tolerance;
            if (Math.abs(n - this.objectiveMin) <= 0) {
                this.p.debug("This solution is optimal!");
                return this.solution;
            }
            if (this.solver.getMaxNumberOfSolutions() > 0 && this.numberOfSolutions == this.solver.getMaxNumberOfSolutions()) {
                this.p.log("The search is interrupted: MaxNumberOfSolutions has been reached");
                return this.solution;
            }
            this.midObjective = (int)Math.floor((this.objectiveMin + this.objectiveMax) / 2);
            this.p.debug(this.objective.toString());
            this.p.debug("Try objective [" + this.objectiveMin + ";" + this.midObjective + "]");
            this.prevMax = this.objectiveMax;
            this.objectiveMax = this.midObjective;
            this.checkLowerHalf = true;
        } else {
            this.p.debug("Failure!");
            if (this.checkLowerHalf) {
                ++this.midObjective;
                this.objectiveMax = this.prevMax;
                if (this.midObjective > this.objectiveMax) {
                    return this.solution;
                }
                this.p.debug("Try objective [" + this.midObjective + ";" + this.objectiveMax + "]");
                this.objectiveMin = this.midObjective;
                this.checkLowerHalf = false;
            } else {
                String string = "No solutions";
                if (this.solution != null) {
                    string = "Last solution was optimal!";
                }
                this.p.debug(string);
                return this.solution;
            }
        }
        return this.execute();
    }
}

