/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import javax.constraints.ProblemState;
import javax.constraints.Solution;
import javax.constraints.SolutionIterator;
import javax.constraints.Var;
import javax.constraints.impl.constraint.ConstraintNotAllEqual;
import javax.constraints.impl.search.AbstractSolver;

public class BasicSolutionIterator
implements SolutionIterator {
    AbstractSolver solver;
    Solution solution;
    int solutionNumber;
    boolean noSolutions;
    long startTime;

    public BasicSolutionIterator(AbstractSolver abstractSolver) {
        this.solver = abstractSolver;
        this.solution = null;
        this.noSolutions = false;
        this.solutionNumber = 0;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean hasNext() {
        if (this.noSolutions) {
            return false;
        }
        this.solver.setTimeLimitStart();
        this.solution = null;
        try {
            long l = this.solver.getTimeLimit();
            long l2 = this.solver.getTimeLimitGlobal();
            if (l2 > 0L) {
                long l3 = System.currentTimeMillis() - this.startTime;
                if (l3 > l2) {
                    this.solver.log("Global time limit " + l2 + " millis has been exceeded.");
                    return false;
                }
                if (l3 + l > l2) {
                    this.solver.setTimeLimit((int)(l2 - l3));
                }
            }
            this.solution = this.solver.findSolution(ProblemState.RESTORE);
        }
        catch (Exception exception) {
            if (this.solver.isTimeLimitExceeded()) {
                this.solver.log("Time limit " + this.solver.getTimeLimit() + " mills for one solution search has been exceeded");
            }
            this.solver.log("ERROR: Unexpected search interruption!");
        }
        return this.solution != null;
    }

    @Override
    public Solution next() {
        if (this.solution == null) {
            throw new RuntimeException("Cannot use SolutionIterator.next() before checking the hasNext() returned true");
        }
        this.solution.setSolutionNumber(++this.solutionNumber);
        Var[] varArray = this.solver.getSearchStrategy().getVars();
        int[] nArray = new int[varArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.solution.getValue(varArray[i].getName());
        }
        try {
            new ConstraintNotAllEqual(varArray, nArray).post();
        }
        catch (Exception exception) {
            this.noSolutions = true;
        }
        return this.solution;
    }
}

