/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.constraints.Problem;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.impl.search.AbstractSolver;

public class BasicSolution
implements Solution {
    Solver solver;
    int solutionNumber;
    ResultInt[] intResults;
    ResultReal[] realResults;
    ResultSet[] setResults;
    static int varPerLine = 9;

    public BasicSolution(Solver solver, int n) {
        Object object;
        this.solver = solver;
        this.solutionNumber = n;
        Vector<SearchStrategy> vector = ((AbstractSolver)solver).getSearchStrategies();
        Vector<Var> vector2 = new Vector<Var>();
        for (SearchStrategy searchStrategy : vector) {
            for (Var var : object = searchStrategy.getVars()) {
                if (vector2.contains(var)) continue;
                vector2.add(var);
            }
        }
        this.intResults = new ResultInt[vector2.size()];
        Iterator<SearchStrategy> iterator = vector2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = (Var)((Object)iterator.next());
            this.intResults[n2++] = this.createResult((Var)object);
        }
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public Problem getProblem() {
        return this.solver.getProblem();
    }

    @Override
    public int getSolutionNumber() {
        return this.solutionNumber;
    }

    @Override
    public void setSolutionNumber(int n) {
        this.solutionNumber = n;
    }

    @Override
    public int getNumberOfVars() {
        if (this.intResults != null) {
            return this.intResults.length;
        }
        return 0;
    }

    @Override
    public int getNumberOfVarReals() {
        if (this.realResults != null) {
            return this.realResults.length;
        }
        return 0;
    }

    @Override
    public int getNumberOfVarSets() {
        if (this.setResults != null) {
            return this.setResults.length;
        }
        return 0;
    }

    @Override
    public int getValue(String string) {
        int n = this.getIndexOfInt(string);
        if (this.intResults[n].bound) {
            return this.intResults[n].value;
        }
        throw new RuntimeException("variable " + string + " is not bound");
    }

    @Override
    public int getAt(String string) {
        return this.getValue(string);
    }

    @Override
    public int getValue(int n) {
        if (this.intResults[n].bound) {
            return this.intResults[n].value;
        }
        throw new RuntimeException("variable " + this.intResults[n].varName + " is not bound");
    }

    @Override
    public double getRealValue(String string) {
        int n = this.getIndexOfReal(string);
        if (this.realResults[n].bound) {
            return (this.realResults[n].min + this.realResults[n].max) / 2.0;
        }
        throw new RuntimeException("real variable " + string + " is not bound");
    }

    @Override
    public double getRealValue(int n) {
        if (this.realResults[n].bound) {
            return (this.realResults[n].min + this.realResults[n].max) / 2.0;
        }
        throw new RuntimeException("real variable " + this.realResults[n].varName + " is not bound");
    }

    @Override
    public int getMin(int n) {
        return this.intResults[n].min;
    }

    @Override
    public int getMin(String string) {
        int n = this.getIndexOfInt(string);
        return this.intResults[n].min;
    }

    @Override
    public int getMax(int n) {
        return this.intResults[n].max;
    }

    @Override
    public int getMax(String string) {
        int n = this.getIndexOfInt(string);
        return this.intResults[n].max;
    }

    @Override
    public boolean isBound(int n) {
        return this.intResults[n].bound;
    }

    @Override
    public boolean isBound(String string) {
        int n = this.getIndexOfInt(string);
        return this.intResults[n].bound;
    }

    private int getIndexOfInt(String string) {
        for (int i = 0; i < this.intResults.length; ++i) {
            if (!string.equals(this.intResults[i].varName)) continue;
            return i;
        }
        throw new RuntimeException("ERROR: variable " + string + " not found in Solution");
    }

    private int getIndexOfReal(String string) {
        for (int i = 0; i < this.realResults.length; ++i) {
            if (!string.equals(this.realResults[i].varName)) continue;
            return i;
        }
        throw new RuntimeException("ERROR: real variable " + string + " not found in Solution");
    }

    @Override
    public boolean isBound() {
        for (int i = 0; i < this.intResults.length; ++i) {
            if (this.intResults[i].bound) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.intResults.length; ++i) {
            if (i > 0 && i % varPerLine == 0) {
                stringBuffer.append("\n\t");
            }
            stringBuffer.append(" " + this.intResults[i].toString());
        }
        return "Solution #" + this.solutionNumber + ":\n\t" + stringBuffer.toString();
    }

    @Override
    public void log() {
        this.getProblem().log(this.toString());
    }

    @Override
    public void log(int n) {
        varPerLine = n;
        this.log();
    }

    public void logVars() {
        for (int i = 0; i < this.intResults.length; ++i) {
            this.getProblem().log(this.intResults[i].toString());
        }
    }

    public void logVarReals() {
        for (int i = 0; i < this.realResults.length; ++i) {
            this.getProblem().log(this.realResults[i].toString());
        }
    }

    public void logVarSets() {
        for (int i = 0; i < this.setResults.length; ++i) {
            this.getProblem().log(this.setResults[i].toString());
        }
    }

    ResultInt createResult(Var var) {
        ResultInt resultInt = new ResultInt();
        resultInt.varName = var.getName();
        if (var.isBound()) {
            resultInt.min = resultInt.value = var.getValue();
            resultInt.max = resultInt.value;
            resultInt.bound = true;
        } else {
            resultInt.min = var.getMin();
            resultInt.max = var.getMax();
            resultInt.bound = false;
        }
        return resultInt;
    }

    class ResultSet {
        String varName;
        Set value;
        Set possible;
        Set required;
        boolean bound;

        ResultSet() {
        }

        public String toString() {
            return this.varName;
        }
    }

    class ResultReal {
        String varName;
        double value;
        double min;
        double max;
        boolean bound;

        ResultReal() {
        }

        public String toString() {
            if (this.bound) {
                return this.varName + "[" + this.value + "]";
            }
            return this.varName + "[" + this.min + ".." + this.max + "]";
        }
    }

    class ResultInt {
        String varName;
        int value;
        int min;
        int max;
        boolean bound;

        ResultInt() {
        }

        public String toString() {
            if (this.bound) {
                return this.varName + "[" + this.value + "]";
            }
            return this.varName + "[" + this.min + ".." + this.max + "]";
        }
    }
}

