/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;
import javax.constraints.Objective;
import javax.constraints.OptimizationStrategy;
import javax.constraints.Problem;
import javax.constraints.ProblemState;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.SolutionIterator;
import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.ValueSelectorType;
import javax.constraints.Var;
import javax.constraints.VarSelector;
import javax.constraints.VarSelectorType;
import javax.constraints.extra.ReversibleAction;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.search.BasicSolutionIterator;
import javax.constraints.impl.search.StrategyLogVariables;

public abstract class AbstractSolver
implements Solver {
    Problem problem;
    protected Vector<SearchStrategy> searchStrategies;
    Vector<Solution> solutions;
    int maxNumberOfSolutions;
    int timeLimit;
    long timeLimitStart;
    boolean timeLimitExceeded;
    int globalTimeLimit;
    long startTime = System.currentTimeMillis();
    int tolerance;
    long solverStartTime;
    boolean traceExecution;
    boolean traceSolutions;

    @Override
    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public AbstractSolver() {
        this(null);
    }

    public AbstractSolver(Problem problem) {
        this.problem = (AbstractProblem)problem;
        if (problem != null) {
            problem.setSolver(this);
        }
        this.searchStrategies = new Vector();
        this.solverStartTime = System.currentTimeMillis();
        this.maxNumberOfSolutions = -1;
        this.timeLimit = 0;
        this.globalTimeLimit = 0;
        this.setTimeLimitStart();
        this.setTimeLimitExceeded(false);
        this.tolerance = 0;
        this.clearSolutions();
        this.traceExecution(false);
        this.traceSolutions(false);
    }

    @Override
    public void saveProblem() {
    }

    @Override
    public void restoreProblem() {
    }

    public Vector<SearchStrategy> getSearchStrategies() {
        if (this.searchStrategies.isEmpty()) {
            SearchStrategy searchStrategy = this.getSearchStrategy();
            this.searchStrategies.add(searchStrategy);
        }
        return this.searchStrategies;
    }

    @Override
    public int getNumberOfSolutions() {
        return this.solutions.size();
    }

    @Override
    public int getMaxNumberOfSolutions() {
        return this.maxNumberOfSolutions;
    }

    @Override
    public void setMaxNumberOfSolutions(int n) {
        this.maxNumberOfSolutions = n;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    public boolean checkTimeLimit() {
        if (this.getTimeLimit() <= 0) {
            return false;
        }
        long l = System.currentTimeMillis();
        return l - this.getTimeLimitStart() > (long)this.getTimeLimit();
    }

    @Override
    public int getTimeLimitGlobal() {
        return this.globalTimeLimit;
    }

    @Override
    public void setTimeLimitGlobal(int n) {
        this.globalTimeLimit = n;
    }

    public boolean isTimeLimitExceeded() {
        return this.timeLimitExceeded;
    }

    public void setTimeLimitExceeded(boolean bl) {
        this.timeLimitExceeded = bl;
    }

    @Override
    public long getTimeLimitStart() {
        return this.timeLimitStart;
    }

    @Override
    public void setTimeLimitStart() {
        this.timeLimitStart = System.currentTimeMillis();
        this.timeLimitExceeded = false;
    }

    public void clearSolutions() {
        this.solutions = new Vector();
    }

    public void addSolution(Solution solution) {
        this.solutions.add(solution);
    }

    public Solution[] getSolutions() {
        if (this.solutions == null || this.solutions.size() == 0) {
            return null;
        }
        Solution[] solutionArray = new Solution[this.solutions.size()];
        for (int i = 0; i < this.solutions.size(); ++i) {
            solutionArray[i] = this.solutions.elementAt(i);
        }
        return solutionArray;
    }

    @Override
    public Solution getSolution(int n) {
        if (this.solutions == null || this.solutions.size() == 0 || n < 0 || n >= this.solutions.size()) {
            return null;
        }
        return this.solutions.get(n);
    }

    public Solution getSolution() {
        return this.getSolution(0);
    }

    @Override
    public void setSearchStrategy(SearchStrategy searchStrategy) {
        this.searchStrategies.clear();
        this.searchStrategies.add(searchStrategy);
    }

    @Override
    public SearchStrategy getSearchStrategy() {
        if (this.searchStrategies.isEmpty()) {
            this.setSearchStrategy(this.newSearchStrategy());
        }
        return this.searchStrategies.firstElement();
    }

    @Override
    public SearchStrategy getStrategyLogVariables() {
        return new StrategyLogVariables(this);
    }

    @Override
    public void addStrategyLogVariables() {
        this.addSearchStrategy(this.getStrategyLogVariables());
    }

    @Override
    public void setSearchStrategy(Var[] varArray, VarSelector varSelector, ValueSelector valueSelector) {
        SearchStrategy searchStrategy = this.getSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setVarSelector(varSelector);
        searchStrategy.setValueSelector(valueSelector);
        this.setSearchStrategy(searchStrategy);
    }

    @Override
    public void setSearchStrategy(Var[] varArray, VarSelector varSelector) {
        SearchStrategy searchStrategy = this.getSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setVarSelector(varSelector);
        this.setSearchStrategy(searchStrategy);
    }

    @Override
    public void setSearchStrategy(Var[] varArray, ValueSelector valueSelector) {
        SearchStrategy searchStrategy = this.getSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setValueSelector(valueSelector);
        this.setSearchStrategy(searchStrategy);
    }

    @Override
    public void setSearchStrategy(Var[] varArray) {
        SearchStrategy searchStrategy = this.getSearchStrategy();
        searchStrategy.setVars(varArray);
        this.setSearchStrategy(searchStrategy);
    }

    @Override
    public abstract SearchStrategy newSearchStrategy();

    @Override
    public void addSearchStrategy(SearchStrategy searchStrategy) {
        this.getSearchStrategy();
        this.searchStrategies.add(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray, VarSelector varSelector, ValueSelector valueSelector) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setVarSelector(varSelector);
        searchStrategy.setValueSelector(valueSelector);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray, VarSelectorType varSelectorType, ValueSelectorType valueSelectorType) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setVarSelectorType(varSelectorType);
        searchStrategy.setValueSelectorType(valueSelectorType);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray, VarSelector varSelector) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setVarSelector(varSelector);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray, VarSelectorType varSelectorType) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setVarSelectorType(varSelectorType);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray, ValueSelector valueSelector) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setValueSelector(valueSelector);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray, ValueSelectorType valueSelectorType) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        searchStrategy.setValueSelectorType(valueSelectorType);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public void addSearchStrategy(Var[] varArray) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setVars(varArray);
        this.addSearchStrategy(searchStrategy);
    }

    public void addSearchStrategy(ValueSelector valueSelector) {
        SearchStrategy searchStrategy = this.newSearchStrategy();
        searchStrategy.setValueSelector(valueSelector);
        this.addSearchStrategy(searchStrategy);
    }

    @Override
    public SolutionIterator solutionIterator() {
        return new BasicSolutionIterator(this);
    }

    @Override
    public abstract Solution findSolution(ProblemState var1);

    @Override
    public Solution findSolution() {
        return this.findSolution(ProblemState.DO_NOT_RESTORE);
    }

    @Override
    public Solution findOptimalSolution(Objective objective, Var var, OptimizationStrategy optimizationStrategy) {
        if (optimizationStrategy.equals((Object)OptimizationStrategy.DICHOTOMIZE)) {
            return this.findOptimalSolutionDichotomize(objective, var);
        }
        if (optimizationStrategy.equals((Object)OptimizationStrategy.BASIC)) {
            return this.findOptimalSolutionBasic(objective, var);
        }
        return this.findOptimalSolution(objective, var);
    }

    @Override
    public Solution findOptimalSolution(Objective objective, Var var) {
        return this.findOptimalSolution(objective, var, OptimizationStrategy.BASIC);
    }

    @Override
    public Solution findOptimalSolution(Var var) {
        return this.findOptimalSolution(Objective.MINIMIZE, var);
    }

    public Solution findOptimalSolutionBasic(Objective objective, Var var) {
        this.addObjective(var);
        SolutionIterator solutionIterator = this.solutionIterator();
        long l = System.currentTimeMillis();
        if (var.getName().isEmpty()) {
            var.setName("Objective");
        }
        if (this.getProblem().getVar(var.getName()) == null) {
            this.getProblem().add(var);
        }
        Var var2 = var;
        if (objective.equals((Object)Objective.MAXIMIZE)) {
            var2 = var.multiply(-1);
            var2.setName("-" + var.getName());
            this.getProblem().add(var2);
        }
        int n = Integer.MAX_VALUE;
        Solution solution = null;
        int n2 = 0;
        while (solutionIterator.hasNext()) {
            solution = solutionIterator.next();
            if (this.getMaxNumberOfSolutions() > 0 && ++n2 == this.getMaxNumberOfSolutions()) break;
            if (this.getTimeLimitGlobal() > 0 && System.currentTimeMillis() - l > (long)this.getTimeLimitGlobal()) {
                this.log("Global time limit " + this.getTimeLimitGlobal() + " mills has been exceeded.");
                break;
            }
            try {
                if (this.isTraceExecution()) {
                    solution.log();
                }
                int n3 = solution.getValue(var2.getName());
                if (this.isTraceSolutions()) {
                    this.log("Found a solution #" + solution.getSolutionNumber() + " with objective " + n3 + ". " + Calendar.getInstance().getTime());
                }
                if (n > n3) {
                    n = n3;
                }
                this.getProblem().post(var2, "<", n3);
            }
            catch (Exception exception) {
                this.log("Optimal solution is found. Best objective: " + n);
                break;
            }
        }
        if (solution != null) {
            this.log("Optimal solution is found. Objective: " + solution.getValue(var.getName()));
        }
        return solution;
    }

    public Solution findOptimalSolutionDichotomize(Var var) {
        return this.findOptimalSolutionDichotomize(Objective.MINIMIZE, var);
    }

    public Solution findOptimalSolutionDichotomize(Objective objective, Var var) {
        this.log("The method 'findOptimalSolutionDichotomize' should be implemented by a solver implementation.");
        this.log("The default method 'findOptimalSolutionBasic' has been used.");
        return this.findOptimalSolutionBasic(objective, var);
    }

    @Override
    public int getOptimizationTolerance() {
        return this.tolerance;
    }

    @Override
    public void setOptimizationTolerance(int n) {
        this.tolerance = n;
    }

    protected void addObjective(Var var) {
        int n;
        Var[] varArray;
        Var[] varArray2;
        for (int i = 0; i < this.searchStrategies.size(); ++i) {
            varArray2 = this.searchStrategies.elementAt(i);
            varArray = varArray2.getVars();
            for (n = 0; n < varArray.length; ++n) {
                if (varArray[i] != var) continue;
                return;
            }
        }
        SearchStrategy searchStrategy = this.getSearchStrategy();
        varArray2 = searchStrategy.getVars();
        varArray = new Var[varArray2.length + 1];
        for (n = 0; n < varArray2.length; ++n) {
            varArray[n] = varArray2[n];
        }
        varArray[varArray2.length] = var;
        searchStrategy.setVars(varArray);
    }

    @Override
    public Solution[] findAllSolutions() {
        Solution[] solutionArray;
        SolutionIterator solutionIterator = this.solutionIterator();
        long l = System.currentTimeMillis();
        ArrayList<Solution[]> arrayList = new ArrayList<Solution[]>();
        int n = 0;
        while (solutionIterator.hasNext()) {
            solutionArray = solutionIterator.next();
            arrayList.add(solutionArray);
            if (this.getTimeLimit() > 0 && System.currentTimeMillis() - l > (long)this.getTimeLimit()) {
                this.log("Reached TimeLimit=" + this.getTimeLimit() + " mills");
                break;
            }
            if (this.getMaxNumberOfSolutions() <= 0 || ++n != this.getMaxNumberOfSolutions()) continue;
            this.log("Found MaxNumberOfSolutions=" + this.getMaxNumberOfSolutions());
            break;
        }
        solutionArray = new Solution[arrayList.size()];
        for (int i = 0; i < solutionArray.length; ++i) {
            solutionArray[i] = (Solution)arrayList.get(i);
        }
        return solutionArray;
    }

    public abstract boolean applySolution(Solution var1);

    public boolean applySolution(int n) {
        Solution solution = this.getSolutions()[n];
        return this.applySolution(solution);
    }

    public boolean isTraceExecution() {
        return this.traceExecution;
    }

    public boolean isTraceSolutions() {
        return this.traceSolutions;
    }

    @Override
    public void traceFailures(boolean bl) {
        this.log("Solver method traceFailures() is not implemented");
    }

    public long getSolverStartTime() {
        return this.solverStartTime;
    }

    public void setSolverStartTime(long l) {
        this.solverStartTime = l;
    }

    @Override
    public void traceExecution(boolean bl) {
        this.traceExecution = bl;
    }

    @Override
    public void traceSolutions(boolean bl) {
        this.traceSolutions = bl;
    }

    @Override
    public void logStats() {
        this.log("*** Execution Profile ***");
        long l = System.currentTimeMillis() - this.solverStartTime;
        this.log("Execution time: " + l + " msec");
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.log("Occupied memory: " + l2);
    }

    public void log(String string) {
        this.problem.log(string);
    }

    public void addReversibleAction(ReversibleAction reversibleAction) {
        throw new RuntimeException("This RI does not implement Revesible Actions");
    }
}

