/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.DomainType;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarString;
import javax.constraints.impl.AbstractConstrainedVariable;

public class BasicVarString
extends AbstractConstrainedVariable
implements VarString {
    String[] allStrings = null;
    Var myvar;

    public BasicVarString(Problem problem, String[] stringArray) {
        this(problem, "", stringArray);
    }

    public BasicVarString(Problem problem, String string, String[] stringArray) {
        super(problem, string);
        this.allStrings = stringArray;
        this.myvar = problem.variable(string, 0, stringArray.length - 1, DomainType.DOMAIN_SMALL);
        this.myvar.setObject(this);
    }

    @Override
    public String[] getAllStrings() {
        return this.allStrings;
    }

    @Override
    public Var getInt() {
        return this.myvar;
    }

    @Override
    public String getValue() {
        return this.allStrings[this.myvar.getValue()];
    }

    @Override
    public String getInitialDomain() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i <= this.allStrings.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.allStrings[i]);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isBound() {
        return this.myvar.isBound();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getName() + "[");
        int n = 0;
        for (int i = 0; i < this.allStrings.length; ++i) {
            if (!this.myvar.contains(i)) continue;
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.allStrings[i]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean hasSameDomain(VarString varString) {
        if (this.allStrings.length == varString.getAllStrings().length) {
            for (int i = 0; i < this.allStrings.length; ++i) {
                if (this.allStrings[i].equals(varString.getAllStrings()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getIndex(String string) {
        for (int i = 0; i < this.allStrings.length; ++i) {
            if (!this.allStrings[i].equals(string)) continue;
            return i;
        }
        return -1;
    }
}

