/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.constraints.Constraint;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarSet;
import javax.constraints.impl.AbstractConstrainedVariable;
import javax.constraints.impl.constraint.ConstraintTrue;

public class BasicVarSet
extends AbstractConstrainedVariable
implements VarSet {
    Set valueSet;
    Var[] requiredVars;
    ValueVarMap valueVarMap;
    Var cardinality;

    public BasicVarSet(Problem problem, int[] nArray, String string) throws Exception {
        super(problem, string);
        this.valueSet = new HashSet();
        for (int i = 0; i < nArray.length; ++i) {
            this.valueSet.add(new Integer(nArray[i]));
        }
        this.init();
    }

    public BasicVarSet(Problem problem, int n, int n2, String string) throws Exception {
        this(problem, new int[n2 - n + 1], string);
    }

    public BasicVarSet(Problem problem, Set set, String string) throws Exception {
        super(problem, string);
        this.valueSet = set;
        this.init();
    }

    public void init() throws Exception {
        this.requiredVars = new Var[this.valueSet.size()];
        this.valueVarMap = new ValueVarMap();
        Iterator iterator = this.valueSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            this.requiredVars[n] = this.problem.variable(this.name + "(" + n3 + ")", 0, 1);
            this.valueVarMap.put(n2, this.requiredVars[n]);
            ++n;
        }
        this.cardinality = this.problem.variable("", 0, this.requiredVars.length);
        this.problem.postCardinality(this.requiredVars, 1, "=", this.cardinality);
    }

    public Var[] getRequiredVars() {
        return this.requiredVars;
    }

    @Override
    public void setEmpty(boolean bl) {
        if (bl) {
            this.getProblem().post(this.cardinality, "=", 0);
        } else {
            this.getProblem().post(this.cardinality, ">=", 1);
        }
    }

    @Override
    public boolean isBound() {
        for (int i = 0; i < this.requiredVars.length; ++i) {
            if (this.requiredVars[i].isBound()) continue;
            return false;
        }
        return true;
    }

    public Set getValue() throws Exception {
        if (!this.isBound()) {
            throw new Exception("Attempt to get value of the unbound set variable " + this.getName());
        }
        return this.getRequiredSet();
    }

    public void setValue(Set set) throws Exception {
        for (Integer n : set) {
            int n2 = n;
            this.require(n2);
        }
        this.valueVarMap.removeNotRequiredValues();
    }

    public Set getRequiredSet() {
        return this.valueVarMap.getRequiredSet();
    }

    public Set getPossibleSet() {
        return this.valueVarMap.getPossibleSet();
    }

    @Override
    public boolean isPossible(int n) {
        Var var = this.valueVarMap.get(n);
        if (var == null) {
            return false;
        }
        return var.getMax() != 0;
    }

    @Override
    public boolean isRequired(int n) {
        Var var = this.valueVarMap.get(n);
        if (var == null) {
            return false;
        }
        return var.getMax() == 1;
    }

    public Var getRequiredVar(int n) throws Exception {
        Var var = this.valueVarMap.get(n);
        if (var == null) {
            throw new Exception("Value " + n + " is not in domain of " + this.getName());
        }
        return var;
    }

    @Override
    public void remove(int n) throws Exception {
        Var var = this.getRequiredVar(n);
        this.getProblem().post(var, "=", 0);
    }

    @Override
    public void require(int n) throws Exception {
        Var var = this.getRequiredVar(n);
        this.getProblem().post(var, "=", 1);
    }

    public boolean contains(Set set) {
        if (!this.valueSet.containsAll(set)) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (this.isPossible(n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Var getCardinality() {
        return this.cardinality;
    }

    public Constraint doNotIntersectWith(VarSet varSet) throws Exception {
        VarSet varSet2 = this.intersection(varSet);
        if (varSet2 == null) {
            return new ConstraintTrue(this.getProblem());
        }
        return this.getProblem().post(varSet2.getCardinality(), "=", 0);
    }

    public Set getValueSet() {
        return this.valueSet;
    }

    @Override
    public VarSet intersection(VarSet varSet) throws Exception {
        Object object;
        Set set = this.getValueSet();
        Set set2 = ((BasicVarSet)varSet).getValueSet();
        int[] nArray = new int[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (Integer)iterator.next();
            if (!set2.contains(object)) continue;
            nArray[n++] = (Integer)object;
        }
        if (n == 0) {
            return null;
        }
        object = new int[n];
        System.arraycopy(nArray, 0, object, 0, n);
        Problem problem = this.getProblem();
        String string = this.getName() + "&" + varSet.getName();
        BasicVarSet basicVarSet = new BasicVarSet(problem, (int[])object, string);
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i];
            Var var = this.getRequiredVar((int)object2);
            Var var2 = ((BasicVarSet)varSet).getRequiredVar((int)object2);
            Var var3 = basicVarSet.getRequiredVar((int)object2);
            Constraint constraint = problem.linear(var, "=", 1);
            Constraint constraint2 = problem.linear(var2, "=", 1);
            Constraint constraint3 = problem.linear(var3, "=", 1);
            problem.postIfThen(constraint.and(constraint2), constraint3);
            Constraint constraint4 = problem.linear(var, "=", 0);
            Constraint constraint5 = problem.linear(var2, "=", 0);
            Constraint constraint6 = problem.linear(var3, "=", 0);
            problem.postIfThen(constraint4.or(constraint5), constraint6);
        }
        return basicVarSet;
    }

    @Override
    public VarSet union(VarSet varSet) {
        this.getProblem().log("==== union is not implemented");
        return null;
    }

    public String toString() {
        return "VarSet " + this.getName() + this.cardinality + ":" + this.valueVarMap.toString();
    }

    class ValueVarMap {
        HashMap map = new HashMap();

        ValueVarMap() {
        }

        void put(int n, Var var) {
            this.map.put(new Integer(n), var);
        }

        void put(Integer n, Var var) {
            this.map.put(n, var);
        }

        Var get(int n) {
            return (Var)this.map.get(new Integer(n));
        }

        Var get(Integer n) {
            return (Var)this.map.get(n);
        }

        public Set getRequiredSet() {
            HashSet hashSet = new HashSet();
            Set set = this.map.entrySet();
            for (Map.Entry entry : set) {
                Var var = (Var)entry.getValue();
                if (var.getMin() != 1) continue;
                hashSet.add(entry.getKey());
            }
            return hashSet;
        }

        public void removeNotRequiredValues() throws Exception {
            Set set = this.map.entrySet();
            for (Map.Entry entry : set) {
                Var var = (Var)entry.getValue();
                if (var.getMin() == 1) continue;
                BasicVarSet.this.getProblem().post(var, "=", 0);
            }
        }

        public Set getPossibleSet() {
            HashSet hashSet = new HashSet();
            Set set = this.map.entrySet();
            for (Map.Entry entry : set) {
                Var var = (Var)entry.getValue();
                if (var.getMax() != 1) continue;
                hashSet.add(entry.getKey());
            }
            return hashSet;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Set set = this.map.entrySet();
            for (Map.Entry entry : set) {
                Var var = (Var)entry.getValue();
                if (var.getMin() == 1) {
                    stringBuffer.append(" [" + entry.getKey() + "]");
                    continue;
                }
                stringBuffer.append(" " + entry.getKey());
            }
            return stringBuffer.toString();
        }
    }
}

