/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarMatrix;

public class BasicVarMatrix
implements VarMatrix {
    Problem problem;
    String name;
    int rows;
    int columns;
    int min;
    int max;
    Var[][] matrix;
    Var[] rowVars;
    Var[] columnVars;

    public BasicVarMatrix(Problem problem, String string, int n, int n2, int n3, int n4) {
        this.problem = problem;
        this.name = string;
        this.min = n;
        this.max = n2;
        this.rows = n3;
        this.columns = n4;
        this.matrix = new Var[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                String string2 = string + i + j;
                this.matrix[i][j] = problem.variable(string2, n, n2);
            }
        }
    }

    @Override
    public int numberOfRows() {
        return this.rows;
    }

    @Override
    public int numberOfColumns() {
        return this.columns;
    }

    @Override
    public Var[] row(int n) {
        Var[] varArray = new Var[this.columns];
        for (int i = 0; i < this.columns; ++i) {
            varArray[i] = this.matrix[n][i];
        }
        return varArray;
    }

    @Override
    public Var[] column(int n) {
        Var[] varArray = new Var[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            varArray[i] = this.matrix[i][n];
        }
        return varArray;
    }

    @Override
    public Var[] flat() {
        Var[] varArray = new Var[this.rows * this.columns];
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                varArray[n++] = this.matrix[i][j];
            }
        }
        return varArray;
    }

    @Override
    public Var[] diagonal1() {
        if (this.rows != this.columns) {
            return null;
        }
        Var[] varArray = new Var[this.rows];
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            varArray[n++] = this.matrix[i][i];
        }
        return varArray;
    }

    @Override
    public Var[] diagonal2() {
        if (this.rows != this.columns) {
            return null;
        }
        Var[] varArray = new Var[this.rows];
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            varArray[n++] = this.matrix[i][this.rows - i - 1];
        }
        return varArray;
    }

    @Override
    public Var get(int n, int n2) {
        return this.matrix[n][n2];
    }

    @Override
    public void post(int[][] nArray) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.problem.post(this.matrix[i][j], "=", nArray[i][j]);
            }
        }
    }

    @Override
    public void post(int n, int n2, int n3) {
        this.problem.post(this.matrix[n][n2], "=", n3);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                Var var = this.matrix[i][j];
                if (var.isBound()) {
                    int n = var.getValue();
                    String string = " ";
                    if (n < 10) {
                        string = "  ";
                    }
                    stringBuffer.append(string + n);
                    continue;
                }
                stringBuffer.append(" " + var.toString());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

