/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.DomainType;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.extra.PropagationEvent;
import javax.constraints.extra.Propagator;
import javax.constraints.impl.AbstractConstrainedVariable;

public abstract class AbstractVar
extends AbstractConstrainedVariable
implements Var {
    DomainType domainType;

    public AbstractVar(Problem problem) {
        super(problem);
    }

    public AbstractVar(Problem problem, String string) {
        super(problem, string);
    }

    @Override
    public DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public void setDomainType(DomainType domainType) {
        if (this.domainType == domainType) {
            return;
        }
    }

    @Override
    public int getValue() {
        if (!this.isBound()) {
            throw new RuntimeException("Attempt to getValue of non instantiated Var variable " + this.getName());
        }
        return this.getMin();
    }

    @Override
    public String getInitialDomain() {
        return "[" + this.getMin() + ";" + this.getMax() + "]";
    }

    @Override
    public int getDomainSize() {
        return this.getMax() - this.getMin() + 1;
    }

    @Override
    public Var minus(int n) {
        return this.plus(-n);
    }

    @Override
    public Var minus(Var var) {
        return this.plus(var.multiply(-1));
    }

    @Override
    public Var divide(int n) {
        if (n == 0) {
            throw new RuntimeException("Attemt to use Var.div(0)");
        }
        if (n == 1) {
            return this;
        }
        if (n == -1) {
            return this.negative();
        }
        int n2 = this.getMin() * n;
        int n3 = this.getMax() * n;
        if (n < 0) {
            n3 = n2 = n3;
        }
        Var var = this.getProblem().variable("", n2, n3);
        this.getProblem().post((Var)this, "=", var.multiply(n)).post();
        return var;
    }

    @Override
    public Var divide(Var var) throws Exception {
        if (var.isBound() && var.getValue() == 0) {
            throw new Exception("Divisor " + var + "is instantiated by 0");
        }
        Var var2 = this.getProblem().variable("", Integer.MIN_VALUE, 0x7FFFFFFE);
        this.getProblem().post((Var)this, "=", var2.multiply(var)).post();
        return var2;
    }

    @Override
    public Var mod(int n) {
        Var var = this.divide(n);
        return this.minus(var.multiply(n));
    }

    public String toString() {
        if (this.getMin() == this.getMax()) {
            return this.getName() + "[" + this.getMin() + "]";
        }
        return this.getName() + "[" + this.getMin() + ".." + this.getMax() + "]";
    }

    @Override
    public Var negative() {
        return this.multiply(-1);
    }

    @Override
    public Var sqr() {
        return this.multiply(this);
    }

    @Override
    public Var power(int n) {
        Var var = this;
        for (int i = 1; i < n; ++i) {
            var = var.multiply(this);
        }
        return var;
    }

    public abstract void addPropagator(Propagator var1, PropagationEvent var2);

    @Override
    public int compareTo(Var var) {
        return 1;
    }
}

