/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.constraints.Constraint;
import javax.constraints.DomainType;
import javax.constraints.Oper;
import javax.constraints.Problem;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarBool;
import javax.constraints.VarList;
import javax.constraints.VarMatrix;
import javax.constraints.VarReal;
import javax.constraints.VarSet;
import javax.constraints.VarString;
import javax.constraints.extra.Reversible;
import javax.constraints.impl.AbstractVar;
import javax.constraints.impl.BasicVarMatrix;
import javax.constraints.impl.BasicVarSet;
import javax.constraints.impl.BasicVarString;
import javax.constraints.impl.constraint.ConstraintFalse;
import javax.constraints.impl.constraint.ConstraintGlobalCardinality;
import javax.constraints.impl.constraint.ConstraintMax;
import javax.constraints.impl.constraint.ConstraintMin;
import javax.constraints.impl.constraint.ConstraintTrue;

public abstract class AbstractProblem
implements Problem {
    private HashMap<String, Oper> operators;
    String name;
    Object object;
    ArrayList<Var> vars;
    ArrayList<VarBool> varBools;
    HashMap<String, Var[]> varArrays;
    ArrayList<Constraint> constraints;
    Solver solver;
    DomainType domainType;
    ArrayList<Var> savedVars;
    ArrayList<VarBool> savedVarBools;
    HashMap<String, Var[]> savedVarArrays;
    ArrayList<Constraint> savedConstraints;
    HashMap<String, VarMatrix> varMatrixs;
    ArrayList<VarString> varStrings;
    protected static double REAL_PRECISION = 1.0E-6;

    @Override
    public String getAPIVersion() {
        return "JSR-331 Standard v.1.1.1 Beta (release 8/18/2012)";
    }

    @Override
    public abstract String getImplVersion();

    public AbstractProblem(String string) {
        this.name = string;
        this.log(this.getAPIVersion());
        this.log(this.getImplVersion());
        this.vars = new ArrayList();
        this.varBools = new ArrayList();
        this.constraints = new ArrayList();
        this.varArrays = new HashMap();
        this.varMatrixs = new HashMap();
        this.varStrings = new ArrayList();
        this.solver = null;
        this.operators = new HashMap();
        this.operators.put("=", Oper.EQ);
        this.operators.put("==", Oper.EQ);
        this.operators.put("!=", Oper.NEQ);
        this.operators.put("<", Oper.LT);
        this.operators.put("<=", Oper.LE);
        this.operators.put(">", Oper.GT);
        this.operators.put(">=", Oper.GE);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String string) {
        this.name = string;
    }

    public final DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public final void setDomainType(DomainType domainType) {
        this.domainType = domainType;
    }

    @Override
    public Var add(Var var) {
        this.add(var.getName(), var);
        return var;
    }

    @Override
    public VarBool add(VarBool varBool) {
        this.varBools.add(varBool);
        return varBool;
    }

    public void remove(String string) {
        Var var = this.getVar(string);
        if (var != null) {
            this.vars.remove(var);
        }
    }

    @Override
    public Var add(String string, Var var) {
        Var var2 = this.getVar(string);
        if (var2 != null) {
            this.vars.remove(var2);
        }
        this.vars.add(var);
        var.setName(string);
        return var;
    }

    @Override
    public VarReal add(VarReal varReal) {
        return null;
    }

    public VarReal add(String string, VarReal varReal) {
        return null;
    }

    public Var var(String string, String string2) {
        this.error("The implementation does not support symbolic Var expressions like:\n" + string2);
        return null;
    }

    @Override
    public Constraint post(String string, String string2) {
        this.error("The implementation does not support symbolic constraints like:\n" + string2);
        return null;
    }

    @Override
    public Var variable(String string, int n, int n2) {
        Var var = this.createVariable(string, n, n2);
        this.add(var);
        return var;
    }

    @Override
    public abstract Var createVariable(String var1, int var2, int var3);

    @Override
    public Var variable(String string, int n, int n2, DomainType domainType) {
        DomainType domainType2 = this.getDomainType();
        this.setDomainType(domainType);
        Var var = this.variable(string, n, n2);
        this.setDomainType(domainType2);
        return var;
    }

    @Override
    public Var variable(int n, int n2) {
        Var var = this.variable("noname", n, n2);
        this.remove("noname");
        var.setName("");
        return var;
    }

    @Override
    public VarReal variableReal(String string, double d, double d2) {
        return null;
    }

    @Override
    public VarReal variableReal(String string) {
        return null;
    }

    @Override
    public VarSet variableSet(String string, int n, int n2) throws Exception {
        BasicVarSet basicVarSet = new BasicVarSet(this, n, n2, string);
        basicVarSet.setEmpty(false);
        return basicVarSet;
    }

    @Override
    public VarSet variableSet(String string, int[] nArray) throws Exception {
        BasicVarSet basicVarSet = new BasicVarSet((Problem)this, nArray, string);
        basicVarSet.setEmpty(false);
        return basicVarSet;
    }

    @Override
    public VarSet variableSet(String string, Set set) throws Exception {
        BasicVarSet basicVarSet = new BasicVarSet((Problem)this, set, string);
        basicVarSet.setEmpty(false);
        return basicVarSet;
    }

    @Override
    public Var[] variableArray(String string, int n, int n2, int n3) {
        Var[] varArray = new Var[n3];
        for (int i = 0; i < n3; ++i) {
            String string2 = string == null || string.isEmpty() ? "" : string + "-" + i;
            varArray[i] = this.variable(string2, n, n2);
        }
        return varArray;
    }

    public Var[] addVarArray(String string, Var[] varArray) {
        this.varArrays.put(string, varArray);
        return varArray;
    }

    public Var[] addVarArray(String string, String[] stringArray) {
        int n = stringArray.length;
        Var[] varArray = new Var[n];
        for (int i = 0; i < n; ++i) {
            varArray[i] = this.getVar(stringArray[i]);
        }
        this.varArrays.put(string, varArray);
        return varArray;
    }

    @Override
    public Var variable(String string, int[] nArray) {
        int n;
        int n2 = -2147483647;
        int n3 = 0x7FFFFFFE;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray[i];
            if (n3 > n) {
                n3 = n;
            }
            if (n2 >= n) continue;
            n2 = n;
        }
        Var var = this.variable(string, n3, n2);
        if (nArray.length <= Math.abs(n2 - n3)) {
            n = 1;
            AbstractVar abstractVar = (AbstractVar)var;
            for (int i = n3 + 1; i < n2; ++i) {
                if (nArray[n] != i) {
                    try {
                        this.post((Var)abstractVar, "!=", i);
                    }
                    catch (Exception exception) {
                        this.log("value " + i + "can not be removed from " + var);
                    }
                    continue;
                }
                ++n;
            }
        }
        return var;
    }

    @Override
    public Var variable(int[] nArray) {
        return this.variable("", nArray);
    }

    @Override
    public abstract VarBool variableBool(String var1);

    @Override
    public Var[] getVars() {
        if (this.vars.isEmpty()) {
            return null;
        }
        Var[] varArray = new Var[this.vars.size()];
        Iterator<Var> iterator = this.vars.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            varArray[n++] = iterator.next();
        }
        return varArray;
    }

    @Override
    public VarBool[] getVarBools() {
        if (this.varBools.isEmpty()) {
            return null;
        }
        VarBool[] varBoolArray = new VarBool[this.varBools.size()];
        Iterator<VarBool> iterator = this.varBools.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            varBoolArray[n++] = iterator.next();
        }
        return varBoolArray;
    }

    @Override
    public VarBool variableBool() {
        VarBool varBool = this.variableBool("noname");
        this.remove("noname");
        varBool.setName("");
        return varBool;
    }

    @Override
    public VarReal[] getVarReals() {
        return null;
    }

    @Override
    public VarReal[] getVarSets() {
        return null;
    }

    @Override
    public Var getVar(String string) {
        if (string == null) {
            return null;
        }
        for (Var var : this.vars) {
            if (!string.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    @Override
    public VarReal getVarReal(String string) {
        return null;
    }

    @Override
    public Var[] getVarArray(String string) {
        return this.varArrays.get(string);
    }

    public Var[] varSquare(String string, int n, int n2, int n3) {
        Var[] varArray = new Var[n3 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                String string2 = string == null ? "" : string + "[" + i + "," + j + "]";
                varArray[i * n3 + j] = this.variable(string2, n, n2);
            }
        }
        if (string != null) {
            this.varArrays.put(string, varArray);
        }
        return varArray;
    }

    @Override
    public Constraint add(Constraint constraint) {
        return this.add(constraint.getName(), constraint);
    }

    public Constraint add(String string, Constraint constraint) {
        constraint.setName(string);
        this.constraints.add(constraint);
        return constraint;
    }

    @Override
    public Constraint[] getConstraints() {
        Constraint[] constraintArray = new Constraint[this.constraints.size()];
        for (int i = 0; i < constraintArray.length; ++i) {
            constraintArray[i] = this.constraints.get(i);
        }
        return constraintArray;
    }

    @Override
    public final Constraint getConstraint(String string) {
        if (this.constraints.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (!string.endsWith(this.constraints.get(i).getName())) continue;
            return this.constraints.get(i);
        }
        return null;
    }

    protected Oper stringToOper(String string) {
        Oper oper = this.operators.get(string);
        if (oper == null) {
            throw new RuntimeException("Invalid Operator " + string);
        }
        return oper;
    }

    @Override
    public Var element(int[] nArray, Var var) {
        Var var2 = this.variable("_element_", nArray);
        this.postElement(nArray, var, "=", var2);
        return var2;
    }

    @Override
    public Var element(Var[] varArray, Var var) {
        int n = varArray[0].getMin();
        int n2 = varArray[0].getMax();
        for (int i = 1; i < varArray.length; ++i) {
            Var var2 = varArray[i];
            if (n > var2.getMin()) {
                n = var2.getMin();
            }
            if (n2 >= var2.getMax()) continue;
            n2 = var2.getMax();
        }
        Var var3 = this.variable("_element_", n, n2);
        this.postElement(varArray, var, "=", var3);
        return var3;
    }

    @Override
    public Var element(VarList varList, Var var) {
        Var[] varArray = varList.toArray();
        return this.element(varArray, var);
    }

    @Override
    public VarSet element(Set<Integer>[] setArray, Var var) throws Exception {
        this.error("Method element(Set[] sets, Var indexVar) is not implemented");
        return null;
    }

    @Override
    public Constraint postAnd(Constraint constraint, Constraint constraint2) {
        Constraint constraint3 = constraint.and(constraint2);
        constraint3.post();
        return constraint3;
    }

    @Override
    public Constraint postOr(Constraint constraint, Constraint constraint2) {
        Constraint constraint3 = constraint.or(constraint2);
        constraint3.post();
        return constraint3;
    }

    @Override
    public Constraint post(int[] nArray, VarList varList, String string, int n) {
        Var[] varArray = varList.toArray();
        return this.postLinear(nArray, varArray, string, n);
    }

    public Constraint post(int[] nArray, VarList varList, String string, Var var) {
        Var[] varArray = varList.toArray();
        return this.postLinear(nArray, varArray, string, var);
    }

    @Override
    public Constraint postLinear(int[] nArray, Var[] varArray, String string, int n) {
        return this.post(nArray, varArray, string, n);
    }

    @Override
    public Constraint postLinear(int[] nArray, Var[] varArray, String string, Var var) {
        return this.post(nArray, varArray, string, var);
    }

    public Constraint postLinear(int[] nArray, VarList varList, String string, Var var) {
        Var[] varArray = varList.toArray();
        return this.postLinear(nArray, varArray, string, var);
    }

    @Override
    public Constraint postLinear(int[] nArray, VarList varList, String string, int n) {
        Var[] varArray = varList.toArray();
        return this.postLinear(nArray, varArray, string, n);
    }

    @Override
    public Constraint postLinear(Var[] varArray, String string, int n) {
        return this.post(varArray, string, n);
    }

    @Override
    public Constraint postLinear(Var[] varArray, String string, Var var) {
        return this.post(varArray, string, var);
    }

    @Override
    public Constraint postLinear(Var var, String string, int n) {
        return this.post(var, string, n);
    }

    @Override
    public Constraint postLinear(Var var, String string, Var var2) {
        return this.post(var, string, var2);
    }

    @Override
    public Constraint post(Var var, Var var2, String string, int n) {
        return this.post(new Var[]{var, var2}, string, n);
    }

    @Override
    public Constraint post(Var var, Var var2, String string, Var var3) {
        return this.post(new Var[]{var, var2}, string, var3);
    }

    @Override
    public Constraint postAllDiff(Var[] varArray) {
        return this.postAllDifferent(varArray);
    }

    @Override
    public Constraint postAllDifferent(ArrayList<Var> arrayList) {
        Var[] varArray = new Var[arrayList.size()];
        int n = 0;
        for (Var var : arrayList) {
            varArray[n++] = var;
        }
        return this.postAllDifferent(varArray);
    }

    @Override
    public Constraint postAllDiff(ArrayList<Var> arrayList) {
        return this.postAllDifferent(arrayList);
    }

    @Override
    public Constraint postAllDifferent(VarList varList) {
        return this.postAllDifferent(varList);
    }

    @Override
    public Constraint postAllDifferent(List list) {
        Var[] varArray = new Var[list.size()];
        int n = 0;
        for (Object e : list) {
            varArray[n++] = (Var)e;
        }
        return this.postAllDifferent(varArray);
    }

    @Override
    public Constraint allDiff(VarList varList) {
        return this.postAllDifferent(varList);
    }

    @Override
    public Constraint postAllDifferent(Var[] varArray) {
        Constraint constraint = this.allDiff(varArray);
        constraint.post();
        return constraint;
    }

    @Override
    public abstract void post(Constraint var1);

    public Constraint and(Constraint[] constraintArray) {
        Constraint constraint = constraintArray[0];
        for (int i = 1; i < constraintArray.length; ++i) {
            constraint = constraint.and(constraintArray[i]);
        }
        return constraint;
    }

    @Override
    public Constraint postIfThen(Constraint constraint, Constraint constraint2) {
        Constraint constraint3 = constraint.implies(constraint2);
        constraint3.post();
        return constraint3;
    }

    @Override
    public Solver getSolver() {
        if (!this.isSolverCreated()) {
            this.solver = this.createSolver();
        }
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    public boolean isSolverCreated() {
        return this.solver != null;
    }

    protected abstract Solver createSolver();

    public void log(String string, Var[] varArray) {
        if (string != null) {
            this.log(string);
        }
        this.log(varArray);
    }

    @Override
    public void log(Var[] varArray) {
        for (int i = 0; i < varArray.length; ++i) {
            Var var = varArray[i];
            this.log("Var[" + i + "]: " + var.toString());
        }
    }

    @Override
    public void log(VarList varList) {
        for (int i = 0; i < varList.size(); ++i) {
            Var var = (Var)varList.get(i);
            this.log("VarList(" + i + "): " + var.toString());
        }
    }

    public void log(String string, VarReal[] varRealArray) {
    }

    public void log(VarReal[] varRealArray) {
    }

    public void log(String string, VarSet[] varSetArray) {
    }

    public void log(VarSet[] varSetArray) {
    }

    public void log(Constraint[] constraintArray) {
        for (int i = 0; i < constraintArray.length; ++i) {
            Constraint constraint = constraintArray[i];
            this.log("Constraint[" + i + "]: " + constraint.getName());
        }
    }

    @Override
    public abstract void log(String var1);

    public abstract void debug(String var1);

    public abstract void error(String var1);

    @Override
    public Constraint postCardinality(Var[] varArray, Var var, String string, Var var2) {
        Var[] varArray2 = new VarBool[varArray.length];
        for (int i = 0; i < varArray2.length; ++i) {
            varArray2[i] = this.linear(varArray[i], "=", var).asBool();
        }
        return this.post(varArray2, string, var2);
    }

    @Override
    public Constraint postCardinality(Var[] varArray, Var var, String string, int n) {
        Var[] varArray2 = new VarBool[varArray.length];
        for (int i = 0; i < varArray2.length; ++i) {
            varArray2[i] = this.linear(varArray[i], "=", var).asBool();
        }
        return this.post(varArray2, string, n);
    }

    @Override
    public Constraint postCardinality(VarList varList, int n, String string, int n2) {
        Var[] varArray = varList.toArray();
        return this.postCardinality(varArray, n, string, n2);
    }

    @Override
    public Constraint postCardinality(VarList varList, int n, String string, Var var) {
        Var[] varArray = varList.toArray();
        return this.postCardinality(varArray, n, string, var);
    }

    @Override
    public Constraint postCardinality(VarList varList, Var var, String string, int n) {
        Var[] varArray = varList.toArray();
        return this.postCardinality(varArray, var, string, n);
    }

    @Override
    public Constraint postCardinality(VarList varList, Var var, String string, Var var2) {
        Var[] varArray = varList.toArray();
        return this.postCardinality(varArray, var, string, var2);
    }

    @Override
    public Constraint postGlobalCardinality(Var[] varArray, int[] nArray, Var[] varArray2) {
        ConstraintGlobalCardinality constraintGlobalCardinality = new ConstraintGlobalCardinality(varArray, nArray, varArray2);
        constraintGlobalCardinality.post();
        return constraintGlobalCardinality;
    }

    @Override
    public Constraint postGlobalCardinality(VarList varList, int[] nArray, Var[] varArray) {
        Var[] varArray2 = varList.toArray();
        return this.postGlobalCardinality(varArray2, nArray, varArray);
    }

    @Override
    public Constraint postGlobalCardinality(Var[] varArray, int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray2[0];
        int n2 = nArray3[0];
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] > nArray3[i]) {
                throw new RuntimeException("GlobalCardinality error: cardMin[" + i + "] <= cardMax[" + i + "]");
            }
            if (nArray2[i] < n) {
                n = nArray2[i];
            }
            if (nArray3[i] <= n2) continue;
            n2 = nArray3[i];
        }
        Var[] varArray2 = this.variableArray(this.name, n, n2, nArray.length);
        Constraint constraint = this.postGlobalCardinality(varArray, nArray, varArray2);
        for (int i = 0; i < varArray2.length; ++i) {
            this.post(varArray2[i], ">=", nArray2[i]);
            this.post(varArray2[i], "<=", nArray3[i]);
        }
        return constraint;
    }

    @Override
    public Constraint postGlobalCardinality(VarList varList, int[] nArray, int[] nArray2, int[] nArray3) {
        Var[] varArray = varList.toArray();
        return this.postGlobalCardinality(varArray, nArray, nArray2, nArray3);
    }

    @Override
    public Constraint postMax(Var[] varArray, String string, Var var) {
        ConstraintMax constraintMax = new ConstraintMax(varArray, string, var);
        constraintMax.post();
        return constraintMax;
    }

    @Override
    public Constraint postMax(Var[] varArray, String string, int n) {
        ConstraintMax constraintMax = new ConstraintMax(varArray, string, n);
        constraintMax.post();
        return constraintMax;
    }

    @Override
    public Constraint postMin(Var[] varArray, String string, Var var) {
        ConstraintMin constraintMin = new ConstraintMin(varArray, string, var);
        constraintMin.post();
        return constraintMin;
    }

    @Override
    public Constraint postMin(Var[] varArray, String string, int n) {
        ConstraintMin constraintMin = new ConstraintMin(varArray, string, n);
        constraintMin.post();
        return constraintMin;
    }

    @Override
    public Var min(Var[] varArray) {
        int n;
        Var[] varArray2;
        int n2 = varArray[0].getMin();
        int n3 = varArray[0].getMax();
        for (int i = 1; i < varArray.length; ++i) {
            varArray2 = varArray[i];
            n = varArray2.getMin();
            int n4 = varArray2.getMax();
            if (n2 > n) {
                n2 = n;
            }
            if (n3 <= n4) continue;
            n3 = n4;
        }
        Var var = this.createVariable("_min_", n2, n3);
        varArray2 = new Var[varArray.length];
        for (n = 0; n < varArray.length; ++n) {
            Var var2 = varArray[n];
            this.post(var, "<=", var2);
            varArray2[n] = this.linear(var, "=", varArray[n]).asBool();
        }
        this.post(varArray2, ">=", 1);
        return var;
    }

    @Override
    public Var max(Var[] varArray) {
        int n;
        Var[] varArray2;
        int n2 = varArray[0].getMin();
        int n3 = varArray[0].getMax();
        for (int i = 1; i < varArray.length; ++i) {
            varArray2 = varArray[i];
            n = varArray2.getMin();
            int n4 = varArray2.getMax();
            if (n2 < n) {
                n2 = n;
            }
            if (n3 >= n4) continue;
            n3 = n4;
        }
        Var var = this.createVariable("_max_", n2, n3);
        varArray2 = new Var[varArray.length];
        for (n = 0; n < varArray.length; ++n) {
            Var var2 = varArray[n];
            this.post(var, ">=", var2);
            varArray2[n] = this.linear(var, "=", varArray[n]).asBool();
        }
        this.post(varArray2, ">=", 1);
        return var;
    }

    @Override
    public Var max(VarList varList) {
        Var[] varArray = varList.toArray();
        return this.max(varArray);
    }

    @Override
    public Var min(VarList varList) {
        Var[] varArray = varList.toArray();
        return this.min(varArray);
    }

    @Override
    public Var min(Var var, Var var2) {
        try {
            int n = var.getMin() < var2.getMin() ? var.getMin() : var2.getMin();
            int n2 = var.getMax() < var2.getMax() ? var.getMax() : var2.getMax();
            Var var3 = this.variable("_min_", n, n2);
            this.remove("_min_");
            this.post(var3, "<=", var);
            this.post(var3, "<=", var2);
            VarBool varBool = this.linear(var3, "=", var).asBool();
            VarBool varBool2 = this.linear(var3, "=", var2).asBool();
            this.post(varBool.plus(varBool2), "!=", 0).post();
            return var3;
        }
        catch (Exception exception) {
            this.log("Failure to create min(var1,var2)");
            return null;
        }
    }

    @Override
    public Var max(Var var, Var var2) {
        try {
            int n = var.getMin() > var2.getMin() ? var.getMin() : var2.getMin();
            int n2 = var.getMax() > var2.getMax() ? var.getMax() : var2.getMax();
            Var var3 = this.variable("_max_", n, n2);
            this.remove("_max_");
            this.post(var3, ">=", var);
            this.post(var3, ">=", var2);
            VarBool varBool = this.linear(var3, "=", var).asBool();
            VarBool varBool2 = this.linear(var3, "=", var2).asBool();
            this.post(varBool.plus(varBool2), "!=", 0).post();
            return var3;
        }
        catch (Exception exception) {
            this.log("Failure to create max(var1,var2)");
            return null;
        }
    }

    @Override
    public Var sum(Var[] varArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < varArray.length; ++i) {
            n += varArray[i].getMin();
            n2 += varArray[i].getMax();
        }
        AbstractProblem abstractProblem = (AbstractProblem)varArray[0].getProblem();
        Var var = abstractProblem.variable("_sum_", n, n2);
        abstractProblem.remove("_sum_");
        abstractProblem.post(varArray, "=", var);
        return var;
    }

    @Override
    public Var sum(VarList varList) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < varList.size(); ++i) {
            n += ((Var)varList.get(i)).getMin();
            n2 += ((Var)varList.get(i)).getMax();
        }
        AbstractProblem abstractProblem = (AbstractProblem)((Var)varList.get(0)).getProblem();
        Var var = abstractProblem.variable("_sum_", n, n2);
        abstractProblem.remove("_sum_");
        abstractProblem.post(varList, "=", var);
        return var;
    }

    @Override
    public void setRealPrecision(double d) {
        REAL_PRECISION = d;
    }

    @Override
    public double getRealPrecision() {
        return REAL_PRECISION;
    }

    public Reversible addReversible(String string, int n) {
        throw new RuntimeException("This RI does not support Reversible integers");
    }

    @Override
    public Constraint postElement(Set[] setArray, Var var, String string, VarSet varSet) {
        this.notImplementedException("Constraint postElement is not implemented on Sets");
        return null;
    }

    @Override
    public Constraint getFalseConstraint() {
        return new ConstraintFalse(this);
    }

    @Override
    public Constraint getTrueConstraint() {
        return new ConstraintTrue(this);
    }

    public void notImplementedException(String string) {
        String string2 = string + " is not implemented by " + this.getImplVersion();
        this.log(string2);
        throw new RuntimeException(string2);
    }

    @Override
    public void add(VarString varString) {
        this.varStrings.add(varString);
    }

    @Override
    public VarString[] getVarStrings() {
        if (this.varStrings.isEmpty()) {
            return null;
        }
        VarString[] varStringArray = new VarString[this.varStrings.size()];
        Iterator<VarString> iterator = this.varStrings.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            varStringArray[n++] = iterator.next();
        }
        return varStringArray;
    }

    @Override
    public VarString getVarString(String string) {
        if (this.varStrings.isEmpty()) {
            return null;
        }
        Iterator<VarString> iterator = this.varStrings.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            VarString varString = iterator.next();
            if (!string.equals(varString.getName())) continue;
            return varString;
        }
        return null;
    }

    @Override
    public VarString variableString(String string, String[] stringArray) {
        BasicVarString basicVarString = new BasicVarString(this, string, stringArray);
        this.add(basicVarString);
        return basicVarString;
    }

    @Override
    public Constraint post(VarString varString, String string, String string2) {
        int n = varString.getIndex(string2);
        if (n < 0) {
            throw new RuntimeException("String " + string2 + " is not inside domain of " + this.getName());
        }
        return this.post(varString.getInt(), string, n);
    }

    @Override
    public Constraint linear(VarString varString, String string, String string2) {
        int n = varString.getIndex(string2);
        if (n < 0) {
            throw new RuntimeException("String " + string2 + " is not inside domain of " + varString.getName());
        }
        return this.linear(varString.getInt(), string, n);
    }

    @Override
    public Constraint post(VarString varString, String string, VarString varString2) {
        return this.post(varString.getInt(), string, varString2.getInt());
    }

    @Override
    public Constraint post(VarList varList, String string, int n) {
        Var[] varArray = varList.toArray();
        return this.post(varArray, string, n);
    }

    @Override
    public Constraint post(VarList varList, String string, Var var) {
        Var[] varArray = varList.toArray();
        return this.post(varArray, string, var);
    }

    @Override
    public Var scalProd(int[] nArray, VarList varList) {
        Var[] varArray = varList.toArray();
        return this.scalProd(nArray, varArray);
    }

    @Override
    public VarList variableList() {
        return new VarList();
    }

    @Override
    public VarMatrix variableMatrix(String string, int n, int n2, int n3, int n4) {
        BasicVarMatrix basicVarMatrix = new BasicVarMatrix(this, string, n, n2, n3, n4);
        this.varMatrixs.put(string, basicVarMatrix);
        return basicVarMatrix;
    }

    @Override
    public VarMatrix getVarMatrix(String string) {
        return this.varMatrixs.get(string);
    }
}

