/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.meta;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.immutables.value.internal.$generator$.$Naming;
import org.immutables.value.internal.$guava$.base.$CaseFormat;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$processor$.meta.$Styles;
import org.immutables.value.internal.$processor$.meta.$SwitchMirror;

public final class $SwitcherModel {
    private final String defaultName;
    private final $Naming switcherNaming;
    public final $ImmutableList<SwitchOption> options;
    private final TypeElement containedTypeElement;

    $SwitcherModel($SwitchMirror mirror, $Styles.UsingName.AttributeNames names, TypeElement containedTypeElement) {
        this.switcherNaming = $Naming.from(names.raw).requireNonConstant($Naming.Preference.SUFFIX);
        this.containedTypeElement = $Preconditions.checkNotNull(containedTypeElement);
        this.defaultName = mirror.defaultName();
        this.options = this.constructOptions();
    }

    private $ImmutableList<SwitchOption> constructOptions() {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (Element element : this.containedTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String name = element.getSimpleName().toString();
            builder.add(new SwitchOption(name, this.defaultName.equals(name)));
        }
        return builder.build();
    }

    public boolean hasDefault() {
        return !this.defaultName.isEmpty();
    }

    public final class SwitchOption {
        public final boolean isDefault;
        public final String constantName;
        public final String switcherName;

        public SwitchOption(String constantName, boolean isDefault) {
            this.constantName = constantName;
            this.switcherName = this.deriveSwitcherName(constantName);
            this.isDefault = isDefault;
        }

        private String deriveSwitcherName(String constantName) {
            return $SwitcherModel.this.switcherNaming.apply($CaseFormat.UPPER_UNDERSCORE.to($CaseFormat.LOWER_CAMEL, constantName));
        }
    }
}

