/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.immutables.value.Value;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Predicate;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Iterators;
import org.immutables.value.internal.$guava$.collect.$PeekingIterator;
import org.immutables.value.internal.$processor$.encode.$Code;

@Value.Enclosing
final class $Structurizer {
    private static final $ImmutableSet<String> modifiers = $Structurizer.allModifiers();
    private final $PeekingIterator<$Code.Term> terms;
    private final WhitespaceEnabler whitespaces = new WhitespaceEnabler();

    $Structurizer(Iterable<$Code.Term> terms) {
        this.terms = $Iterators.peekingIterator($Iterators.filter(terms.iterator(), this.whitespaces));
    }

    List<Statement> structurize() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        while (this.terms.hasNext()) {
            result.add(this.statement());
        }
        return result;
    }

    private Statement statement() {
        Statement.Builder builder = new Statement.Builder();
        boolean classDecl = false;
        boolean wasParameters = false;
        while (true) {
            $Code.Term t;
            if ((t = this.terms.peek()).is("=")) {
                this.terms.next();
                this.expressionUpToSemicolon(builder);
                return builder.build();
            }
            if (t.is("(") && !wasParameters) {
                builder.addAllParameters(this.collectUntilMatching(")"));
                wasParameters = true;
                continue;
            }
            if (t.is("{")) {
                this.block(builder, classDecl);
                return builder.build();
            }
            if (t.is(";")) {
                this.terms.next();
                return builder.build();
            }
            if (wasParameters) {
                this.terms.next();
                continue;
            }
            if (!this.signature(builder)) continue;
            classDecl = true;
            builder.name($Optional.of(this.terms.peek().toString()));
        }
    }

    private List<$Code.Term> collectUntilMatching(String end) {
        ArrayList<$Code.Term> result = new ArrayList<$Code.Term>();
        this.doCollectMatching(result, this.terms.peek().toString(), end);
        return result;
    }

    private void doCollectMatching(List<$Code.Term> accumulator, String start, String end) {
        this.whitespaces.on();
        try {
            accumulator.add(this.terms.next());
            while (true) {
                $Code.Term t;
                if ((t = this.terms.peek()).is(start)) {
                    this.doCollectMatching(accumulator, start, end);
                    continue;
                }
                if (t.is(end)) {
                    accumulator.add(this.terms.next());
                    return;
                }
                accumulator.add(this.terms.next());
            }
        }
        finally {
            this.whitespaces.off();
        }
    }

    private void expressionUpToSemicolon(Statement.Builder builder) {
        this.terms.peek();
        this.whitespaces.on();
        try {
            ArrayList<$Code.Term> result = new ArrayList<$Code.Term>();
            while (true) {
                $Code.Term t;
                if ((t = this.terms.peek()).is("(")) {
                    this.doCollectMatching(result, "(", ")");
                    continue;
                }
                if (t.is("{")) {
                    this.doCollectMatching(result, "{", "}");
                    continue;
                }
                if (t.is("[")) {
                    this.doCollectMatching(result, "[", "]");
                    continue;
                }
                if (t.is(";")) {
                    builder.addAllExpression(result);
                    return;
                }
                result.add(this.terms.next());
            }
        }
        finally {
            this.whitespaces.off();
        }
    }

    private void block(Statement.Builder builder, boolean classDecl) {
        if (classDecl) {
            $Verify.verify(this.terms.peek().is("{"));
            this.terms.next();
            while (this.terms.hasNext() && !this.terms.peek().is("}")) {
                builder.addDefinitions(this.statement());
            }
            $Verify.verify(this.terms.next().is("}"));
        } else {
            builder.addAllBlock(this.collectUntilMatching("}"));
        }
    }

    private boolean signature(Statement.Builder builder) {
        $Code.Term t = this.terms.peek();
        if (t.is("@")) {
            do {
                builder.addAnnotations(this.terms.next());
                $Verify.verify(this.terms.peek().isWordOrNumber());
                builder.addAnnotations(this.terms.next());
            } while (this.terms.peek().is("."));
            if (this.terms.peek().is("(")) {
                builder.addAllAnnotations(this.collectUntilMatching(")"));
            }
            return false;
        }
        if (t.is("<")) {
            builder.addAllSignature(this.collectUntilMatching(">"));
            return false;
        }
        if (t.is("class") || t.is("interface")) {
            builder.addSignature(this.terms.next());
            return true;
        }
        builder.addSignature(this.terms.next());
        return false;
    }

    private static List<$Code.Term> parseReturnType(List<$Code.Term> signature) {
        if (signature.isEmpty()) {
            return $ImmutableList.of();
        }
        ArrayDeque<$Code.Term> terms = new ArrayDeque<$Code.Term>(signature);
        $Code.Term last = ($Code.Term)terms.removeLast();
        if (!last.isWordOrNumber() || last.is("static")) {
            return $ImmutableList.of();
        }
        while (!terms.isEmpty()) {
            $Code.Term t = ($Code.Term)terms.peek();
            if (t.is("<")) {
                $Structurizer.removeTillMatching(terms, "<", ">");
                continue;
            }
            if (modifiers.contains(t.toString())) {
                terms.remove();
                continue;
            }
            $Structurizer.removeCommentsAndWhitespace(terms);
            return $ImmutableList.copyOf(terms);
        }
        return $ImmutableList.of();
    }

    private static void removeCommentsAndWhitespace(Deque<$Code.Term> terms) {
        Iterator<$Code.Term> it = terms.iterator();
        while (it.hasNext()) {
            $Code.Term n = it.next();
            if (!n.isComment() && !n.isWhitespace()) continue;
            it.remove();
        }
    }

    private static void removeTillMatching(Deque<$Code.Term> terms, String begin, String end) {
        assert (terms.peek().is(begin));
        terms.remove();
        while (true) {
            if (terms.peek().is(begin)) {
                $Structurizer.removeTillMatching(terms, begin, end);
                continue;
            }
            if (terms.remove().is(end)) break;
        }
    }

    private static $ImmutableSet<String> allModifiers() {
        $ImmutableSet.Builder b = $ImmutableSet.builder();
        for (Modifier m : Modifier.values()) {
            b.add(m.toString());
        }
        return b.build();
    }

    @Value.Immutable
    static abstract class Statement {
        Statement() {
        }

        abstract List<$Code.Term> annotations();

        abstract List<$Code.Term> signature();

        abstract List<$Code.Term> parameters();

        abstract List<$Code.Term> expression();

        abstract List<$Code.Term> block();

        abstract List<Statement> definitions();

        @Value.Derived
        boolean isClassOrInterface() {
            for ($Code.Term t : this.signature()) {
                if (!t.is("class") && !t.is("interface")) continue;
                return true;
            }
            return false;
        }

        @Value.Lazy
        List<$Code.Term> returnType() {
            return $Structurizer.parseReturnType(this.signature());
        }

        @Value.Default
        $Optional<String> name() {
            if (this.signature().isEmpty()) {
                return $Optional.absent();
            }
            $Code.Term last = $Iterables.getLast(this.signature());
            if (last.isWordOrNumber() && !last.is("static")) {
                return $Optional.of(last.toString());
            }
            return $Optional.absent();
        }

        static class Builder
        extends .processor..ImmutableStructurizer.Statement.Builder {
            Builder() {
            }
        }
    }

    private final class WhitespaceEnabler
    implements $Predicate<$Code.Term> {
        private int count;

        private WhitespaceEnabler() {
        }

        void on() {
            ++this.count;
        }

        void off() {
            if (--this.count < 0) {
                throw new IllegalStateException("unmatched off");
            }
        }

        @Override
        public boolean apply($Code.Term input) {
            return this.count > 0 || !input.isWhitespace() && !input.isComment();
        }
    }
}

