package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Constitution}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConstitution.builder()}.
 */
@Generated(from = "Constitution", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableConstitution extends Constitution {
  private final Proto.Protoclass protoclass;
  private transient final Visibility implementationVisibility;
  private transient final Visibility builderVisibility;
  private transient final String implementationPackage;
  private transient final Styles.UsingName.TypeNames names;
  private transient final boolean hasImmutableInBuilder;

  private ImmutableConstitution(Proto.Protoclass protoclass) {
    this.protoclass = protoclass;
    this.implementationVisibility = initShim.implementationVisibility();
    this.builderVisibility = initShim.builderVisibility();
    this.implementationPackage = initShim.implementationPackage();
    this.names = initShim.names();
    this.hasImmutableInBuilder = initShim.hasImmutableInBuilder();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Constitution", generator = "Immutables")
  private final class InitShim {
    private byte implementationVisibilityBuildStage = STAGE_UNINITIALIZED;
    private Visibility implementationVisibility;

    Visibility implementationVisibility() {
      if (implementationVisibilityBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (implementationVisibilityBuildStage == STAGE_UNINITIALIZED) {
        implementationVisibilityBuildStage = STAGE_INITIALIZING;
        this.implementationVisibility = Objects.requireNonNull(ImmutableConstitution.super.implementationVisibility(), "implementationVisibility");
        implementationVisibilityBuildStage = STAGE_INITIALIZED;
      }
      return this.implementationVisibility;
    }

    private byte builderVisibilityBuildStage = STAGE_UNINITIALIZED;
    private Visibility builderVisibility;

    Visibility builderVisibility() {
      if (builderVisibilityBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (builderVisibilityBuildStage == STAGE_UNINITIALIZED) {
        builderVisibilityBuildStage = STAGE_INITIALIZING;
        this.builderVisibility = Objects.requireNonNull(ImmutableConstitution.super.builderVisibility(), "builderVisibility");
        builderVisibilityBuildStage = STAGE_INITIALIZED;
      }
      return this.builderVisibility;
    }

    private byte implementationPackageBuildStage = STAGE_UNINITIALIZED;
    private String implementationPackage;

    String implementationPackage() {
      if (implementationPackageBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (implementationPackageBuildStage == STAGE_UNINITIALIZED) {
        implementationPackageBuildStage = STAGE_INITIALIZING;
        this.implementationPackage = Objects.requireNonNull(ImmutableConstitution.super.implementationPackage(), "implementationPackage");
        implementationPackageBuildStage = STAGE_INITIALIZED;
      }
      return this.implementationPackage;
    }

    private byte namesBuildStage = STAGE_UNINITIALIZED;
    private Styles.UsingName.TypeNames names;

    Styles.UsingName.TypeNames names() {
      if (namesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (namesBuildStage == STAGE_UNINITIALIZED) {
        namesBuildStage = STAGE_INITIALIZING;
        this.names = Objects.requireNonNull(ImmutableConstitution.super.names(), "names");
        namesBuildStage = STAGE_INITIALIZED;
      }
      return this.names;
    }

    private byte hasImmutableInBuilderBuildStage = STAGE_UNINITIALIZED;
    private boolean hasImmutableInBuilder;

    boolean hasImmutableInBuilder() {
      if (hasImmutableInBuilderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hasImmutableInBuilderBuildStage == STAGE_UNINITIALIZED) {
        hasImmutableInBuilderBuildStage = STAGE_INITIALIZING;
        this.hasImmutableInBuilder = ImmutableConstitution.super.hasImmutableInBuilder();
        hasImmutableInBuilderBuildStage = STAGE_INITIALIZED;
      }
      return this.hasImmutableInBuilder;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (implementationVisibilityBuildStage == STAGE_INITIALIZING) attributes.add("implementationVisibility");
      if (builderVisibilityBuildStage == STAGE_INITIALIZING) attributes.add("builderVisibility");
      if (implementationPackageBuildStage == STAGE_INITIALIZING) attributes.add("implementationPackage");
      if (namesBuildStage == STAGE_INITIALIZING) attributes.add("names");
      if (hasImmutableInBuilderBuildStage == STAGE_INITIALIZING) attributes.add("hasImmutableInBuilder");
      return "Cannot build Constitution, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code protoclass} attribute
   */
  @Override
  public Proto.Protoclass protoclass() {
    return protoclass;
  }

  /**
   * @return The computed-at-construction value of the {@code implementationVisibility} attribute
   */
  @Override
  public Visibility implementationVisibility() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.implementationVisibility()
        : this.implementationVisibility;
  }

  /**
   * @return The computed-at-construction value of the {@code builderVisibility} attribute
   */
  @Override
  public Visibility builderVisibility() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.builderVisibility()
        : this.builderVisibility;
  }

  /**
   * @return The computed-at-construction value of the {@code implementationPackage} attribute
   */
  @Override
  public String implementationPackage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.implementationPackage()
        : this.implementationPackage;
  }

  /**
   * @return The computed-at-construction value of the {@code names} attribute
   */
  @Override
  public Styles.UsingName.TypeNames names() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.names()
        : this.names;
  }

  /**
   * @return The computed-at-construction value of the {@code hasImmutableInBuilder} attribute
   */
  @Override
  public boolean hasImmutableInBuilder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.hasImmutableInBuilder()
        : this.hasImmutableInBuilder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Constitution#protoclass() protoclass} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protoclass
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstitution withProtoclass(Proto.Protoclass value) {
    if (this.protoclass == value) return this;
    Proto.Protoclass newValue = Objects.requireNonNull(value, "protoclass");
    return new ImmutableConstitution(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConstitution} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConstitution
        && equalTo((ImmutableConstitution) another);
  }

  private boolean equalTo(ImmutableConstitution another) {
    return protoclass.equals(another.protoclass)
        && implementationVisibility.equals(another.implementationVisibility)
        && builderVisibility.equals(another.builderVisibility)
        && implementationPackage.equals(another.implementationPackage)
        && names.equals(another.names)
        && hasImmutableInBuilder == another.hasImmutableInBuilder;
  }

  /**
   * Computes a hash code from attributes: {@code protoclass}, {@code implementationVisibility}, {@code builderVisibility}, {@code implementationPackage}, {@code names}, {@code hasImmutableInBuilder}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + protoclass.hashCode();
    h += (h << 5) + implementationVisibility.hashCode();
    h += (h << 5) + builderVisibility.hashCode();
    h += (h << 5) + implementationPackage.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + Booleans.hashCode(hasImmutableInBuilder);
    return h;
  }

  /**
   * Prints the immutable value {@code Constitution} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Constitution")
        .omitNullValues()
        .add("protoclass", protoclass)
        .add("implementationVisibility", implementationVisibility)
        .add("builderVisibility", builderVisibility)
        .add("implementationPackage", implementationPackage)
        .add("names", names)
        .add("hasImmutableInBuilder", hasImmutableInBuilder)
        .toString();
  }

  private transient volatile long lazyInitBitmap;

  private static final long GENERICS_LAZY_INIT_BIT = 0x1L;

  private transient Generics generics;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#generics() generics} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code generics} attribute
   */
  @Override
  public Generics generics() {
    if ((lazyInitBitmap & GENERICS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & GENERICS_LAZY_INIT_BIT) == 0) {
          this.generics = Objects.requireNonNull(super.generics(), "generics");
          lazyInitBitmap |= GENERICS_LAZY_INIT_BIT;
        }
      }
    }
    return generics;
  }

  private static final long TYPE_PREFERABLY_ABSTRACT_LAZY_INIT_BIT = 0x2L;

  private transient Constitution.NameForms typePreferablyAbstract;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typePreferablyAbstract() typePreferablyAbstract} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typePreferablyAbstract} attribute
   */
  @Override
  public Constitution.NameForms typePreferablyAbstract() {
    if ((lazyInitBitmap & TYPE_PREFERABLY_ABSTRACT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_PREFERABLY_ABSTRACT_LAZY_INIT_BIT) == 0) {
          this.typePreferablyAbstract = Objects.requireNonNull(super.typePreferablyAbstract(), "typePreferablyAbstract");
          lazyInitBitmap |= TYPE_PREFERABLY_ABSTRACT_LAZY_INIT_BIT;
        }
      }
    }
    return typePreferablyAbstract;
  }

  private static final long TYPE_DOCUMENT_LAZY_INIT_BIT = 0x4L;

  private transient Constitution.NameForms typeDocument;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeDocument() typeDocument} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeDocument} attribute
   */
  @Override
  public Constitution.NameForms typeDocument() {
    if ((lazyInitBitmap & TYPE_DOCUMENT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_DOCUMENT_LAZY_INIT_BIT) == 0) {
          this.typeDocument = Objects.requireNonNull(super.typeDocument(), "typeDocument");
          lazyInitBitmap |= TYPE_DOCUMENT_LAZY_INIT_BIT;
        }
      }
    }
    return typeDocument;
  }

  private static final long TYPE_MODIFIABLE_LAZY_INIT_BIT = 0x8L;

  private transient Constitution.NameForms typeModifiable;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeModifiable() typeModifiable} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeModifiable} attribute
   */
  @Override
  public Constitution.NameForms typeModifiable() {
    if ((lazyInitBitmap & TYPE_MODIFIABLE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_MODIFIABLE_LAZY_INIT_BIT) == 0) {
          this.typeModifiable = Objects.requireNonNull(super.typeModifiable(), "typeModifiable");
          lazyInitBitmap |= TYPE_MODIFIABLE_LAZY_INIT_BIT;
        }
      }
    }
    return typeModifiable;
  }

  private static final long FACTORY_CREATE_LAZY_INIT_BIT = 0x10L;

  private transient Constitution.AppliedNameForms factoryCreate;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#factoryCreate() factoryCreate} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code factoryCreate} attribute
   */
  @Override
  public Constitution.AppliedNameForms factoryCreate() {
    if ((lazyInitBitmap & FACTORY_CREATE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & FACTORY_CREATE_LAZY_INIT_BIT) == 0) {
          this.factoryCreate = Objects.requireNonNull(super.factoryCreate(), "factoryCreate");
          lazyInitBitmap |= FACTORY_CREATE_LAZY_INIT_BIT;
        }
      }
    }
    return factoryCreate;
  }

  private static final long TYPE_VALUE_LAZY_INIT_BIT = 0x20L;

  private transient Constitution.NameForms typeValue;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeValue() typeValue} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeValue} attribute
   */
  @Override
  public Constitution.NameForms typeValue() {
    if ((lazyInitBitmap & TYPE_VALUE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_VALUE_LAZY_INIT_BIT) == 0) {
          this.typeValue = Objects.requireNonNull(super.typeValue(), "typeValue");
          lazyInitBitmap |= TYPE_VALUE_LAZY_INIT_BIT;
        }
      }
    }
    return typeValue;
  }

  private static final long TYPE_ABSTRACT_LAZY_INIT_BIT = 0x40L;

  private transient Constitution.NameForms typeAbstract;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeAbstract() typeAbstract} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeAbstract} attribute
   */
  @Override
  public Constitution.NameForms typeAbstract() {
    if ((lazyInitBitmap & TYPE_ABSTRACT_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_ABSTRACT_LAZY_INIT_BIT) == 0) {
          this.typeAbstract = Objects.requireNonNull(super.typeAbstract(), "typeAbstract");
          lazyInitBitmap |= TYPE_ABSTRACT_LAZY_INIT_BIT;
        }
      }
    }
    return typeAbstract;
  }

  private static final long TYPE_IMMUTABLE_LAZY_INIT_BIT = 0x80L;

  private transient Constitution.NameForms typeImmutable;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeImmutable() typeImmutable} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeImmutable} attribute
   */
  @Override
  public Constitution.NameForms typeImmutable() {
    if ((lazyInitBitmap & TYPE_IMMUTABLE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_IMMUTABLE_LAZY_INIT_BIT) == 0) {
          this.typeImmutable = Objects.requireNonNull(super.typeImmutable(), "typeImmutable");
          lazyInitBitmap |= TYPE_IMMUTABLE_LAZY_INIT_BIT;
        }
      }
    }
    return typeImmutable;
  }

  private static final long TYPE_IMMUTABLE_ENCLOSING_SIMPLE_NAME_LAZY_INIT_BIT = 0x100L;

  private transient String typeImmutableEnclosingSimpleName;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeImmutableEnclosingSimpleName() typeImmutableEnclosingSimpleName} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeImmutableEnclosingSimpleName} attribute
   */
  @Override
  String typeImmutableEnclosingSimpleName() {
    if ((lazyInitBitmap & TYPE_IMMUTABLE_ENCLOSING_SIMPLE_NAME_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_IMMUTABLE_ENCLOSING_SIMPLE_NAME_LAZY_INIT_BIT) == 0) {
          this.typeImmutableEnclosingSimpleName = Objects.requireNonNull(super.typeImmutableEnclosingSimpleName(), "typeImmutableEnclosingSimpleName");
          lazyInitBitmap |= TYPE_IMMUTABLE_ENCLOSING_SIMPLE_NAME_LAZY_INIT_BIT;
        }
      }
    }
    return typeImmutableEnclosingSimpleName;
  }

  private static final long FACTORY_BUILDER_LAZY_INIT_BIT = 0x200L;

  private transient Constitution.AppliedNameForms factoryBuilder;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#factoryBuilder() factoryBuilder} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code factoryBuilder} attribute
   */
  @Override
  public Constitution.AppliedNameForms factoryBuilder() {
    if ((lazyInitBitmap & FACTORY_BUILDER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & FACTORY_BUILDER_LAZY_INIT_BIT) == 0) {
          this.factoryBuilder = Objects.requireNonNull(super.factoryBuilder(), "factoryBuilder");
          lazyInitBitmap |= FACTORY_BUILDER_LAZY_INIT_BIT;
        }
      }
    }
    return factoryBuilder;
  }

  private static final long FACTORY_OF_LAZY_INIT_BIT = 0x400L;

  private transient Constitution.AppliedNameForms factoryOf;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#factoryOf() factoryOf} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code factoryOf} attribute
   */
  @Override
  public Constitution.AppliedNameForms factoryOf() {
    if ((lazyInitBitmap & FACTORY_OF_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & FACTORY_OF_LAZY_INIT_BIT) == 0) {
          this.factoryOf = Objects.requireNonNull(super.factoryOf(), "factoryOf");
          lazyInitBitmap |= FACTORY_OF_LAZY_INIT_BIT;
        }
      }
    }
    return factoryOf;
  }

  private static final long FACTORY_INSTANCE_LAZY_INIT_BIT = 0x800L;

  private transient Constitution.AppliedNameForms factoryInstance;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#factoryInstance() factoryInstance} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code factoryInstance} attribute
   */
  @Override
  public Constitution.AppliedNameForms factoryInstance() {
    if ((lazyInitBitmap & FACTORY_INSTANCE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & FACTORY_INSTANCE_LAZY_INIT_BIT) == 0) {
          this.factoryInstance = Objects.requireNonNull(super.factoryInstance(), "factoryInstance");
          lazyInitBitmap |= FACTORY_INSTANCE_LAZY_INIT_BIT;
        }
      }
    }
    return factoryInstance;
  }

  private static final long FACTORY_COPY_OF_LAZY_INIT_BIT = 0x1000L;

  private transient Constitution.AppliedNameForms factoryCopyOf;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#factoryCopyOf() factoryCopyOf} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code factoryCopyOf} attribute
   */
  @Override
  public Constitution.AppliedNameForms factoryCopyOf() {
    if ((lazyInitBitmap & FACTORY_COPY_OF_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & FACTORY_COPY_OF_LAZY_INIT_BIT) == 0) {
          this.factoryCopyOf = Objects.requireNonNull(super.factoryCopyOf(), "factoryCopyOf");
          lazyInitBitmap |= FACTORY_COPY_OF_LAZY_INIT_BIT;
        }
      }
    }
    return factoryCopyOf;
  }

  private static final long TYPE_ENCLOSING_FACTORY_LAZY_INIT_BIT = 0x2000L;

  private transient Constitution.NameForms typeEnclosingFactory;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeEnclosingFactory() typeEnclosingFactory} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeEnclosingFactory} attribute
   */
  @Override
  public Constitution.NameForms typeEnclosingFactory() {
    if ((lazyInitBitmap & TYPE_ENCLOSING_FACTORY_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_ENCLOSING_FACTORY_LAZY_INIT_BIT) == 0) {
          this.typeEnclosingFactory = Objects.requireNonNull(super.typeEnclosingFactory(), "typeEnclosingFactory");
          lazyInitBitmap |= TYPE_ENCLOSING_FACTORY_LAZY_INIT_BIT;
        }
      }
    }
    return typeEnclosingFactory;
  }

  private static final long TYPE_ENCLOSING_LAZY_INIT_BIT = 0x4000L;

  private transient Constitution.NameForms typeEnclosing;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeEnclosing() typeEnclosing} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeEnclosing} attribute
   */
  @Override
  public Constitution.NameForms typeEnclosing() {
    if ((lazyInitBitmap & TYPE_ENCLOSING_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_ENCLOSING_LAZY_INIT_BIT) == 0) {
          this.typeEnclosing = Objects.requireNonNull(super.typeEnclosing(), "typeEnclosing");
          lazyInitBitmap |= TYPE_ENCLOSING_LAZY_INIT_BIT;
        }
      }
    }
    return typeEnclosing;
  }

  private static final long TYPE_WITH_LAZY_INIT_BIT = 0x8000L;

  private transient Constitution.NameForms typeWith;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeWith() typeWith} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeWith} attribute
   */
  @Override
  public Constitution.NameForms typeWith() {
    if ((lazyInitBitmap & TYPE_WITH_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_WITH_LAZY_INIT_BIT) == 0) {
          this.typeWith = Objects.requireNonNull(super.typeWith(), "typeWith");
          lazyInitBitmap |= TYPE_WITH_LAZY_INIT_BIT;
        }
      }
    }
    return typeWith;
  }

  private static final long TYPE_BUILDER_LAZY_INIT_BIT = 0x10000L;

  private transient Constitution.NameForms typeBuilder;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeBuilder() typeBuilder} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeBuilder} attribute
   */
  @Override
  public Constitution.NameForms typeBuilder() {
    if ((lazyInitBitmap & TYPE_BUILDER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_BUILDER_LAZY_INIT_BIT) == 0) {
          this.typeBuilder = Objects.requireNonNull(super.typeBuilder(), "typeBuilder");
          lazyInitBitmap |= TYPE_BUILDER_LAZY_INIT_BIT;
        }
      }
    }
    return typeBuilder;
  }

  private static final long TYPE_IMPLEMENTATION_BUILDER_LAZY_INIT_BIT = 0x20000L;

  private transient Constitution.NameForms typeImplementationBuilder;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#typeImplementationBuilder() typeImplementationBuilder} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code typeImplementationBuilder} attribute
   */
  @Override
  public Constitution.NameForms typeImplementationBuilder() {
    if ((lazyInitBitmap & TYPE_IMPLEMENTATION_BUILDER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & TYPE_IMPLEMENTATION_BUILDER_LAZY_INIT_BIT) == 0) {
          this.typeImplementationBuilder = Objects.requireNonNull(super.typeImplementationBuilder(), "typeImplementationBuilder");
          lazyInitBitmap |= TYPE_IMPLEMENTATION_BUILDER_LAZY_INIT_BIT;
        }
      }
    }
    return typeImplementationBuilder;
  }

  private static final long INNER_BUILDER_LAZY_INIT_BIT = 0x40000L;

  private transient Constitution.InnerBuilderDefinition innerBuilder;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#innerBuilder() innerBuilder} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code innerBuilder} attribute
   */
  @Override
  public Constitution.InnerBuilderDefinition innerBuilder() {
    if ((lazyInitBitmap & INNER_BUILDER_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & INNER_BUILDER_LAZY_INIT_BIT) == 0) {
          this.innerBuilder = Objects.requireNonNull(super.innerBuilder(), "innerBuilder");
          lazyInitBitmap |= INNER_BUILDER_LAZY_INIT_BIT;
        }
      }
    }
    return innerBuilder;
  }

  private static final long INNER_MODIFIABLE_LAZY_INIT_BIT = 0x80000L;

  private transient Constitution.InnerModifiableDefinition innerModifiable;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link Constitution#innerModifiable() innerModifiable} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code innerModifiable} attribute
   */
  @Override
  public Constitution.InnerModifiableDefinition innerModifiable() {
    if ((lazyInitBitmap & INNER_MODIFIABLE_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & INNER_MODIFIABLE_LAZY_INIT_BIT) == 0) {
          this.innerModifiable = Objects.requireNonNull(super.innerModifiable(), "innerModifiable");
          lazyInitBitmap |= INNER_MODIFIABLE_LAZY_INIT_BIT;
        }
      }
    }
    return innerModifiable;
  }

  /**
   * Creates an immutable copy of a {@link Constitution} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Constitution instance
   */
  public static ImmutableConstitution copyOf(Constitution instance) {
    if (instance instanceof ImmutableConstitution) {
      return (ImmutableConstitution) instance;
    }
    return ImmutableConstitution.builder()
        .protoclass(instance.protoclass())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConstitution ImmutableConstitution}.
   * <pre>
   * ImmutableConstitution.builder()
   *    .protoclass(org.immutables.value.processor.meta.Proto.Protoclass) // required {@link Constitution#protoclass() protoclass}
   *    .build();
   * </pre>
   * @return A new ImmutableConstitution builder
   */
  public static ImmutableConstitution.Builder builder() {
    return new ImmutableConstitution.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConstitution ImmutableConstitution}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Constitution", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROTOCLASS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Proto.Protoclass protoclass;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link Constitution#protoclass() protoclass} attribute.
     * @param protoclass The value for protoclass 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder protoclass(Proto.Protoclass protoclass) {
      checkNotIsSet(protoclassIsSet(), "protoclass");
      this.protoclass = Objects.requireNonNull(protoclass, "protoclass");
      initBits &= ~INIT_BIT_PROTOCLASS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConstitution ImmutableConstitution}.
     * @return An immutable instance of Constitution
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConstitution build() {
      checkRequiredAttributes();
      return new ImmutableConstitution(protoclass);
    }

    private boolean protoclassIsSet() {
      return (initBits & INIT_BIT_PROTOCLASS) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of Constitution is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!protoclassIsSet()) attributes.add("protoclass");
      return "Cannot build Constitution, some of required attributes are not set " + attributes;
    }
  }

  /**
   * Immutable implementation of {@link Constitution.AppliedNameForms}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableConstitution.AppliedNameForms.builder()}.
   */
  @Generated(from = "Constitution.AppliedNameForms", generator = "Immutables")
  @Immutable
  public static final class AppliedNameForms
      extends Constitution.AppliedNameForms {
    private final String absolute;
    private final String absoluteRaw;
    private final Constitution.NameForms forms;
    private final String applied;
    private transient final String simple;
    private transient final boolean isNew;

    private AppliedNameForms(ImmutableConstitution.AppliedNameForms.Builder builder) {
      this.forms = builder.forms;
      this.applied = builder.applied;
      if (builder.absoluteIsSet()) {
        initShim.absolute(builder.absolute);
      }
      if (builder.absoluteRawIsSet()) {
        initShim.absoluteRaw(builder.absoluteRaw);
      }
      this.absolute = initShim.absolute();
      this.absoluteRaw = initShim.absoluteRaw();
      this.simple = initShim.simple();
      this.isNew = initShim.isNew();
      this.initShim = null;
    }

    private AppliedNameForms(
        String absolute,
        String absoluteRaw,
        Constitution.NameForms forms,
        String applied) {
      initShim.absolute(absolute);
      initShim.absoluteRaw(absoluteRaw);
      this.forms = forms;
      this.applied = applied;
      this.absolute = initShim.absolute();
      this.absoluteRaw = initShim.absoluteRaw();
      this.simple = initShim.simple();
      this.isNew = initShim.isNew();
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    @Generated(from = "Constitution.AppliedNameForms", generator = "Immutables")
    private final class InitShim {
      private byte absoluteBuildStage = STAGE_UNINITIALIZED;
      private String absolute;

      String absolute() {
        if (absoluteBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (absoluteBuildStage == STAGE_UNINITIALIZED) {
          absoluteBuildStage = STAGE_INITIALIZING;
          this.absolute = Objects.requireNonNull(AppliedNameForms.super.absolute(), "absolute");
          absoluteBuildStage = STAGE_INITIALIZED;
        }
        return this.absolute;
      }

      void absolute(String absolute) {
        this.absolute = absolute;
        absoluteBuildStage = STAGE_INITIALIZED;
      }

      private byte absoluteRawBuildStage = STAGE_UNINITIALIZED;
      private String absoluteRaw;

      String absoluteRaw() {
        if (absoluteRawBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (absoluteRawBuildStage == STAGE_UNINITIALIZED) {
          absoluteRawBuildStage = STAGE_INITIALIZING;
          this.absoluteRaw = Objects.requireNonNull(AppliedNameForms.super.absoluteRaw(), "absoluteRaw");
          absoluteRawBuildStage = STAGE_INITIALIZED;
        }
        return this.absoluteRaw;
      }

      void absoluteRaw(String absoluteRaw) {
        this.absoluteRaw = absoluteRaw;
        absoluteRawBuildStage = STAGE_INITIALIZED;
      }

      private byte simpleBuildStage = STAGE_UNINITIALIZED;
      private String simple;

      String simple() {
        if (simpleBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (simpleBuildStage == STAGE_UNINITIALIZED) {
          simpleBuildStage = STAGE_INITIALIZING;
          this.simple = Objects.requireNonNull(AppliedNameForms.super.simple(), "simple");
          simpleBuildStage = STAGE_INITIALIZED;
        }
        return this.simple;
      }

      private byte isNewBuildStage = STAGE_UNINITIALIZED;
      private boolean isNew;

      boolean isNew() {
        if (isNewBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (isNewBuildStage == STAGE_UNINITIALIZED) {
          isNewBuildStage = STAGE_INITIALIZING;
          this.isNew = AppliedNameForms.super.isNew();
          isNewBuildStage = STAGE_INITIALIZED;
        }
        return this.isNew;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (absoluteBuildStage == STAGE_INITIALIZING) attributes.add("absolute");
        if (absoluteRawBuildStage == STAGE_INITIALIZING) attributes.add("absoluteRaw");
        if (simpleBuildStage == STAGE_INITIALIZING) attributes.add("simple");
        if (isNewBuildStage == STAGE_INITIALIZING) attributes.add("isNew");
        return "Cannot build AppliedNameForms, attribute initializers form cycle " + attributes;
      }
    }

    /**
     * @return The value of the {@code absolute} attribute
     */
    @Override
    public String absolute() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.absolute()
          : this.absolute;
    }

    /**
     * @return The value of the {@code absoluteRaw} attribute
     */
    @Override
    public String absoluteRaw() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.absoluteRaw()
          : this.absoluteRaw;
    }

    /**
     * @return The value of the {@code forms} attribute
     */
    @Override
    public Constitution.NameForms forms() {
      return forms;
    }

    /**
     * @return The value of the {@code applied} attribute
     */
    @Override
    public String applied() {
      return applied;
    }

    /**
     * @return The computed-at-construction value of the {@code simple} attribute
     */
    @Override
    public String simple() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.simple()
          : this.simple;
    }

    /**
     * @return The computed-at-construction value of the {@code isNew} attribute
     */
    @Override
    public boolean isNew() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.isNew()
          : this.isNew;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.AppliedNameForms#absolute() absolute} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for absolute
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.AppliedNameForms withAbsolute(String value) {
      String newValue = Objects.requireNonNull(value, "absolute");
      if (this.absolute.equals(newValue)) return this;
      return new ImmutableConstitution.AppliedNameForms(newValue, this.absoluteRaw, this.forms, this.applied);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.AppliedNameForms#absoluteRaw() absoluteRaw} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for absoluteRaw
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.AppliedNameForms withAbsoluteRaw(String value) {
      String newValue = Objects.requireNonNull(value, "absoluteRaw");
      if (this.absoluteRaw.equals(newValue)) return this;
      return new ImmutableConstitution.AppliedNameForms(this.absolute, newValue, this.forms, this.applied);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.AppliedNameForms#forms() forms} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for forms
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.AppliedNameForms withForms(Constitution.NameForms value) {
      if (this.forms == value) return this;
      Constitution.NameForms newValue = Objects.requireNonNull(value, "forms");
      return new ImmutableConstitution.AppliedNameForms(this.absolute, this.absoluteRaw, newValue, this.applied);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.AppliedNameForms#applied() applied} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for applied
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.AppliedNameForms withApplied(String value) {
      String newValue = Objects.requireNonNull(value, "applied");
      if (this.applied.equals(newValue)) return this;
      return new ImmutableConstitution.AppliedNameForms(this.absolute, this.absoluteRaw, this.forms, newValue);
    }

    /**
     * This instance is equal to all instances of {@code AppliedNameForms} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableConstitution.AppliedNameForms
          && equalTo((ImmutableConstitution.AppliedNameForms) another);
    }

    private boolean equalTo(ImmutableConstitution.AppliedNameForms another) {
      return absolute.equals(another.absolute)
          && absoluteRaw.equals(another.absoluteRaw)
          && forms.equals(another.forms)
          && applied.equals(another.applied)
          && simple.equals(another.simple)
          && isNew == another.isNew;
    }

    /**
     * Computes a hash code from attributes: {@code absolute}, {@code absoluteRaw}, {@code forms}, {@code applied}, {@code simple}, {@code isNew}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + absolute.hashCode();
      h += (h << 5) + absoluteRaw.hashCode();
      h += (h << 5) + forms.hashCode();
      h += (h << 5) + applied.hashCode();
      h += (h << 5) + simple.hashCode();
      h += (h << 5) + Booleans.hashCode(isNew);
      return h;
    }

    /**
     * Creates an immutable copy of a {@link Constitution.AppliedNameForms} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AppliedNameForms instance
     */
    public static ImmutableConstitution.AppliedNameForms copyOf(Constitution.AppliedNameForms instance) {
      if (instance instanceof ImmutableConstitution.AppliedNameForms) {
        return (ImmutableConstitution.AppliedNameForms) instance;
      }
      return ImmutableConstitution.AppliedNameForms.builder()
          .absolute(instance.absolute())
          .absoluteRaw(instance.absoluteRaw())
          .forms(instance.forms())
          .applied(instance.applied())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableConstitution.AppliedNameForms AppliedNameForms}.
     * <pre>
     * ImmutableConstitution.AppliedNameForms.builder()
     *    .absolute(String) // optional {@link Constitution.AppliedNameForms#absolute() absolute}
     *    .absoluteRaw(String) // optional {@link Constitution.AppliedNameForms#absoluteRaw() absoluteRaw}
     *    .forms(org.immutables.value.processor.meta.Constitution.NameForms) // required {@link Constitution.AppliedNameForms#forms() forms}
     *    .applied(String) // required {@link Constitution.AppliedNameForms#applied() applied}
     *    .build();
     * </pre>
     * @return A new AppliedNameForms builder
     */
    public static ImmutableConstitution.AppliedNameForms.Builder builder() {
      return new ImmutableConstitution.AppliedNameForms.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableConstitution.AppliedNameForms AppliedNameForms}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Constitution.AppliedNameForms", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_FORMS = 0x1L;
      private static final long INIT_BIT_APPLIED = 0x2L;
      private static final long OPT_BIT_ABSOLUTE = 0x1L;
      private static final long OPT_BIT_ABSOLUTE_RAW = 0x2L;
      private long initBits = 0x3L;
      private long optBits;

      private @Nullable String absolute;
      private @Nullable String absoluteRaw;
      private @Nullable Constitution.NameForms forms;
      private @Nullable String applied;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Constitution.AppliedNameForms#absolute() absolute} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Constitution.AppliedNameForms#absolute() absolute}.</em>
       * @param absolute The value for absolute 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder absolute(String absolute) {
        checkNotIsSet(absoluteIsSet(), "absolute");
        this.absolute = Objects.requireNonNull(absolute, "absolute");
        optBits |= OPT_BIT_ABSOLUTE;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.AppliedNameForms#absoluteRaw() absoluteRaw} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Constitution.AppliedNameForms#absoluteRaw() absoluteRaw}.</em>
       * @param absoluteRaw The value for absoluteRaw 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder absoluteRaw(String absoluteRaw) {
        checkNotIsSet(absoluteRawIsSet(), "absoluteRaw");
        this.absoluteRaw = Objects.requireNonNull(absoluteRaw, "absoluteRaw");
        optBits |= OPT_BIT_ABSOLUTE_RAW;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.AppliedNameForms#forms() forms} attribute.
       * @param forms The value for forms 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder forms(Constitution.NameForms forms) {
        checkNotIsSet(formsIsSet(), "forms");
        this.forms = Objects.requireNonNull(forms, "forms");
        initBits &= ~INIT_BIT_FORMS;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.AppliedNameForms#applied() applied} attribute.
       * @param applied The value for applied 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder applied(String applied) {
        checkNotIsSet(appliedIsSet(), "applied");
        this.applied = Objects.requireNonNull(applied, "applied");
        initBits &= ~INIT_BIT_APPLIED;
        return this;
      }

      /**
       * Builds a new {@link ImmutableConstitution.AppliedNameForms AppliedNameForms}.
       * @return An immutable instance of AppliedNameForms
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableConstitution.AppliedNameForms build() {
        checkRequiredAttributes();
        return new ImmutableConstitution.AppliedNameForms(this);
      }

      private boolean absoluteIsSet() {
        return (optBits & OPT_BIT_ABSOLUTE) != 0;
      }

      private boolean absoluteRawIsSet() {
        return (optBits & OPT_BIT_ABSOLUTE_RAW) != 0;
      }

      private boolean formsIsSet() {
        return (initBits & INIT_BIT_FORMS) == 0;
      }

      private boolean appliedIsSet() {
        return (initBits & INIT_BIT_APPLIED) == 0;
      }

      private static void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of AppliedNameForms is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if (!formsIsSet()) attributes.add("forms");
        if (!appliedIsSet()) attributes.add("applied");
        return "Cannot build AppliedNameForms, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Constitution.NameForms}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableConstitution.NameForms.builder()}.
   */
  @Generated(from = "Constitution.NameForms", generator = "Immutables")
  @Immutable
  public static final class NameForms extends Constitution.NameForms {
    private final String simple;
    private final String relativeRaw;
    private final String packageOf;
    private final Visibility visibility;
    private final String absolute;
    private final String absoluteRaw;
    private final String genericArgs;
    private final boolean relativeAlreadyQualified;

    private NameForms(ImmutableConstitution.NameForms.Builder builder) {
      this.simple = builder.simple;
      this.relativeRaw = builder.relativeRaw;
      this.packageOf = builder.packageOf;
      this.visibility = builder.visibility;
      if (builder.absoluteIsSet()) {
        initShim.absolute(builder.absolute);
      }
      if (builder.absoluteRawIsSet()) {
        initShim.absoluteRaw(builder.absoluteRaw);
      }
      if (builder.genericArgsIsSet()) {
        initShim.genericArgs(builder.genericArgs);
      }
      if (builder.relativeAlreadyQualifiedIsSet()) {
        initShim.relativeAlreadyQualified(builder.relativeAlreadyQualified);
      }
      this.absolute = initShim.absolute();
      this.absoluteRaw = initShim.absoluteRaw();
      this.genericArgs = initShim.genericArgs();
      this.relativeAlreadyQualified = initShim.relativeAlreadyQualified();
      this.initShim = null;
    }

    private NameForms(
        String simple,
        String relativeRaw,
        String packageOf,
        Visibility visibility,
        String absolute,
        String absoluteRaw,
        String genericArgs,
        boolean relativeAlreadyQualified) {
      this.simple = simple;
      this.relativeRaw = relativeRaw;
      this.packageOf = packageOf;
      this.visibility = visibility;
      this.absolute = absolute;
      this.absoluteRaw = absoluteRaw;
      this.genericArgs = genericArgs;
      this.relativeAlreadyQualified = relativeAlreadyQualified;
      this.initShim = null;
    }

    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    @Generated(from = "Constitution.NameForms", generator = "Immutables")
    private final class InitShim {
      private byte absoluteBuildStage = STAGE_UNINITIALIZED;
      private String absolute;

      String absolute() {
        if (absoluteBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (absoluteBuildStage == STAGE_UNINITIALIZED) {
          absoluteBuildStage = STAGE_INITIALIZING;
          this.absolute = Objects.requireNonNull(NameForms.super.absolute(), "absolute");
          absoluteBuildStage = STAGE_INITIALIZED;
        }
        return this.absolute;
      }

      void absolute(String absolute) {
        this.absolute = absolute;
        absoluteBuildStage = STAGE_INITIALIZED;
      }

      private byte absoluteRawBuildStage = STAGE_UNINITIALIZED;
      private String absoluteRaw;

      String absoluteRaw() {
        if (absoluteRawBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (absoluteRawBuildStage == STAGE_UNINITIALIZED) {
          absoluteRawBuildStage = STAGE_INITIALIZING;
          this.absoluteRaw = Objects.requireNonNull(NameForms.super.absoluteRaw(), "absoluteRaw");
          absoluteRawBuildStage = STAGE_INITIALIZED;
        }
        return this.absoluteRaw;
      }

      void absoluteRaw(String absoluteRaw) {
        this.absoluteRaw = absoluteRaw;
        absoluteRawBuildStage = STAGE_INITIALIZED;
      }

      private byte genericArgsBuildStage = STAGE_UNINITIALIZED;
      private String genericArgs;

      String genericArgs() {
        if (genericArgsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (genericArgsBuildStage == STAGE_UNINITIALIZED) {
          genericArgsBuildStage = STAGE_INITIALIZING;
          this.genericArgs = Objects.requireNonNull(NameForms.super.genericArgs(), "genericArgs");
          genericArgsBuildStage = STAGE_INITIALIZED;
        }
        return this.genericArgs;
      }

      void genericArgs(String genericArgs) {
        this.genericArgs = genericArgs;
        genericArgsBuildStage = STAGE_INITIALIZED;
      }

      private byte relativeAlreadyQualifiedBuildStage = STAGE_UNINITIALIZED;
      private boolean relativeAlreadyQualified;

      boolean relativeAlreadyQualified() {
        if (relativeAlreadyQualifiedBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (relativeAlreadyQualifiedBuildStage == STAGE_UNINITIALIZED) {
          relativeAlreadyQualifiedBuildStage = STAGE_INITIALIZING;
          this.relativeAlreadyQualified = NameForms.super.relativeAlreadyQualified();
          relativeAlreadyQualifiedBuildStage = STAGE_INITIALIZED;
        }
        return this.relativeAlreadyQualified;
      }

      void relativeAlreadyQualified(boolean relativeAlreadyQualified) {
        this.relativeAlreadyQualified = relativeAlreadyQualified;
        relativeAlreadyQualifiedBuildStage = STAGE_INITIALIZED;
      }

      private String formatInitCycleMessage() {
        List<String> attributes = new ArrayList<>();
        if (absoluteBuildStage == STAGE_INITIALIZING) attributes.add("absolute");
        if (absoluteRawBuildStage == STAGE_INITIALIZING) attributes.add("absoluteRaw");
        if (genericArgsBuildStage == STAGE_INITIALIZING) attributes.add("genericArgs");
        if (relativeAlreadyQualifiedBuildStage == STAGE_INITIALIZING) attributes.add("relativeAlreadyQualified");
        return "Cannot build NameForms, attribute initializers form cycle " + attributes;
      }
    }

    /**
     * @return The value of the {@code simple} attribute
     */
    @Override
    public String simple() {
      return simple;
    }

    /**
     * @return The value of the {@code relativeRaw} attribute
     */
    @Override
    public String relativeRaw() {
      return relativeRaw;
    }

    /**
     * @return The value of the {@code packageOf} attribute
     */
    @Override
    public String packageOf() {
      return packageOf;
    }

    /**
     * @return The value of the {@code visibility} attribute
     */
    @Override
    public Visibility visibility() {
      return visibility;
    }

    /**
     * @return The value of the {@code absolute} attribute
     */
    @Override
    public String absolute() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.absolute()
          : this.absolute;
    }

    /**
     * @return The value of the {@code absoluteRaw} attribute
     */
    @Override
    public String absoluteRaw() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.absoluteRaw()
          : this.absoluteRaw;
    }

    /**
     * @return The value of the {@code genericArgs} attribute
     */
    @Override
    public String genericArgs() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.genericArgs()
          : this.genericArgs;
    }

    /**
     * @return The value of the {@code relativeAlreadyQualified} attribute
     */
    @Override
    public boolean relativeAlreadyQualified() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.relativeAlreadyQualified()
          : this.relativeAlreadyQualified;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#simple() simple} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for simple
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withSimple(String value) {
      String newValue = Objects.requireNonNull(value, "simple");
      if (this.simple.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          newValue,
          this.relativeRaw,
          this.packageOf,
          this.visibility,
          this.absolute,
          this.absoluteRaw,
          this.genericArgs,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#relativeRaw() relativeRaw} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for relativeRaw
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withRelativeRaw(String value) {
      String newValue = Objects.requireNonNull(value, "relativeRaw");
      if (this.relativeRaw.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          newValue,
          this.packageOf,
          this.visibility,
          this.absolute,
          this.absoluteRaw,
          this.genericArgs,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#packageOf() packageOf} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for packageOf
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withPackageOf(String value) {
      String newValue = Objects.requireNonNull(value, "packageOf");
      if (this.packageOf.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          this.relativeRaw,
          newValue,
          this.visibility,
          this.absolute,
          this.absoluteRaw,
          this.genericArgs,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#visibility() visibility} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for visibility
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withVisibility(Visibility value) {
      if (this.visibility == value) return this;
      Visibility newValue = Objects.requireNonNull(value, "visibility");
      if (this.visibility.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          this.relativeRaw,
          this.packageOf,
          newValue,
          this.absolute,
          this.absoluteRaw,
          this.genericArgs,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#absolute() absolute} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for absolute
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withAbsolute(String value) {
      String newValue = Objects.requireNonNull(value, "absolute");
      if (this.absolute.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          this.relativeRaw,
          this.packageOf,
          this.visibility,
          newValue,
          this.absoluteRaw,
          this.genericArgs,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#absoluteRaw() absoluteRaw} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for absoluteRaw
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withAbsoluteRaw(String value) {
      String newValue = Objects.requireNonNull(value, "absoluteRaw");
      if (this.absoluteRaw.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          this.relativeRaw,
          this.packageOf,
          this.visibility,
          this.absolute,
          newValue,
          this.genericArgs,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#genericArgs() genericArgs} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for genericArgs
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withGenericArgs(String value) {
      String newValue = Objects.requireNonNull(value, "genericArgs");
      if (this.genericArgs.equals(newValue)) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          this.relativeRaw,
          this.packageOf,
          this.visibility,
          this.absolute,
          this.absoluteRaw,
          newValue,
          this.relativeAlreadyQualified);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Constitution.NameForms#relativeAlreadyQualified() relativeAlreadyQualified} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for relativeAlreadyQualified
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableConstitution.NameForms withRelativeAlreadyQualified(boolean value) {
      if (this.relativeAlreadyQualified == value) return this;
      return new ImmutableConstitution.NameForms(
          this.simple,
          this.relativeRaw,
          this.packageOf,
          this.visibility,
          this.absolute,
          this.absoluteRaw,
          this.genericArgs,
          value);
    }

    /**
     * This instance is equal to all instances of {@code NameForms} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableConstitution.NameForms
          && equalTo((ImmutableConstitution.NameForms) another);
    }

    private boolean equalTo(ImmutableConstitution.NameForms another) {
      return simple.equals(another.simple)
          && relativeRaw.equals(another.relativeRaw)
          && packageOf.equals(another.packageOf)
          && visibility.equals(another.visibility)
          && absolute.equals(another.absolute)
          && absoluteRaw.equals(another.absoluteRaw)
          && genericArgs.equals(another.genericArgs)
          && relativeAlreadyQualified == another.relativeAlreadyQualified;
    }

    /**
     * Computes a hash code from attributes: {@code simple}, {@code relativeRaw}, {@code packageOf}, {@code visibility}, {@code absolute}, {@code absoluteRaw}, {@code genericArgs}, {@code relativeAlreadyQualified}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + simple.hashCode();
      h += (h << 5) + relativeRaw.hashCode();
      h += (h << 5) + packageOf.hashCode();
      h += (h << 5) + visibility.hashCode();
      h += (h << 5) + absolute.hashCode();
      h += (h << 5) + absoluteRaw.hashCode();
      h += (h << 5) + genericArgs.hashCode();
      h += (h << 5) + Booleans.hashCode(relativeAlreadyQualified);
      return h;
    }

    /**
     * Creates an immutable copy of a {@link Constitution.NameForms} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable NameForms instance
     */
    public static ImmutableConstitution.NameForms copyOf(Constitution.NameForms instance) {
      if (instance instanceof ImmutableConstitution.NameForms) {
        return (ImmutableConstitution.NameForms) instance;
      }
      return ImmutableConstitution.NameForms.builder()
          .simple(instance.simple())
          .relativeRaw(instance.relativeRaw())
          .packageOf(instance.packageOf())
          .visibility(instance.visibility())
          .absolute(instance.absolute())
          .absoluteRaw(instance.absoluteRaw())
          .genericArgs(instance.genericArgs())
          .relativeAlreadyQualified(instance.relativeAlreadyQualified())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableConstitution.NameForms NameForms}.
     * <pre>
     * ImmutableConstitution.NameForms.builder()
     *    .simple(String) // required {@link Constitution.NameForms#simple() simple}
     *    .relativeRaw(String) // required {@link Constitution.NameForms#relativeRaw() relativeRaw}
     *    .packageOf(String) // required {@link Constitution.NameForms#packageOf() packageOf}
     *    .visibility(org.immutables.value.processor.meta.Visibility) // required {@link Constitution.NameForms#visibility() visibility}
     *    .absolute(String) // optional {@link Constitution.NameForms#absolute() absolute}
     *    .absoluteRaw(String) // optional {@link Constitution.NameForms#absoluteRaw() absoluteRaw}
     *    .genericArgs(String) // optional {@link Constitution.NameForms#genericArgs() genericArgs}
     *    .relativeAlreadyQualified(boolean) // optional {@link Constitution.NameForms#relativeAlreadyQualified() relativeAlreadyQualified}
     *    .build();
     * </pre>
     * @return A new NameForms builder
     */
    public static ImmutableConstitution.NameForms.Builder builder() {
      return new ImmutableConstitution.NameForms.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableConstitution.NameForms NameForms}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Constitution.NameForms", generator = "Immutables")
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_SIMPLE = 0x1L;
      private static final long INIT_BIT_RELATIVE_RAW = 0x2L;
      private static final long INIT_BIT_PACKAGE_OF = 0x4L;
      private static final long INIT_BIT_VISIBILITY = 0x8L;
      private static final long OPT_BIT_ABSOLUTE = 0x1L;
      private static final long OPT_BIT_ABSOLUTE_RAW = 0x2L;
      private static final long OPT_BIT_GENERIC_ARGS = 0x4L;
      private static final long OPT_BIT_RELATIVE_ALREADY_QUALIFIED = 0x8L;
      private long initBits = 0xfL;
      private long optBits;

      private @Nullable String simple;
      private @Nullable String relativeRaw;
      private @Nullable String packageOf;
      private @Nullable Visibility visibility;
      private @Nullable String absolute;
      private @Nullable String absoluteRaw;
      private @Nullable String genericArgs;
      private boolean relativeAlreadyQualified;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#simple() simple} attribute.
       * @param simple The value for simple 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder simple(String simple) {
        checkNotIsSet(simpleIsSet(), "simple");
        this.simple = Objects.requireNonNull(simple, "simple");
        initBits &= ~INIT_BIT_SIMPLE;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#relativeRaw() relativeRaw} attribute.
       * @param relativeRaw The value for relativeRaw 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder relativeRaw(String relativeRaw) {
        checkNotIsSet(relativeRawIsSet(), "relativeRaw");
        this.relativeRaw = Objects.requireNonNull(relativeRaw, "relativeRaw");
        initBits &= ~INIT_BIT_RELATIVE_RAW;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#packageOf() packageOf} attribute.
       * @param packageOf The value for packageOf 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder packageOf(String packageOf) {
        checkNotIsSet(packageOfIsSet(), "packageOf");
        this.packageOf = Objects.requireNonNull(packageOf, "packageOf");
        initBits &= ~INIT_BIT_PACKAGE_OF;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#visibility() visibility} attribute.
       * @param visibility The value for visibility 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder visibility(Visibility visibility) {
        checkNotIsSet(visibilityIsSet(), "visibility");
        this.visibility = Objects.requireNonNull(visibility, "visibility");
        initBits &= ~INIT_BIT_VISIBILITY;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#absolute() absolute} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Constitution.NameForms#absolute() absolute}.</em>
       * @param absolute The value for absolute 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder absolute(String absolute) {
        checkNotIsSet(absoluteIsSet(), "absolute");
        this.absolute = Objects.requireNonNull(absolute, "absolute");
        optBits |= OPT_BIT_ABSOLUTE;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#absoluteRaw() absoluteRaw} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Constitution.NameForms#absoluteRaw() absoluteRaw}.</em>
       * @param absoluteRaw The value for absoluteRaw 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder absoluteRaw(String absoluteRaw) {
        checkNotIsSet(absoluteRawIsSet(), "absoluteRaw");
        this.absoluteRaw = Objects.requireNonNull(absoluteRaw, "absoluteRaw");
        optBits |= OPT_BIT_ABSOLUTE_RAW;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#genericArgs() genericArgs} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Constitution.NameForms#genericArgs() genericArgs}.</em>
       * @param genericArgs The value for genericArgs 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder genericArgs(String genericArgs) {
        checkNotIsSet(genericArgsIsSet(), "genericArgs");
        this.genericArgs = Objects.requireNonNull(genericArgs, "genericArgs");
        optBits |= OPT_BIT_GENERIC_ARGS;
        return this;
      }

      /**
       * Initializes the value for the {@link Constitution.NameForms#relativeAlreadyQualified() relativeAlreadyQualified} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Constitution.NameForms#relativeAlreadyQualified() relativeAlreadyQualified}.</em>
       * @param relativeAlreadyQualified The value for relativeAlreadyQualified 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder relativeAlreadyQualified(boolean relativeAlreadyQualified) {
        checkNotIsSet(relativeAlreadyQualifiedIsSet(), "relativeAlreadyQualified");
        this.relativeAlreadyQualified = relativeAlreadyQualified;
        optBits |= OPT_BIT_RELATIVE_ALREADY_QUALIFIED;
        return this;
      }

      /**
       * Builds a new {@link ImmutableConstitution.NameForms NameForms}.
       * @return An immutable instance of NameForms
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableConstitution.NameForms build() {
        checkRequiredAttributes();
        return new ImmutableConstitution.NameForms(this);
      }

      private boolean absoluteIsSet() {
        return (optBits & OPT_BIT_ABSOLUTE) != 0;
      }

      private boolean absoluteRawIsSet() {
        return (optBits & OPT_BIT_ABSOLUTE_RAW) != 0;
      }

      private boolean genericArgsIsSet() {
        return (optBits & OPT_BIT_GENERIC_ARGS) != 0;
      }

      private boolean relativeAlreadyQualifiedIsSet() {
        return (optBits & OPT_BIT_RELATIVE_ALREADY_QUALIFIED) != 0;
      }

      private boolean simpleIsSet() {
        return (initBits & INIT_BIT_SIMPLE) == 0;
      }

      private boolean relativeRawIsSet() {
        return (initBits & INIT_BIT_RELATIVE_RAW) == 0;
      }

      private boolean packageOfIsSet() {
        return (initBits & INIT_BIT_PACKAGE_OF) == 0;
      }

      private boolean visibilityIsSet() {
        return (initBits & INIT_BIT_VISIBILITY) == 0;
      }

      private static void checkNotIsSet(boolean isSet, String name) {
        if (isSet) throw new IllegalStateException("Builder of NameForms is strict, attribute is already set: ".concat(name));
      }

      private void checkRequiredAttributes() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if (!simpleIsSet()) attributes.add("simple");
        if (!relativeRawIsSet()) attributes.add("relativeRaw");
        if (!packageOfIsSet()) attributes.add("packageOf");
        if (!visibilityIsSet()) attributes.add("visibility");
        return "Cannot build NameForms, some of required attributes are not set " + attributes;
      }
    }
  }
}
