package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.lang.model.element.TypeElement;

/**
 * Immutable implementation of {@link AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableThirdPartyAttributeBuilderStrategy.of()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy"})
@Immutable
final class ImmutableThirdPartyAttributeBuilderStrategy
    extends AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy {
  private final @Nullable AttributeBuilderThirdPartyModel builderModel;
  private final @Nullable TypeElement attributeValueType;
  private final @Nullable AttributeBuilderDescriptor attributeBuilderDescriptor;

  private ImmutableThirdPartyAttributeBuilderStrategy(
      @Nullable AttributeBuilderThirdPartyModel builderModel,
      @Nullable TypeElement attributeValueType) {
    this.builderModel = builderModel;
    this.attributeValueType = attributeValueType;
    this.attributeBuilderDescriptor = super.getAttributeBuilderDescriptor();
  }

  /**
   * @return The value of the {@code builderModel} attribute
   */
  @Override
  protected @Nullable AttributeBuilderThirdPartyModel builderModel() {
    return builderModel;
  }

  /**
   * @return The value of the {@code attributeValueType} attribute
   */
  @Override
  protected @Nullable TypeElement attributeValueType() {
    return attributeValueType;
  }

  /**
   * @return The computed-at-construction value of the {@code attributeBuilderDescriptor} attribute
   */
  @Override
  public @Nullable AttributeBuilderDescriptor getAttributeBuilderDescriptor() {
    return attributeBuilderDescriptor;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy#builderModel() builderModel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builderModel (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThirdPartyAttributeBuilderStrategy withBuilderModel(@Nullable AttributeBuilderThirdPartyModel value) {
    if (this.builderModel == value) return this;
    return new ImmutableThirdPartyAttributeBuilderStrategy(value, this.attributeValueType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy#attributeValueType() attributeValueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributeValueType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableThirdPartyAttributeBuilderStrategy withAttributeValueType(@Nullable TypeElement value) {
    if (this.attributeValueType == value) return this;
    return new ImmutableThirdPartyAttributeBuilderStrategy(this.builderModel, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableThirdPartyAttributeBuilderStrategy} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableThirdPartyAttributeBuilderStrategy
        && equalTo((ImmutableThirdPartyAttributeBuilderStrategy) another);
  }

  private boolean equalTo(ImmutableThirdPartyAttributeBuilderStrategy another) {
    return Objects.equals(builderModel, another.builderModel)
        && Objects.equals(attributeValueType, another.attributeValueType)
        && Objects.equals(attributeBuilderDescriptor, another.attributeBuilderDescriptor);
  }

  /**
   * Computes a hash code from attributes: {@code builderModel}, {@code attributeValueType}, {@code attributeBuilderDescriptor}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(builderModel);
    h += (h << 5) + Objects.hashCode(attributeValueType);
    h += (h << 5) + Objects.hashCode(attributeBuilderDescriptor);
    return h;
  }

  /**
   * Prints the immutable value {@code ThirdPartyAttributeBuilderStrategy} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ThirdPartyAttributeBuilderStrategy")
        .omitNullValues()
        .add("builderModel", builderModel)
        .add("attributeValueType", attributeValueType)
        .add("attributeBuilderDescriptor", attributeBuilderDescriptor)
        .toString();
  }

  /**
   * Construct a new immutable {@code ThirdPartyAttributeBuilderStrategy} instance.
   * @param builderModel The value for the {@code builderModel} attribute
   * @param attributeValueType The value for the {@code attributeValueType} attribute
   * @return An immutable ThirdPartyAttributeBuilderStrategy instance
   */
  public static ImmutableThirdPartyAttributeBuilderStrategy of(@Nullable AttributeBuilderThirdPartyModel builderModel, @Nullable TypeElement attributeValueType) {
    return new ImmutableThirdPartyAttributeBuilderStrategy(builderModel, attributeValueType);
  }

  /**
   * Creates an immutable copy of a {@link AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ThirdPartyAttributeBuilderStrategy instance
   */
  public static ImmutableThirdPartyAttributeBuilderStrategy copyOf(AttributeBuilderReflection.ThirdPartyAttributeBuilderStrategy instance) {
    if (instance instanceof ImmutableThirdPartyAttributeBuilderStrategy) {
      return (ImmutableThirdPartyAttributeBuilderStrategy) instance;
    }
    return ImmutableThirdPartyAttributeBuilderStrategy.of(instance.builderModel(), instance.attributeValueType());
  }
}
