package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.lang.model.element.TypeElement;

/**
 * Immutable implementation of {@link NullabilityAnnotationInfo}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNullabilityAnnotationInfo.of()}.
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "NullabilityAnnotationInfo"})
@Immutable
final class ImmutableNullabilityAnnotationInfo
    extends NullabilityAnnotationInfo {
  private final TypeElement element;
  private final String qualifiedName;
  private final String simpleName;

  private ImmutableNullabilityAnnotationInfo(TypeElement element) {
    this.element = Objects.requireNonNull(element, "element");
    this.qualifiedName = initShim.qualifiedName();
    this.simpleName = initShim.simpleName();
    this.initShim = null;
  }

  private ImmutableNullabilityAnnotationInfo(ImmutableNullabilityAnnotationInfo original, TypeElement element) {
    this.element = element;
    this.qualifiedName = initShim.qualifiedName();
    this.simpleName = initShim.simpleName();
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private String qualifiedName;
    private int qualifiedNameBuildStage;

    String qualifiedName() {
      if (qualifiedNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (qualifiedNameBuildStage == STAGE_UNINITIALIZED) {
        qualifiedNameBuildStage = STAGE_INITIALIZING;
        this.qualifiedName = Objects.requireNonNull(ImmutableNullabilityAnnotationInfo.super.qualifiedName(), "qualifiedName");
        qualifiedNameBuildStage = STAGE_INITIALIZED;
      }
      return this.qualifiedName;
    }
    private String simpleName;
    private int simpleNameBuildStage;

    String simpleName() {
      if (simpleNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (simpleNameBuildStage == STAGE_UNINITIALIZED) {
        simpleNameBuildStage = STAGE_INITIALIZING;
        this.simpleName = Objects.requireNonNull(ImmutableNullabilityAnnotationInfo.super.simpleName(), "simpleName");
        simpleNameBuildStage = STAGE_INITIALIZED;
      }
      return this.simpleName;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = Lists.newArrayList();
      if (qualifiedNameBuildStage == STAGE_INITIALIZING) attributes.add("qualifiedName");
      if (simpleNameBuildStage == STAGE_INITIALIZING) attributes.add("simpleName");
      return "Cannot build NullabilityAnnotationInfo, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code element} attribute
   */
  @Override
  TypeElement element() {
    return element;
  }

  /**
   * @return The computed-at-construction value of the {@code qualifiedName} attribute
   */
  @Override
  String qualifiedName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.qualifiedName()
        : this.qualifiedName;
  }

  /**
   * @return The computed-at-construction value of the {@code simpleName} attribute
   */
  @Override
  String simpleName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.simpleName()
        : this.simpleName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullabilityAnnotationInfo#element() element} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for element
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullabilityAnnotationInfo withElement(TypeElement value) {
    if (this.element == value) return this;
    TypeElement newValue = Objects.requireNonNull(value, "element");
    return validate(new ImmutableNullabilityAnnotationInfo(this, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullabilityAnnotationInfo} that have equal attribute values.
   * As instances of the {@code ImmutableNullabilityAnnotationInfo} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(ImmutableNullabilityAnnotationInfo another) {
    return qualifiedName.equals(another.qualifiedName)
        && simpleName.equals(another.simpleName);
  }

  /**
   * Computes a hash code from attributes: {@code qualifiedName}, {@code simpleName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + qualifiedName.hashCode();
    h += (h << 5) + simpleName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NullabilityAnnotationInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullabilityAnnotationInfo")
        .omitNullValues()
        .add("qualifiedName", qualifiedName)
        .add("simpleName", simpleName)
        .toString();
  }

  private volatile long lazyInitBitmap;

  private static final long AS_PREFIX_LAZY_INIT_BIT = 0x1L;

  private String asPrefix;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link NullabilityAnnotationInfo#asPrefix() asPrefix} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code l.name} attribute
   */
  @Override
  public String asPrefix() {
    if ((lazyInitBitmap & AS_PREFIX_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AS_PREFIX_LAZY_INIT_BIT) == 0) {
          this.asPrefix = Objects.requireNonNull(super.asPrefix(), "asPrefix");
          lazyInitBitmap |= AS_PREFIX_LAZY_INIT_BIT;
        }
      }
    }
    return asPrefix;
  }

  private static final long AS_LOCAL_PREFIX_LAZY_INIT_BIT = 0x2L;

  private String asLocalPrefix;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link NullabilityAnnotationInfo#asLocalPrefix() asLocalPrefix} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * @return A lazily initialized value of the {@code l.name} attribute
   */
  @Override
  public String asLocalPrefix() {
    if ((lazyInitBitmap & AS_LOCAL_PREFIX_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & AS_LOCAL_PREFIX_LAZY_INIT_BIT) == 0) {
          this.asLocalPrefix = Objects.requireNonNull(super.asLocalPrefix(), "asLocalPrefix");
          lazyInitBitmap |= AS_LOCAL_PREFIX_LAZY_INIT_BIT;
        }
      }
    }
    return asLocalPrefix;
  }

  private static class InternProxy {
    final ImmutableNullabilityAnnotationInfo instance;

    InternProxy(ImmutableNullabilityAnnotationInfo instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

  /**
   * Construct a new immutable {@code NullabilityAnnotationInfo} instance.
   * @param element The value for the {@code element} attribute
   * @return An immutable NullabilityAnnotationInfo instance
   */
  public static ImmutableNullabilityAnnotationInfo of(TypeElement element) {
    return validate(new ImmutableNullabilityAnnotationInfo(element));
  }


  private static ImmutableNullabilityAnnotationInfo validate(ImmutableNullabilityAnnotationInfo instance) {
    return INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link NullabilityAnnotationInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullabilityAnnotationInfo instance
   */
  public static ImmutableNullabilityAnnotationInfo copyOf(NullabilityAnnotationInfo instance) {
    if (instance instanceof ImmutableNullabilityAnnotationInfo) {
      return (ImmutableNullabilityAnnotationInfo) instance;
    }
    return ImmutableNullabilityAnnotationInfo.of(instance.element());
  }
}
