/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;

public class $EncElementMirror
implements .processor..Mirrors.EncElement {
    public static final String QUALIFIED_NAME = "org.immutables.encode.EncodingMetadata.Element";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.encode.Mirrors.$EncElement";
    private final AnnotationMirror annotationMirror;
    private final String name;
    private final String type;
    private final String naming;
    private final String stdNaming;
    private final String[] tags;
    private final String[] typeParams;
    private final String[] params;
    private final String[] thrown;
    private final String code;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Element";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$EncElementMirror> find(Element element) {
        return $EncElementMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$EncElementMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $EncElementMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$EncElementMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $EncElementMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $EncElementMirror from(TypeElement element) {
        return new $EncElementMirror(element);
    }

    public static $Optional<$EncElementMirror> from(AnnotationMirror mirror) {
        return $EncElementMirror.find(Collections.singleton(mirror));
    }

    private $EncElementMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        String name = null;
        String type = null;
        String naming = null;
        String stdNaming = null;
        String[] tags = null;
        String[] typeParams = null;
        String[] params = null;
        String[] thrown = null;
        String code = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("name".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                NameExtractor nameExtractor$ = new NameExtractor();
                annotationValue$.accept(nameExtractor$, null);
                name = nameExtractor$.get();
                continue;
            }
            if ("type".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                TypeExtractor typeExtractor$ = new TypeExtractor();
                annotationValue$.accept(typeExtractor$, null);
                type = typeExtractor$.get();
                continue;
            }
            if ("naming".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                NamingExtractor namingExtractor$ = new NamingExtractor();
                annotationValue$.accept(namingExtractor$, null);
                naming = namingExtractor$.get();
                continue;
            }
            if ("stdNaming".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                StdNamingExtractor stdNamingExtractor$ = new StdNamingExtractor();
                annotationValue$.accept(stdNamingExtractor$, null);
                stdNaming = stdNamingExtractor$.get();
                continue;
            }
            if ("tags".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                TagsExtractor tagsExtractor$ = new TagsExtractor();
                annotationValue$.accept(tagsExtractor$, null);
                tags = tagsExtractor$.get();
                continue;
            }
            if ("typeParams".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                TypeParamsExtractor typeParamsExtractor$ = new TypeParamsExtractor();
                annotationValue$.accept(typeParamsExtractor$, null);
                typeParams = typeParamsExtractor$.get();
                continue;
            }
            if ("params".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                ParamsExtractor paramsExtractor$ = new ParamsExtractor();
                annotationValue$.accept(paramsExtractor$, null);
                params = paramsExtractor$.get();
                continue;
            }
            if ("thrown".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                ThrownExtractor thrownExtractor$ = new ThrownExtractor();
                annotationValue$.accept(thrownExtractor$, null);
                thrown = thrownExtractor$.get();
                continue;
            }
            if (!"code".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
            }
            CodeExtractor codeExtractor$ = new CodeExtractor();
            annotationValue$.accept(codeExtractor$, null);
            code = codeExtractor$.get();
        }
        this.name = $Preconditions.checkNotNull(name, "default attribute 'name'");
        this.type = $Preconditions.checkNotNull(type, "default attribute 'type'");
        this.naming = $Preconditions.checkNotNull(naming, "default attribute 'naming'");
        this.stdNaming = $Preconditions.checkNotNull(stdNaming, "default attribute 'stdNaming'");
        this.tags = $Preconditions.checkNotNull(tags, "default attribute 'tags'");
        this.typeParams = $Preconditions.checkNotNull(typeParams, "default attribute 'typeParams'");
        this.params = $Preconditions.checkNotNull(params, "default attribute 'params'");
        this.thrown = $Preconditions.checkNotNull(thrown, "default attribute 'thrown'");
        this.code = $Preconditions.checkNotNull(code, "default attribute 'code'");
    }

    private $EncElementMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String name = null;
        String type = null;
        String naming = null;
        String stdNaming = null;
        String[] tags = null;
        String[] typeParams = null;
        String[] params = null;
        String[] thrown = null;
        String code = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("name".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'name' attribute of @Element");
                }
                NameExtractor nameExtractor$ = new NameExtractor();
                annotationValue$.accept(nameExtractor$, null);
                name = nameExtractor$.get();
                continue;
            }
            if ("type".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'type' attribute of @Element");
                }
                TypeExtractor typeExtractor$ = new TypeExtractor();
                annotationValue$.accept(typeExtractor$, null);
                type = typeExtractor$.get();
                continue;
            }
            if ("naming".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'naming' attribute of @Element");
                }
                NamingExtractor namingExtractor$ = new NamingExtractor();
                annotationValue$.accept(namingExtractor$, null);
                naming = namingExtractor$.get();
                continue;
            }
            if ("stdNaming".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'stdNaming' attribute of @Element");
                }
                StdNamingExtractor stdNamingExtractor$ = new StdNamingExtractor();
                annotationValue$.accept(stdNamingExtractor$, null);
                stdNaming = stdNamingExtractor$.get();
                continue;
            }
            if ("tags".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'tags' attribute of @Element");
                }
                TagsExtractor tagsExtractor$ = new TagsExtractor();
                annotationValue$.accept(tagsExtractor$, null);
                tags = tagsExtractor$.get();
                continue;
            }
            if ("typeParams".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeParams' attribute of @Element");
                }
                TypeParamsExtractor typeParamsExtractor$ = new TypeParamsExtractor();
                annotationValue$.accept(typeParamsExtractor$, null);
                typeParams = typeParamsExtractor$.get();
                continue;
            }
            if ("params".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'params' attribute of @Element");
                }
                ParamsExtractor paramsExtractor$ = new ParamsExtractor();
                annotationValue$.accept(paramsExtractor$, null);
                params = paramsExtractor$.get();
                continue;
            }
            if ("thrown".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'thrown' attribute of @Element");
                }
                ThrownExtractor thrownExtractor$ = new ThrownExtractor();
                annotationValue$.accept(thrownExtractor$, null);
                thrown = thrownExtractor$.get();
                continue;
            }
            if (!"code".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'code' attribute of @Element");
            }
            CodeExtractor codeExtractor$ = new CodeExtractor();
            annotationValue$.accept(codeExtractor$, null);
            code = codeExtractor$.get();
        }
        this.name = $Preconditions.checkNotNull(name, "value for 'name'");
        this.type = $Preconditions.checkNotNull(type, "value for 'type'");
        this.naming = $Preconditions.checkNotNull(naming, "value for 'naming'");
        this.stdNaming = $Preconditions.checkNotNull(stdNaming, "value for 'stdNaming'");
        this.tags = $Preconditions.checkNotNull(tags, "value for 'tags'");
        this.typeParams = $Preconditions.checkNotNull(typeParams, "value for 'typeParams'");
        this.params = $Preconditions.checkNotNull(params, "value for 'params'");
        this.thrown = $Preconditions.checkNotNull(thrown, "value for 'thrown'");
        this.code = $Preconditions.checkNotNull(code, "value for 'code'");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String naming() {
        return this.naming;
    }

    @Override
    public String stdNaming() {
        return this.stdNaming;
    }

    @Override
    public String[] tags() {
        return (String[])this.tags.clone();
    }

    @Override
    public String[] typeParams() {
        return (String[])this.typeParams.clone();
    }

    @Override
    public String[] params() {
        return (String[])this.params.clone();
    }

    @Override
    public String[] thrown() {
        return (String[])this.thrown.clone();
    }

    @Override
    public String code() {
        return this.code;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return .processor..Mirrors.EncElement.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "name".hashCode() ^ this.name.hashCode();
        h += 127 * "type".hashCode() ^ this.type.hashCode();
        h += 127 * "naming".hashCode() ^ this.naming.hashCode();
        h += 127 * "stdNaming".hashCode() ^ this.stdNaming.hashCode();
        h += 127 * "tags".hashCode() ^ Arrays.hashCode(this.tags);
        h += 127 * "typeParams".hashCode() ^ Arrays.hashCode(this.typeParams);
        h += 127 * "params".hashCode() ^ Arrays.hashCode(this.params);
        h += 127 * "thrown".hashCode() ^ Arrays.hashCode(this.thrown);
        return h += 127 * "code".hashCode() ^ this.code.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $EncElementMirror) {
            $EncElementMirror otherMirror = ($EncElementMirror)other;
            return this.name.equals(otherMirror.name) && this.type.equals(otherMirror.type) && this.naming.equals(otherMirror.naming) && this.stdNaming.equals(otherMirror.stdNaming) && Arrays.equals(this.tags, otherMirror.tags) && Arrays.equals(this.typeParams, otherMirror.typeParams) && Arrays.equals(this.params, otherMirror.params) && Arrays.equals(this.thrown, otherMirror.thrown) && this.code.equals(otherMirror.code);
        }
        return false;
    }

    @Override
    public String toString() {
        return "EncElementMirror:" + this.annotationMirror;
    }

    private static class CodeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CodeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'code' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class ThrownExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private ThrownExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'thrown' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class ParamsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private ParamsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'params' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class TypeParamsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TypeParamsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeParams' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class TagsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TagsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            $Verify.verify(this.position == 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'tags' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class StdNamingExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private StdNamingExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'stdNaming' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class NamingExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NamingExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'naming' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class TypeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'type' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class NameExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NameExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'name' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }
}

