/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.processor.meta.AttributeBuilderDescriptor;
import org.immutables.value.processor.meta.AttributeBuilderReflection;
import org.immutables.value.processor.meta.ValueAttribute;

final class ValueAttributeFunctions {
    private ValueAttributeFunctions() {
    }

    public static Predicate<ValueAttribute> isGenerateDefault() {
        return IsGenerateDefaultPredicate.INSTANCE;
    }

    public static Predicate<ValueAttribute> isGenerateDerived() {
        return IsGenerateDerivedPredicate.INSTANCE;
    }

    public static Predicate<ValueAttribute> isGenerateAbstract() {
        return IsGenerateAbstractPredicate.INSTANCE;
    }

    public static Predicate<ValueAttribute> isPrimitive() {
        return IsPrimitivePredicate.INSTANCE;
    }

    public static Predicate<ValueAttribute> isAttributeBuilder() {
        return AttributeBuilderPredicate.INSTANCE;
    }

    public static Predicate<ValueAttribute> isListType() {
        return IsListType.INSTANCE;
    }

    public static Predicate<ValueAttribute> uniqueOnAttributeBuilderDescriptor() {
        return new UniqueOnAttributeBuilderDescriptor();
    }

    private static enum IsGenerateDefaultPredicate implements Predicate<ValueAttribute>
    {
        INSTANCE;


        public boolean apply(ValueAttribute input) {
            return input.isGenerateDefault;
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".isGenerateDefault()";
        }
    }

    private static enum IsGenerateDerivedPredicate implements Predicate<ValueAttribute>
    {
        INSTANCE;


        public boolean apply(ValueAttribute input) {
            return input.isGenerateDerived;
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".isGenerateDerived()";
        }
    }

    private static enum IsGenerateAbstractPredicate implements Predicate<ValueAttribute>
    {
        INSTANCE;


        public boolean apply(ValueAttribute input) {
            return input.isGenerateAbstract;
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".isGenerateAbstract()";
        }
    }

    private static enum IsPrimitivePredicate implements Predicate<ValueAttribute>
    {
        INSTANCE;


        public boolean apply(ValueAttribute input) {
            return input.isPrimitive();
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".isPrimitive()";
        }
    }

    private static enum AttributeBuilderPredicate implements Predicate<ValueAttribute>
    {
        INSTANCE;


        public boolean apply(ValueAttribute input) {
            return AttributeBuilderReflection.forValueType(input).isAttributeBuilder();
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".isAttributeBuilder()";
        }
    }

    private static enum IsListType implements Predicate<ValueAttribute>
    {
        INSTANCE;


        public boolean apply(ValueAttribute input) {
            return input.isListType();
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".isListType()";
        }
    }

    private static class UniqueOnAttributeBuilderDescriptor
    implements Predicate<ValueAttribute> {
        Set<AttributeBuilderDescriptor> uniqueSet = new HashSet<AttributeBuilderDescriptor>();

        @Nullable
        public boolean apply(ValueAttribute valueAttribute) {
            if (this.uniqueSet.contains(Preconditions.checkNotNull((Object)valueAttribute.getAttributeBuilderDescriptor()))) {
                return false;
            }
            this.uniqueSet.add(valueAttribute.getAttributeBuilderDescriptor());
            return true;
        }

        public String toString() {
            return ValueAttributeFunctions.class.getSimpleName() + ".uniqueOnAttributeBuilderDescriptor()";
        }
    }
}

