/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.meta.ValueMirrors;

public class IncludeMirror
implements ValueMirrors.Include {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Include";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.ValueMirrors.Include";
    private final AnnotationMirror annotationMirror;
    private final TypeMirror[] value;
    private final String[] valueName;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Include";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<IncludeMirror> find(Element element) {
        return IncludeMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<IncludeMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new IncludeMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<IncludeMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new IncludeMirror(annotationMirror));
        }
        return builder.build();
    }

    public static IncludeMirror from(TypeElement element) {
        return new IncludeMirror(element);
    }

    public static Optional<IncludeMirror> from(AnnotationMirror mirror) {
        return IncludeMirror.find(Collections.singleton(mirror));
    }

    private IncludeMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        TypeMirror[] value = null;
        String[] valueName = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Include");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
            valueName = valueExtractor$.name();
        }
        this.value = (TypeMirror[])Preconditions.checkNotNull(value, (Object)"default attribute 'value'");
        this.valueName = (String[])Preconditions.checkNotNull(valueName, (Object)"default attribute 'value'");
    }

    private IncludeMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        TypeMirror[] value = null;
        String[] valueName = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            String name$ = attributeElement$.getSimpleName().toString();
            if (!"value".equals(name$)) continue;
            AnnotationValue annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @Include");
            }
            ValueExtractor valueExtractor$ = new ValueExtractor();
            annotationValue$.accept(valueExtractor$, null);
            value = valueExtractor$.get();
            valueName = valueExtractor$.name();
        }
        this.value = (TypeMirror[])Preconditions.checkNotNull(value, (Object)"value for 'value'");
        this.valueName = (String[])Preconditions.checkNotNull(valueName, (Object)"Value for 'value'");
    }

    public String[] valueName() {
        return (String[])this.valueName.clone();
    }

    public TypeMirror[] valueMirror() {
        return (TypeMirror[])this.value.clone();
    }

    @Override
    @Deprecated
    public Class<?>[] value() {
        throw new UnsupportedOperationException("Use 'valueMirror()' or 'valueName()'");
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ValueMirrors.Include.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h += 127 * "value".hashCode() ^ Arrays.hashCode(this.valueName);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IncludeMirror) {
            IncludeMirror otherMirror = (IncludeMirror)other;
            return Arrays.equals(this.valueName, otherMirror.valueName);
        }
        return false;
    }

    @Override
    public String toString() {
        return "IncludeMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private ValueExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.value.Value.Include");
        }
    }
}

