/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.immutables.generator.SourceTypes;
import org.immutables.value.processor.encode.Type;
import org.immutables.value.processor.meta.LongBits;
import org.immutables.value.processor.meta.Reporter;
import org.immutables.value.processor.meta.ValueAttribute;

public final class FromSupertypesModel {
    private final ProcessingEnvironment processing;
    private static final AtomicBoolean typeParseExceptionReported = new AtomicBoolean();
    public final ImmutableList<FromSupertype> supertypes;
    public final ImmutableList<String> repeating;
    public final LongBits.LongPositions positions;
    private final Reporter reporter;

    FromSupertypesModel(Reporter reporter, String abstractTypeName, Collection<ValueAttribute> attributes, ImmutableListMultimap<String, TypeElement> accessorMapping, ProcessingEnvironment processing, List<TypeElement> extendedClasses, Set<TypeElement> implementedInterfaces) {
        this.reporter = reporter;
        this.processing = processing;
        HashMultimap typesByAttribute = HashMultimap.create();
        for (ValueAttribute a : attributes) {
            String name = a.name();
            for (Object t : Iterables.concat(implementedInterfaces, extendedClasses)) {
                if (this.isEligibleFromType((TypeElement)t, a)) {
                    ArrayList<String> arrayList = new ArrayList<String>(t.getTypeParameters().size());
                    for (TypeParameterElement typeParameterElement : t.getTypeParameters()) {
                        arrayList.add(typeParameterElement.toString());
                    }
                    typesByAttribute.put((Object)name, (Object)SourceTypes.stringify((Map.Entry)Maps.immutableEntry((Object)t.getQualifiedName().toString(), arrayList)));
                    continue;
                }
                typesByAttribute.put((Object)name, (Object)abstractTypeName);
            }
        }
        SetMultimap attributeByType = (SetMultimap)Multimaps.invertFrom((Multimap)typesByAttribute, (Multimap)HashMultimap.create());
        HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)attributes.size());
        for (ValueAttribute a : attributes) {
            attributeMap.put(a.name(), a);
        }
        Function getAttribute = Functions.forMap((Map)attributeMap);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : attributeByType.asMap().entrySet()) {
            builder.add((Object)new FromSupertype((String)entry.getKey(), Iterables.transform((Iterable)((Iterable)entry.getValue()), (Function)getAttribute)));
        }
        if (!attributeByType.containsKey((Object)abstractTypeName)) {
            builder.add((Object)new FromSupertype(abstractTypeName, (Iterable<ValueAttribute>)ImmutableList.of()));
        }
        this.supertypes = builder.build();
        ImmutableList.Builder repeatingBuilder = ImmutableList.builder();
        for (Map.Entry e : typesByAttribute.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() <= 1) continue;
            repeatingBuilder.add((Object)((String)e.getKey()));
        }
        this.repeating = repeatingBuilder.build();
        this.positions = new LongBits().apply((Iterable<? extends Object>)this.repeating);
    }

    private boolean isDirectAncestor(TypeElement parent, TypeElement child) {
        TypeMirror erasedParent;
        Types typeUtils = this.processing.getTypeUtils();
        if (typeUtils.isSameType(erasedParent = typeUtils.erasure(parent.asType()), typeUtils.erasure(child.getSuperclass()))) {
            return true;
        }
        for (TypeMirror typeMirror : child.getInterfaces()) {
            if (!typeUtils.isSameType(erasedParent, typeUtils.erasure(typeMirror))) continue;
            return true;
        }
        return false;
    }

    private boolean boundsMatch(List<? extends TypeMirror> a, List<? extends TypeMirror> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (this.processing.getTypeUtils().isSameType(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isEligibleFromType(TypeElement typeElement, ValueAttribute attr) {
        block8: {
            ExecutableElement accessor = this.findMethod(typeElement, attr.names.get);
            if (accessor == null) {
                return false;
            }
            if (!typeElement.getTypeParameters().isEmpty()) {
                TypeElement containingTypeElement = (TypeElement)attr.containingType.originalElement();
                if (typeElement.getTypeParameters().size() != 1 || containingTypeElement.getTypeParameters().size() != 1) {
                    return false;
                }
                if (!this.isDirectAncestor(typeElement, containingTypeElement)) {
                    return false;
                }
                for (int i = 0; i < typeElement.getTypeParameters().size(); ++i) {
                    if (this.boundsMatch(typeElement.getTypeParameters().get(i).getBounds(), containingTypeElement.getTypeParameters().get(i).getBounds())) continue;
                    return false;
                }
            }
            try {
                String ownType = accessor.getReturnType().toString();
                String inheritedType = attr.returnType.toString();
                Type.Producer tf = new Type.Producer();
                Type.Parser parser = new Type.Parser(tf, tf.parameters());
                if (parser.parse(ownType).equals(parser.parse(inheritedType))) {
                    attr.initNullabilitySupertype(accessor);
                    return true;
                }
            }
            catch (Exception typeParseException) {
                if (!typeParseExceptionReported.compareAndSet(false, true)) break block8;
                this.reporter.warning("Type parsing problem in FromSupertypesModel: %s", typeParseException);
            }
        }
        this.reporter.warning(Reporter.About.FROM, "Generated builder '.from' method will not copy from attribute '%s' because it has different return type in supertype (And we cannot handle generic specialization or covariant overrides yet). Sometimes it is possible to avoid this by providing abstract override method in this value object", attr.name());
        return false;
    }

    @Nullable
    private ExecutableElement findMethod(TypeElement typeElement, String getter) {
        for (ExecutableElement m : ElementFilter.methodsIn(this.processing.getElementUtils().getAllMembers(typeElement))) {
            if (!m.getSimpleName().contentEquals(getter) || !m.getParameters().isEmpty()) continue;
            return m;
        }
        return null;
    }

    public boolean hasManySupertypes() {
        return this.supertypes.size() > 1;
    }

    public boolean hasWildcards() {
        for (FromSupertype s : this.supertypes) {
            if (!s.hasGenerics) continue;
            return true;
        }
        return false;
    }

    public static final class FromSupertype {
        public final String type;
        public final String wildcard;
        public final boolean hasGenerics;
        public final ImmutableList<ValueAttribute> attributes;
        public final String raw;

        FromSupertype(String type, Iterable<ValueAttribute> attribute) {
            this.type = type;
            this.hasGenerics = type.indexOf(60) > 0;
            Map.Entry withArgs = SourceTypes.extract((CharSequence)type);
            this.raw = (String)withArgs.getKey();
            this.wildcard = this.hasGenerics ? SourceTypes.stringify((Map.Entry)Maps.immutableEntry((Object)((String)withArgs.getKey()), Collections.nCopies(((List)withArgs.getValue()).size(), "?"))) : type;
            this.attributes = ImmutableList.copyOf(attribute);
        }

        public String toString() {
            return this.type + " -> " + this.attributes;
        }
    }
}

